/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.platformsplugin.ui.platform;

import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.GroupContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.RootMenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarButtonGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarDescription;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPropertiesPage;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabaseType;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.PlatformsApplicationNode;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.PlatformsPlugin;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.platform.AddDatabaseTypeAction;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.platform.CloneDatabasePlatformAction;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.platform.DatabasePlatformTabbedPropertiesPage;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.platform.DeleteDatabasePlatformAction;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.platform.RenameDatabasePlatformAction;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.repository.DatabasePlatformRepositoryNode;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.type.DatabaseTypeNode;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.node.NodeModel;

public final class DatabasePlatformNode
extends PlatformsApplicationNode {
    private ListValueModel childrenModel;
    protected static final String[] DATABASE_PLATFORM_DISPLAY_STRING_PROPERTY_NAMES = new String[]{"name"};

    public DatabasePlatformNode(DatabasePlatform databasePlatform, DatabasePlatformRepositoryNode databasePlatformRepositoryNode, PlatformsPlugin platformsPlugin, ApplicationContext applicationContext) {
        super((NodeModel)databasePlatform, databasePlatformRepositoryNode, platformsPlugin, applicationContext);
    }

    protected void initialize() {
        super.initialize();
        this.childrenModel = this.buildChildrenModel();
    }

    private ListValueModel buildChildrenModel() {
        return new SortedListValueModelAdapter(this.buildDisplayStringAdapter());
    }

    private ListValueModel buildDisplayStringAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildDatabaseTypeNodeAdapter(), "displayString");
    }

    private ListValueModel buildDatabaseTypeNodeAdapter() {
        return new TransformationListValueModelAdapter(this.buildDatabaseTypesAdapter()){

            protected Object transformItem(Object object) {
                return DatabasePlatformNode.this.buildDatabaseTypeNode((DatabaseType)object);
            }
        };
    }

    DatabaseTypeNode buildDatabaseTypeNode(DatabaseType databaseType) {
        return new DatabaseTypeNode(databaseType, this, this.getPlatformsPlugin(), this.getApplicationContext());
    }

    private CollectionValueModel buildDatabaseTypesAdapter() {
        return new CollectionAspectAdapter(this, "databaseTypes"){

            protected Iterator getValueFromSubject() {
                return ((DatabasePlatform)this.subject).databaseTypes();
            }

            protected int sizeFromSubject() {
                return ((DatabasePlatform)this.subject).databaseTypesSize();
            }
        };
    }

    protected Class propertiesPageClass() {
        return DatabasePlatformTabbedPropertiesPage.class;
    }

    protected AbstractPropertiesPage buildPropertiesPage(WorkbenchContext workbenchContext) {
        return new DatabasePlatformTabbedPropertiesPage(workbenchContext);
    }

    public String helpTopicID() {
        return "database.platform";
    }

    public ListValueModel getChildrenModel() {
        return this.childrenModel;
    }

    protected String[] displayStringPropertyNames() {
        return DATABASE_PLATFORM_DISPLAY_STRING_PROPERTY_NAMES;
    }

    protected String buildIconKey() {
        return "DATABASE_PLATFORM";
    }

    public GroupContainerDescription buildMenuDescription(WorkbenchContext workbenchContext) {
        workbenchContext = this.buildLocalWorkbenchContext(workbenchContext);
        RootMenuDescription rootMenuDescription = new RootMenuDescription();
        MenuGroupDescription menuGroupDescription = new MenuGroupDescription();
        menuGroupDescription.add(this.buildRenameAction(workbenchContext));
        menuGroupDescription.add(this.buildDeleteAction(workbenchContext));
        menuGroupDescription.add(this.buildCloneAction(workbenchContext));
        menuGroupDescription.add(this.buildAddTypeAction(workbenchContext));
        rootMenuDescription.add(menuGroupDescription);
        MenuGroupDescription menuGroupDescription2 = new MenuGroupDescription();
        menuGroupDescription2.add(this.getPlatformsPlugin().getHelpAction(workbenchContext));
        rootMenuDescription.add(menuGroupDescription2);
        return rootMenuDescription;
    }

    public GroupContainerDescription buildToolBarDescription(WorkbenchContext workbenchContext) {
        workbenchContext = this.buildLocalWorkbenchContext(workbenchContext);
        ToolBarDescription toolBarDescription = new ToolBarDescription();
        ToolBarButtonGroupDescription toolBarButtonGroupDescription = new ToolBarButtonGroupDescription();
        toolBarButtonGroupDescription.add(this.buildRenameAction(workbenchContext));
        toolBarButtonGroupDescription.add(this.buildDeleteAction(workbenchContext));
        toolBarButtonGroupDescription.add(this.buildCloneAction(workbenchContext));
        toolBarButtonGroupDescription.add(this.buildAddTypeAction(workbenchContext));
        toolBarDescription.add(toolBarButtonGroupDescription);
        return toolBarDescription;
    }

    DatabasePlatform getDatabasePlatform() {
        return (DatabasePlatform)this.getValue();
    }

    private FrameworkAction buildRenameAction(WorkbenchContext workbenchContext) {
        return new RenameDatabasePlatformAction(workbenchContext);
    }

    private FrameworkAction buildDeleteAction(WorkbenchContext workbenchContext) {
        return new DeleteDatabasePlatformAction(workbenchContext);
    }

    private FrameworkAction buildCloneAction(WorkbenchContext workbenchContext) {
        return new CloneDatabasePlatformAction(workbenchContext);
    }

    private FrameworkAction buildAddTypeAction(WorkbenchContext workbenchContext) {
        return new AddDatabaseTypeAction(workbenchContext);
    }
}

