/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.platformsplugin.ui.platform;

import java.util.Iterator;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.NewNameDialog;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.platform.DatabasePlatformNode;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

final class RenameDatabasePlatformAction
extends AbstractFrameworkAction {
    public RenameDatabasePlatformAction(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    protected void initialize() {
        this.initializeTextAndMnemonic("RENAME_DATABASE_PLATFORM");
        this.initializeIcon("RENAME_DATABASE_PLATFORM");
        this.initializeToolTipText("RENAME_DATABASE_PLATFORM.TOOL_TIP");
    }

    protected void execute() {
        TreePath[] treePathArray = this.navigatorSelectionModel().getSelectionPaths();
        NewNameDialog.Builder builder = this.buildNewNameDialogBuilder();
        ApplicationNode[] applicationNodeArray = this.selectedNodes();
        int n = applicationNodeArray.length;
        while (n-- > 0) {
            this.execute(((DatabasePlatformNode)applicationNodeArray[n]).getDatabasePlatform(), builder);
        }
        this.navigatorSelectionModel().setSelectionPaths(treePathArray);
    }

    private NewNameDialog.Builder buildNewNameDialogBuilder() {
        NewNameDialog.Builder builder = new NewNameDialog.Builder();
        builder.setTitle(this.resourceRepository().getString("RENAME_DATABASE_PLATFORM_DIALOG_TITLE"));
        builder.setTextFieldDescription(this.resourceRepository().getString("RENAME_DATABASE_PLATFORM_DIALOG_DESCRIPTION"));
        builder.setHelpTopicId("dialog.dbPlatformRename");
        return builder;
    }

    protected void execute(DatabasePlatform databasePlatform, NewNameDialog.Builder builder) {
        builder.setExistingNames(this.existingPlatformNames(databasePlatform.getRepository()));
        builder.setOriginalName(databasePlatform.getName());
        NewNameDialog newNameDialog = builder.buildDialog(this.getWorkbenchContext());
        newNameDialog.show();
        if (newNameDialog.wasConfirmed()) {
            databasePlatform.setName(newNameDialog.getNewName());
        }
    }

    private Iterator existingPlatformNames(DatabasePlatformRepository databasePlatformRepository) {
        return new TransformationIterator(databasePlatformRepository.platforms()){

            protected Object transform(Object object) {
                return ((DatabasePlatform)object).getName();
            }
        };
    }
}

