/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.platformsplugin.ui.type;

import java.util.Iterator;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.NewNameDialog;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabaseType;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.type.DatabaseTypeNode;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

final class RenameDatabaseTypeAction
extends AbstractFrameworkAction {
    public RenameDatabaseTypeAction(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    protected void initialize() {
        this.initializeTextAndMnemonic("RENAME_DATABASE_TYPE");
        this.initializeIcon("RENAME_DATABASE_TYPE");
        this.initializeToolTipText("RENAME_DATABASE_TYPE.TOOL_TIP");
    }

    protected void execute() {
        TreePath[] treePathArray = this.navigatorSelectionModel().getSelectionPaths();
        NewNameDialog.Builder builder = this.buildNewNameDialogBuilder();
        ApplicationNode[] applicationNodeArray = this.selectedNodes();
        int n = applicationNodeArray.length;
        while (n-- > 0) {
            this.execute(((DatabaseTypeNode)applicationNodeArray[n]).getDatabaseType(), builder);
        }
        this.navigatorSelectionModel().setSelectionPaths(treePathArray);
    }

    private NewNameDialog.Builder buildNewNameDialogBuilder() {
        NewNameDialog.Builder builder = new NewNameDialog.Builder();
        builder.setTitle(this.resourceRepository().getString("RENAME_DATABASE_TYPE_DIALOG_TITLE"));
        builder.setTextFieldDescription(this.resourceRepository().getString("RENAME_DATABASE_TYPE_DIALOG_DESCRIPTION"));
        builder.setHelpTopicId("dialog.dbTypeRename");
        return builder;
    }

    protected void execute(DatabaseType databaseType, NewNameDialog.Builder builder) {
        builder.setExistingNames(this.existingTypeNames(databaseType.getPlatform()));
        builder.setOriginalName(databaseType.getName());
        NewNameDialog newNameDialog = builder.buildDialog(this.getWorkbenchContext());
        newNameDialog.show();
        if (newNameDialog.wasConfirmed()) {
            databaseType.setName(newNameDialog.getNewName());
        }
    }

    private Iterator existingTypeNames(DatabasePlatform databasePlatform) {
        return new TransformationIterator(databasePlatform.databaseTypes()){

            protected Object transform(Object object) {
                return ((DatabaseType)object).getName();
            }
        };
    }
}

