/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.eclipse.persistence.exceptions.SessionLoaderException;
import org.eclipse.persistence.tools.workbench.framework.OpenException;
import org.eclipse.persistence.tools.workbench.framework.Plugin;
import org.eclipse.persistence.tools.workbench.framework.UnsupportedFileException;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.ComponentContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.PreferencesNode;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarButtonGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.PreferencesContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.scplugin.SCPluginIconResourceFileNameMap;
import org.eclipse.persistence.tools.workbench.scplugin.SCPluginResourceBundle;
import org.eclipse.persistence.tools.workbench.scplugin.SCProblemsResourceBundle;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.meta.SCSessionsProperties;
import org.eclipse.persistence.tools.workbench.scplugin.model.meta.SCSessionsPropertiesManager;
import org.eclipse.persistence.tools.workbench.scplugin.ui.AddNewSessionsAction;
import org.eclipse.persistence.tools.workbench.scplugin.ui.preferences.SCPreferencesNode;
import org.eclipse.persistence.tools.workbench.scplugin.ui.project.ProjectNode;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class SCPlugin
implements Plugin {
    private SCSessionsPropertiesManager propertiesManager;
    private Map propertiesPageCache;
    private static final String SC_PREFERENCES_NODE = "sc";
    public static final String DATA_SOURCE_TYPE_PREFERENCE = "data source type";
    public static final String DEFAULT_CLASSPATH_PREFERENCE = "default classpath";
    public static final String NEW_NAME_BROKER_PREFERENCE = "new name.broker";
    public static final String NEW_NAME_POOL_PREFERENCE = "new name.pool";
    public static final String NEW_NAME_SESSION_PREFERENCE = "new name.session";
    public static final String DATABASE_PLATFORM_PREFERENCE = "platform.database";
    public static final String EIS_PLATFORM_PREFERENCE = "platform.eis";
    public static final String SERVER_PLATFORM_PREFERENCE = "platform.server";
    public static final String NEW_NAME_SESSIONS_CONFIGURATION_PREFERENCE = "new name.sessions configuration";
    public static final String DATABASE_PLATFORM_PREFERENCE_DEFAULT = "Oracle11";
    public static final String EIS_PLATFORM_PREFERENCE_DEFAULT = "AQPlatform";
    public static final String SERVER_PLATFORM_PREFERENCE_DEFAULT = "WebLogic_10_Platform";
    public static final String DATA_SOURCE_TYPE_PREFERENCE_EIS_CHOICE = "eis";
    public static final String DATA_SOURCE_TYPE_PREFERENCE_RELATIONAL_CHOICE = "relational";
    public static final String DATA_SOURCE_TYPE_PREFERENCE_XML_CHOICE = "xml";

    public SCPlugin() {
        this.initialize();
    }

    private void initialize() {
        this.propertiesPageCache = new HashMap();
    }

    public JMenuItem[] buildNewMenuItems(WorkbenchContext workbenchContext) {
        return new JMenuItem[]{this.buildNewConfigurationMenuItem(workbenchContext)};
    }

    public JMenuItem[] buildMigrateMenuItems(WorkbenchContext workbenchContext) {
        return new JMenuItem[0];
    }

    public ApplicationNode open(File file, WorkbenchContext workbenchContext) throws UnsupportedFileException, OpenException {
        if (!FileTools.extension((File)file).equalsIgnoreCase(".xml")) {
            throw new UnsupportedFileException();
        }
        WorkbenchContext workbenchContext2 = this.wrap(workbenchContext);
        try {
            SCSessionsProperties sCSessionsProperties = this.getSessionsProperties(workbenchContext2.getApplicationContext(), file);
            TopLinkSessionsAdapter topLinkSessionsAdapter = new TopLinkSessionsAdapter(sCSessionsProperties, workbenchContext2.getApplicationContext().getPreferences(), false);
            return new ProjectNode(topLinkSessionsAdapter, workbenchContext2.getApplicationContext().getNodeManager().getRootNode(), this, workbenchContext2.getApplicationContext());
        }
        catch (Throwable throwable) {
            throw new OpenException(throwable);
        }
    }

    public ComponentContainerDescription buildToolBarDescription(WorkbenchContext workbenchContext) {
        return new ToolBarButtonGroupDescription();
    }

    public ComponentContainerDescription buildMenuDescription(WorkbenchContext workbenchContext) {
        return new MenuGroupDescription();
    }

    public PreferencesNode[] buildPreferencesNodes(PreferencesContext preferencesContext) {
        return new PreferencesNode[]{new SCPreferencesNode((PreferencesContext)this.wrap(preferencesContext))};
    }

    public File nextUntitledFile(ApplicationContext applicationContext) {
        return this.getPropertiesManager(applicationContext).nextUntitledSessionsFile();
    }

    public void showWarning(WorkbenchContext workbenchContext, String string, Throwable throwable) {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = throwable.getLocalizedMessage();
        if (string2 != null) {
            stringBuffer.append(throwable.getLocalizedMessage());
        }
        if (stringBuffer.toString().startsWith(StringTools.CR)) {
            stringBuffer.replace(0, StringTools.CR.length(), "");
        }
        if (throwable instanceof SessionLoaderException && (object2 = (object = (SessionLoaderException)throwable).getExceptionList()) != null) {
            for (Throwable throwable2 : object.getExceptionList()) {
                stringBuffer.append(StringTools.CR);
                stringBuffer.append("***");
                stringBuffer.append(throwable2.getLocalizedMessage());
            }
        }
        if (stringBuffer.length() == 0) {
            object = new StringWriter();
            object2 = new PrintWriter((Writer)object);
            throwable.printStackTrace((PrintWriter)object2);
            stringBuffer.append(((StringWriter)object).toString());
        }
        JOptionPane.showMessageDialog(workbenchContext.getCurrentWindow(), this.buildErrorPaneArea(string, stringBuffer.toString()), workbenchContext.getApplicationContext().getApplication().getShortProductName(), 0);
    }

    private Component buildErrorPaneArea(String string, String string2) {
        JPanel jPanel = new JPanel(new BorderLayout(0, 1));
        LabelArea labelArea = new LabelArea(string);
        jPanel.add((Component)labelArea, "First");
        JTextArea jTextArea = new JTextArea(string2);
        jTextArea.setFont(labelArea.getFont());
        jTextArea.setTabSize(2);
        jPanel.add((Component)new JScrollPane(jTextArea), "Center");
        jPanel.setPreferredSize(new Dimension(350, Math.min(jPanel.getPreferredSize().height + 50, 150)));
        return jPanel;
    }

    private JMenuItem buildNewConfigurationMenuItem(WorkbenchContext workbenchContext) {
        return new JMenuItem(new AddNewSessionsAction(this.wrap(workbenchContext), this));
    }

    private WorkbenchContext wrap(WorkbenchContext workbenchContext) {
        return workbenchContext.buildExpandedApplicationContextWorkbenchContext(this.wrap(workbenchContext.getApplicationContext()));
    }

    private ApplicationContext wrap(ApplicationContext applicationContext) {
        ApplicationContext applicationContext2 = applicationContext.buildExpandedResourceRepositoryContext(SCPluginResourceBundle.class, new SCPluginIconResourceFileNameMap());
        applicationContext2 = applicationContext2.buildExpandedResourceRepositoryContext(SCProblemsResourceBundle.class);
        return applicationContext2.buildRedirectedPreferencesContext(SC_PREFERENCES_NODE);
    }

    public Component getPropertiesPage(Object object) {
        return (Component)this.propertiesPageCache.remove(object);
    }

    public void releasePropertiesPage(Object object, Component component) {
        this.propertiesPageCache.put(object, component);
    }

    private SCSessionsPropertiesManager getPropertiesManager(ApplicationContext applicationContext) {
        if (this.propertiesManager == null) {
            this.propertiesManager = this.loadSessionsProperties(applicationContext);
        }
        return this.propertiesManager;
    }

    public SCSessionsProperties getSessionsProperties(ApplicationContext applicationContext, File file) {
        return this.getPropertiesManager(applicationContext).getSessionsProperties(file);
    }

    private SCSessionsPropertiesManager loadSessionsProperties(ApplicationContext applicationContext) {
        Preferences preferences = applicationContext.getPreferences();
        return new SCSessionsPropertiesManager(preferences);
    }
}

