/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public abstract class SCPlatformManager {
    private Map platforms;

    protected SCPlatformManager() {
        this.initialize();
    }

    protected void initialize() {
        this.platforms = new HashMap();
        this.buidPlatforms();
    }

    protected void addPlatform(String string, String string2) {
        this.platforms.put(string, string2);
    }

    protected abstract void buidPlatforms();

    public Iterator platformIds() {
        return this.platforms.keySet().iterator();
    }

    public Iterator platformNames() {
        return this.platforms.values().iterator();
    }

    public Iterator platformShortNames() {
        return new TransformationIterator(this.platformNames()){

            protected Object transform(Object object) {
                return ClassTools.shortNameForClassNamed((String)((String)object));
            }
        };
    }

    public String getRuntimePlatformClassNameForClass(String string) {
        Iterator iterator = this.platformNames();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.endsWith(string)) continue;
            return string2;
        }
        throw new IllegalArgumentException("missing database type named: " + string);
    }

    public String getRuntimePlatformClassNameFor(String string) {
        return (String)this.platforms.get(string);
    }

    public String getIdFor(String string) {
        for (String string2 : this.platforms.keySet()) {
            String string3 = (String)this.platforms.get(string2);
            if (!string3.endsWith(string)) continue;
            return string2;
        }
        throw new IllegalArgumentException("missing plaform named: " + string);
    }

    public boolean serverPlatformIsSupported(String string) {
        if (StringTools.stringIsEmpty((String)string)) {
            return false;
        }
        return this.platforms.containsValue(string);
    }

    public int platformsSize() {
        return this.platforms.size();
    }
}

