/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.internal.sessions.factories.model.login.DatabaseLoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.LoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.StructConverterConfig;
import org.eclipse.persistence.internal.sessions.factories.model.sequencing.SequencingConfig;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DataSource;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.LoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.LoginHandler;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SequencingAdapter;
import org.eclipse.persistence.tools.workbench.utility.iterators.ArrayIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DatabaseLoginAdapter
extends LoginAdapter {
    public static final String DRIVER_CLASS_PROPERTY = "driverClass";
    public static final String CONNECTION_URL_PROPERTY = "connectionURL";
    public static final String DATA_SOURCE_PROPERTY = "dataSource";
    public static final String NATIVE_SEQUENCING_PROPERTY = "nativeSequencing";
    public static final String CONNECTION_HEALTH_VALIDATE_ON_ERROR_PROPERTY = "connectionHealthValidateOnError";
    public static final String DELAY_BETWEEN_CONNECTION_ATTEMPTS_PROPERTY = "delayBetweenConnectionAttempts";
    public static final String QUERY_RETRY_ATTEMPT_COUNT_PROPERTY = "queryRetryAttemptCount";
    public static final String PING_SQL_PROPERTY = "pingSQL";
    public static final String BIND_ALL_PARAMETERS_PROPERTY = "bindAllParameters";
    public static final String CACHE_ALL_STATEMENTS_PROPERTY = "cacheAllStatements";
    public static final String BYTE_ARRAY_BINDING_PROPERTY = "byteArrayBinding";
    public static final String STRING_BINDING_PROPERTY = "stringBinding";
    public static final String STREAMS_FOR_BINDING_PROPERTY = "streamsForBinding";
    public static final String FORCE_FIELD_NAMES_TO_UPPER_CASE_PROPERTY = "forceFieldNamesToUppercase";
    public static final String OPTIMIZE_DATA_CONVERSION_PROPERTY = "optimizeDataConversion";
    public static final String TRIM_STRINGS_PROPERTY = "trimStrings";
    public static final String BATCH_WRITING_PROPERTY = "batchWriting";
    public static final String JDBC_BATCH_WRITING_PROPERTY = "jdbcBatchWriting";
    public static final String MAX_BATCH_WRITING_SIZE_PROPERTY = "maxBatchWritingSize";
    public static final String NATIVE_SQL_PROPERTY = "nativeSQL";
    public static final String LOOKUP_TYPE_PROPERTY = "lookup";
    public static final String STRUCT_CONVERTER_COLLECTION_PROPERTY = "structConverters";
    private volatile boolean useDriverManager;
    public static final String USE_DRIVER_MANAGER_PROPERTY = "useDriverManager";
    private volatile boolean useProperties;
    public static final String USE_PROPERTIES_PROPERTY = "useProperties";
    private static Map driverClassesURLTable;

    DatabaseLoginAdapter(SCAdapter sCAdapter, DatabaseLoginConfig databaseLoginConfig) {
        super(sCAdapter, (LoginConfig)databaseLoginConfig);
    }

    protected DatabaseLoginAdapter(SCAdapter sCAdapter) {
        super(sCAdapter);
    }

    @Override
    protected Object buildModel() {
        DatabaseLoginConfig databaseLoginConfig = new DatabaseLoginConfig();
        databaseLoginConfig.setStructConverterConfig(new StructConverterConfig());
        return databaseLoginConfig;
    }

    protected StructConverterConfig buildStructConverters() {
        StructConverterConfig structConverterConfig = new StructConverterConfig();
        this.login().setStructConverterConfig(structConverterConfig);
        return structConverterConfig;
    }

    @Override
    protected SequencingAdapter buildSequencing() {
        SequencingAdapter sequencingAdapter = super.buildSequencing();
        this.login().setSequencingConfig((SequencingConfig)sequencingAdapter.getModel());
        return sequencingAdapter;
    }

    public String getDriverClassName() {
        return this.login().getDriverClass();
    }

    public void setDriverClassName(String string) {
        if (!this.useDriverManager) {
            throw new IllegalStateException();
        }
        String string2 = this.login().getDriverClass();
        this.login().setDriverClass(string);
        this.firePropertyChanged(DRIVER_CLASS_PROPERTY, string2, string);
    }

    public String getConnectionURL() {
        return this.login().getConnectionURL();
    }

    public void setConnectionURL(String string) {
        String string2 = this.login().getConnectionURL();
        this.login().setConnectionURL(string);
        this.firePropertyChanged(CONNECTION_URL_PROPERTY, string2, string);
    }

    public String getDataSourceName() {
        return this.login().getDatasource();
    }

    public void setDataSourceName(String string) {
        if (this.useDriverManager) {
            throw new IllegalStateException();
        }
        String string2 = this.login().getDatasource();
        this.login().setDatasource(string);
        this.firePropertyChanged(DATA_SOURCE_PROPERTY, string2, string);
    }

    @Override
    public boolean databaseDriverIsDriverManager() {
        return this.useDriverManager;
    }

    @Override
    public boolean databaseDriverIsDataSource() {
        return !this.useDriverManager;
    }

    public void setDatabaseDriverAsDataSource() {
        this.setDatabaseDriverType(false);
    }

    public void setDatabaseDriverAsDriverManager() {
        this.setDatabaseDriverType(true);
    }

    private void setDatabaseDriverType(boolean bl) {
        boolean bl2 = this.useDriverManager;
        if (bl2 == bl) {
            return;
        }
        this.clearDatabaseDriverData();
        this.useDriverManager = bl;
        this.firePropertyChanged(USE_DRIVER_MANAGER_PROPERTY, bl2, bl);
    }

    private void clearDatabaseDriverData() {
        if (this.useDriverManager) {
            this.setDriverClassName(null);
            this.setConnectionURL(null);
            ((LoginHandler)this.getParent()).setExternalConnectionPooling(true);
        } else {
            this.setDataSourceName(null);
        }
    }

    @Override
    public void toString(StringBuffer stringBuffer) {
        super.toString(stringBuffer);
        stringBuffer.append(", ").append(this.getDriverClassName());
    }

    private final DatabaseLoginConfig login() {
        return (DatabaseLoginConfig)this.getModel();
    }

    @Override
    protected void initializeDefaults() {
        super.initializeDefaults();
        this.useDriverManager = true;
        this.setByteArrayBinding(true);
        this.setOptimizeDataConversion(true);
        this.setTrimStrings(true);
        this.setMaxBatchWritingSize(32000);
        this.setJdbcBatchWriting(true);
        this.setLookupType(new Integer(2));
        this.setBindAllParameters(true);
    }

    @Override
    protected void initialize(Object object) {
        super.initialize(object);
        this.buildStructConverters();
    }

    @Override
    protected void initializeFromModel(Object object) {
        super.initializeFromModel(object);
        if (this.usesBatchWriting() && this.login().getMaxBatchWritingSize() == null) {
            this.login().setMaxBatchWritingSize(new Integer(0));
        }
        this.useDriverManager = StringTools.stringIsEmpty((String)this.getDataSourceName());
        Vector vector = this.login().getPropertyConfigs();
        boolean bl = this.useProperties = vector != null && !vector.isEmpty();
        if (this.login().getLookupType() == null) {
            this.login().setLookupType(new Integer(2));
        }
        if (this.login().getStructConverterConfig() == null) {
            this.buildStructConverters();
        }
    }

    @Override
    protected void postInitializationFromModel() {
        super.postInitializationFromModel();
        String string = this.convertToNewPlatformClass(this.getPlatformClass());
        if (string != null) {
            this.setPlatformClass(string);
        }
    }

    @Override
    protected String getDefaultPlatformClassName() {
        String string = this.preferences().get("platform.database", "Oracle11");
        DatabasePlatform databasePlatform = DatabasePlatformRepository.getDefault().platformNamed(string);
        return DataSource.getClassNameForDatabasePlatform(databasePlatform);
    }

    private String convertToNewPlatformClass(String string) {
        if (string == null) {
            return null;
        }
        return (String)this.oldPlatformClasses().get(string);
    }

    private Map oldPlatformClasses() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("org.eclipse.persistence.internal.databaseaccess.AttunityPlatform", "org.eclipse.persistence.platform.database.AttunityPlatform");
        hashtable.put("org.eclipse.persistence.internal.databaseaccess.CloudscapePlatform", "org.eclipse.persistence.platform.database.CloudscapePlatform");
        hashtable.put("org.eclipse.persistence.internal.databaseaccess.DB2Platform", "org.eclipse.persistence.platform.database.DB2Platform");
        hashtable.put("org.eclipse.persistence.internal.databaseaccess.DBasePlatform", "org.eclipse.persistence.platform.database.DBasePlatform");
        hashtable.put("org.eclipse.persistence.internal.databaseaccess.HSQLPlatform", "org.eclipse.persistence.platform.database.HSQLPlatform");
        hashtable.put("org.eclipse.persistence.internal.databaseaccess.InformixPlatform", "org.eclipse.persistence.platform.database.InformixPlatform");
        hashtable.put("org.eclipse.persistence.internal.databaseaccess.AccessPlatform", "org.eclipse.persistence.platform.database.AccessPlatform");
        hashtable.put("org.eclipse.persistence.internal.databaseaccess.OraclePlatform", "org.eclipse.persistence.platform.database.oracle.OraclePlatform");
        hashtable.put("org.eclipse.persistence.oraclespecific.Oracle8Platform", "org.eclipse.persistence.platform.database.oracle.Oracle8Platform");
        hashtable.put("org.eclipse.persistence.oraclespecific.Oracle9Platform", "org.eclipse.persistence.platform.database.oracle.Oracle9Platform");
        hashtable.put("org.eclipse.persistence.internal.databaseaccess.DatabasePlatform", "org.eclipse.persistence.platform.database.DatabasePlatform");
        hashtable.put("org.eclipse.persistence.internal.databaseaccess.PointBasePlatform", "org.eclipse.persistence.platform.database.PointBasePlatform");
        hashtable.put("org.eclipse.persistence.internal.databaseaccess.SQLAnyWherePlatform", "org.eclipse.persistence.platform.database.SQLAnywherePlatform");
        hashtable.put("org.eclipse.persistence.internal.databaseaccess.SQLServerPlatform", "org.eclipse.persistence.platform.database.SQLServerPlatform");
        hashtable.put("org.eclipse.persistence.internal.databaseaccess.SybasePlatform", "org.eclipse.persistence.platform.database.SybasePlatform");
        hashtable.put("org.eclipse.persistence.platform.database.SQLAnyWherePlatform", "org.eclipse.persistence.platform.database.SQLAnywherePlatform");
        return hashtable;
    }

    @Override
    boolean platformIsRdbms() {
        return true;
    }

    public boolean bindsAllParameters() {
        return this.login().getBindAllParameters();
    }

    public void setBindAllParameters(boolean bl) {
        boolean bl2 = this.login().getBindAllParameters();
        this.login().setBindAllParameters(bl);
        this.firePropertyChanged(BIND_ALL_PARAMETERS_PROPERTY, bl2, bl);
    }

    public boolean cachesAllStatements() {
        return this.login().getCacheAllStatements();
    }

    public void setCacheAllStatements(boolean bl) {
        boolean bl2 = this.login().getCacheAllStatements();
        this.login().setCacheAllStatements(bl);
        this.firePropertyChanged(CACHE_ALL_STATEMENTS_PROPERTY, bl2, bl);
    }

    public boolean usesByteArrayBinding() {
        return this.login().getByteArrayBinding();
    }

    public void setByteArrayBinding(boolean bl) {
        boolean bl2 = this.login().getByteArrayBinding();
        this.login().setByteArrayBinding(bl);
        this.firePropertyChanged(BYTE_ARRAY_BINDING_PROPERTY, bl2, bl);
    }

    public boolean usesStringBinding() {
        return this.login().getStringBinding();
    }

    public void setStringBinding(boolean bl) {
        boolean bl2 = this.login().getStringBinding();
        if (bl2 == bl) {
            return;
        }
        this.login().setStringBinding(bl);
        this.firePropertyChanged(STRING_BINDING_PROPERTY, bl2, bl);
        this.setDefaultMaxBatchWritingSize();
    }

    protected void setDefaultMaxBatchWritingSize() {
        if (this.usesStringBinding()) {
            this.setMaxBatchWritingSize(100);
        } else {
            this.setMaxBatchWritingSize(32000);
        }
    }

    public boolean usesStreamsForBinding() {
        return this.login().getStreamsForBinding();
    }

    public void setStreamsForBinding(boolean bl) {
        boolean bl2 = this.login().getStreamsForBinding();
        this.login().setStreamsForBinding(bl);
        this.firePropertyChanged(STREAMS_FOR_BINDING_PROPERTY, bl2, bl);
    }

    public boolean forcesFieldNamesToUppercase() {
        return this.login().getForceFieldNamesToUppercase();
    }

    public void setForceFieldNamesToUppercase(boolean bl) {
        boolean bl2 = this.login().getForceFieldNamesToUppercase();
        this.login().setForceFieldNamesToUppercase(bl);
        this.firePropertyChanged(FORCE_FIELD_NAMES_TO_UPPER_CASE_PROPERTY, bl2, bl);
    }

    public boolean optimizesDataConversion() {
        return this.login().getOptimizeDataConversion();
    }

    public void setOptimizeDataConversion(boolean bl) {
        boolean bl2 = this.login().getOptimizeDataConversion();
        this.login().setOptimizeDataConversion(bl);
        this.firePropertyChanged(OPTIMIZE_DATA_CONVERSION_PROPERTY, bl2, bl);
    }

    public boolean trimsStrings() {
        return this.login().getTrimStrings();
    }

    public void setTrimStrings(boolean bl) {
        boolean bl2 = this.login().getTrimStrings();
        this.login().setTrimStrings(bl);
        this.firePropertyChanged(TRIM_STRINGS_PROPERTY, bl2, bl);
    }

    public boolean usesBatchWriting() {
        return this.login().getBatchWriting();
    }

    public void setBatchWriting(boolean bl) {
        boolean bl2 = this.login().getBatchWriting();
        this.login().setBatchWriting(bl);
        this.firePropertyChanged(BATCH_WRITING_PROPERTY, bl2, bl);
    }

    public boolean usesJdbcBatchWriting() {
        return this.login().getJdbcBatchWriting();
    }

    public void setJdbcBatchWriting(boolean bl) {
        boolean bl2 = this.login().getJdbcBatchWriting();
        this.login().setJdbcBatchWriting(bl);
        this.firePropertyChanged(JDBC_BATCH_WRITING_PROPERTY, bl2, bl);
    }

    public int getMaxBatchWritingSize() {
        Integer n = this.login().getMaxBatchWritingSize();
        return n != null ? n : 0;
    }

    public void setMaxBatchWritingSize(int n) {
        int n2 = this.getMaxBatchWritingSize();
        this.login().setMaxBatchWritingSize(new Integer(n));
        this.firePropertyChanged(MAX_BATCH_WRITING_SIZE_PROPERTY, n2, n);
    }

    public String getPingSQL() {
        return this.login().getPingSQL();
    }

    public void setPingSQL(String string) {
        String string2 = this.login().getPingSQL();
        this.login().setPingSQL(string);
        this.firePropertyChanged(PING_SQL_PROPERTY, string2, string);
    }

    public Integer getQueryRetryAttemptCount() {
        return this.login().getQueryRetryAttemptCount();
    }

    public void setQueryRetryAttemptCount(Integer n) {
        Integer n2 = this.login().getQueryRetryAttemptCount();
        this.login().setQueryRetryAttemptCount(n);
        this.firePropertyChanged(QUERY_RETRY_ATTEMPT_COUNT_PROPERTY, n2, n);
    }

    public Integer getDelayBetweenConnectionAttempts() {
        return this.login().getDelayBetweenConnectionAttempts();
    }

    public void setDelayBetweenConnectionAttempts(Integer n) {
        Integer n2 = this.login().getDelayBetweenConnectionAttempts();
        this.login().setDelayBetweenConnectionAttempts(n);
        this.firePropertyChanged(DELAY_BETWEEN_CONNECTION_ATTEMPTS_PROPERTY, n2, n);
    }

    public boolean usesNativeSQL() {
        return this.login().getNativeSQL();
    }

    public void setNativeSQL(boolean bl) {
        boolean bl2 = this.login().getNativeSQL();
        this.login().setNativeSQL(bl);
        this.firePropertyChanged(NATIVE_SQL_PROPERTY, bl2, bl);
    }

    public boolean isNativeSequencing() {
        return this.login().getNativeSequencing();
    }

    public void setIsNativeSequencing(boolean bl) {
        boolean bl2 = this.login().getNativeSequencing();
        this.login().setNativeSequencing(bl);
        this.firePropertyChanged(NATIVE_SEQUENCING_PROPERTY, bl2, bl);
    }

    public boolean isConnectionHealthValidatedOnError() {
        Boolean bl = this.login().isConnectionHealthValidatedOnError();
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public void setConnectionHealthValidatedOnError(boolean bl) {
        Boolean bl2 = this.login().isConnectionHealthValidatedOnError();
        Boolean bl3 = bl;
        this.login().setConnectionHealthValidatedOnError(bl3);
        this.firePropertyChanged(CONNECTION_HEALTH_VALIDATE_ON_ERROR_PROPERTY, bl2, bl3);
    }

    public static Iterator driverClasses() {
        return DatabaseLoginAdapter.getDriverClassesURLTable().keySet().iterator();
    }

    public static Iterator driverURLs(String string) {
        Object[] objectArray = (String[])DatabaseLoginAdapter.getDriverClassesURLTable().get(string);
        if (objectArray == null) {
            return NullIterator.instance();
        }
        return new ArrayIterator(objectArray);
    }

    private static Map buildDriverClassURLTable() {
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        hashtable.put("com.neon.jdbc.Driver", new String[]{"jdbc:neon:"});
        hashtable.put("com.pointbase.jdbc.jdbcUniversalDriver", new String[]{"jdbc:pointbase:"});
        hashtable.put("com.sybase.jdbc3.jdbc.SybDriver", new String[]{"jdbc:sybase:Tds:"});
        hashtable.put("com.sybase.jdbc2.jdbc.SybDriver", new String[]{"jdbc:sybase:Tds:"});
        hashtable.put("com.sybase.jdbc.SybDriver", new String[]{"jdbc:sybase:Tds:"});
        hashtable.put("COM.ibm.db2.jdbc.app.DB2Driver", new String[]{"jdbc:db2:"});
        hashtable.put("COM.ibm.db2.jdbc.net.DB2Driver", new String[]{"jdbc:db2:"});
        hashtable.put("com.ibm.db2.jcc.DB2Driver", new String[]{"jdbc:db2://"});
        hashtable.put("com.mysql.jdbc.Driver", new String[]{"jdbc:mysql://"});
        hashtable.put("borland.jdbc.Bridge.LocalDriver", new String[]{"jdbc:BorlandBridge:"});
        hashtable.put("borland.jdbc.Broker.RemoteDriver", new String[]{"jdbc:BorlandBridge:"});
        hashtable.put("intersolv.jdbc.sequelink.SequeLinkDriver", new String[]{"jdbc:sequelink:"});
        String[] stringArray = new String[]{"jdbc:oracle:thin:@<HOST>:<PORT>:<SID>", "jdbc:oracle:oci:@<HOST>:<PORT>:<SID>", "jdbc:oracle:oci7:@<HOST>:<PORT>:<SID>", "jdbc:oracle:oci8:@<HOST>:<PORT>:<SID>"};
        hashtable.put("oracle.jdbc.OracleDriver", stringArray);
        hashtable.put("oracle.jdbc.driver.OracleDriver", stringArray);
        hashtable.put("com.oracle.ias.jdbc.db2.DB2Driver", new String[]{"jdbc:oracle:db2://"});
        hashtable.put("com.oracle.ias.jdbc.sqlserver.SQLServerDriver", new String[]{"jdbc:oracle:sqlserver://"});
        hashtable.put("com.oracle.ias.jdbc.sybase.SybaseDriver", new String[]{"jdbc:oracle:sybase://"});
        hashtable.put("org.hsqldb.jdbcDriver", new String[]{"jdbc:hsqldb:"});
        hashtable.put("sun.jdbc.odbc.JdbcOdbcDriver", new String[]{"jdbc:odbc:"});
        hashtable.put("weblogic.jdbc.oci.Driver", new String[]{"jdbc:weblogic:oracle:"});
        hashtable.put("weblogic.jdbc.dblib.Driver", new String[]{"jdbc:weblogic:mssqlserver:", "jdbc:weblogic:sybase"});
        hashtable.put("weblogic.jdbc.informix4.Driver", new String[]{"jdbc:weblogic:informix4:"});
        hashtable.put("weblogic.jdbc.jts.Driver", new String[]{"jdbc:weblogic:jts:"});
        hashtable.put("weblogic.jdbc.mssqlserver4.Driver", new String[]{"jdbc:weblogic:mssqlserver4:"});
        hashtable.put("weblogic.jdbc.pool.Driver", new String[]{"jdbc:weblogic:pool:"});
        hashtable.put("weblogic.jdbc.t3client.Driver", new String[]{"jdbc:weblogic:t3Client:"});
        hashtable.put("weblogic.jdbc.t3.Driver", new String[]{"jdbc:weblogic:t3:"});
        hashtable.put("com.timesten.jdbc.TimesTenDriver", new String[]{"jdbc:timesten:direct:<SID>"});
        return hashtable;
    }

    private static Map getDriverClassesURLTable() {
        if (driverClassesURLTable == null) {
            driverClassesURLTable = DatabaseLoginAdapter.buildDriverClassURLTable();
        }
        return driverClassesURLTable;
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        if (this.databaseDriverIsDriverManager()) {
            this.verifyProblemDriverClass(list);
            this.verifyProblemDriverURL(list);
        } else {
            this.verifyProblemDataSourceName(list);
        }
    }

    private void verifyProblemDriverClass(List list) {
        if (StringTools.stringIsEmpty((String)this.getDriverClassName())) {
            list.add(this.buildProblem("0802", this.getParent().displayString()));
        }
    }

    private void verifyProblemDriverURL(List list) {
        if (StringTools.stringIsEmpty((String)this.getConnectionURL())) {
            list.add(this.buildProblem("0801", this.getParent().displayString()));
        }
    }

    private void verifyProblemDataSourceName(List list) {
        if (StringTools.stringIsEmpty((String)this.getDataSourceName())) {
            list.add(this.buildProblem("0803", this.getParent().displayString()));
        }
    }

    public boolean usesProperties() {
        return this.useProperties;
    }

    public void setUseProperties(boolean bl) {
        boolean bl2 = this.usesProperties();
        this.useProperties = bl;
        this.firePropertyChanged(USE_PROPERTIES_PROPERTY, bl2, bl);
        if (!this.usesProperties()) {
            this.removeAllProperties();
        }
    }

    public void setLookupType(Integer n) {
        Integer n2 = this.getLookupType();
        this.login().setLookupType(n);
        this.firePropertyChanged(LOOKUP_TYPE_PROPERTY, n2, n);
    }

    public Integer getLookupType() {
        return this.login().getLookupType();
    }

    private StructConverterConfig structConverterConfig() {
        return this.login().getStructConverterConfig();
    }

    public ListIterator<String> structConvertersClasses() {
        return this.structConverterConfig().getStructConverterClasses().listIterator();
    }

    public void addStructConverterClass(String string) {
        this.structConverterConfig().addStructConverterClass(string);
        int n = this.structConverterConfig().getStructConverterClasses().indexOf(string);
        this.fireItemAdded(STRUCT_CONVERTER_COLLECTION_PROPERTY, n, string);
    }

    public void removeStructConverterClass(String string) {
        Vector vector = this.structConverterConfig().getStructConverterClasses();
        int n = vector.indexOf(string);
        vector.remove(string);
        this.structConverterConfig().setStructConverterClasses(vector);
        this.fireItemRemoved(STRUCT_CONVERTER_COLLECTION_PROPERTY, n, string);
    }
}

