/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.internal.sessions.factories.model.event.SessionEventManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.DatabaseLoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.EISLoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.LoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.project.ProjectConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.DatabaseSessionConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.SessionConfig;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.CustomServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DataSource;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.LoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.LoginHandler;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ProjectAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ProjectClassAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ProjectXMLAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerPlatform;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionBrokerAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class DatabaseSessionAdapter
extends SessionAdapter
implements LoginHandler {
    private volatile ProjectAdapter primaryProject;
    public static final String PRIMARY_PROJECT_PROPERTY = "primaryProject";
    private Collection additionalProjects;
    public static final String ADDITIONAL_PROJECTS_COLLECTION = "additionalProjects";
    private volatile boolean useAdditionalProjects;
    public static final String USE_ADDITIONAL_PROJECTS_COLLECTION = "useAdditionalProjects";
    public static final String EXTERNAL_CONNECTION_POOLING_PROPERTY = "externalConnectionPooling";
    private volatile LoginAdapter login;
    public static final String LOGIN_CONFIG_PROPERTY = "login";
    public static final String MAP_XML_TYPE = "project-xml";
    public static final String MAP_CLASS_TYPE = "project-class";
    public static final String DEFAULT_MAPPING_TYPE = "project-class";
    public static final String[] VALID_MAPPING_PROJECT_TYPE = new String[]{"project-xml", "project-class"};
    private volatile SessionBrokerAdapter broker;

    DatabaseSessionAdapter(SCAdapter sCAdapter, DatabaseSessionConfig databaseSessionConfig) {
        super(sCAdapter, (SessionConfig)databaseSessionConfig);
    }

    protected DatabaseSessionAdapter(SCAdapter sCAdapter, String string, ServerPlatform serverPlatform, DataSource dataSource) {
        super(sCAdapter, string);
        this.initializePlatforms(serverPlatform, dataSource);
    }

    protected Object buildModel() {
        DatabaseSessionConfig databaseSessionConfig = new DatabaseSessionConfig();
        databaseSessionConfig.setAdditionalProjects(new Vector());
        databaseSessionConfig.setSessionEventManagerConfig(new SessionEventManagerConfig());
        return databaseSessionConfig;
    }

    private LoginAdapter buildLogin(DataSource dataSource) {
        LoginAdapter loginAdapter = dataSource.buildLoginAdapter(this);
        this.databaseSession().setLoginConfig((LoginConfig)loginAdapter.getModel());
        loginAdapter.setPlatformClass(dataSource.getPlatformClassName());
        return loginAdapter;
    }

    LoginAdapter buildDefaultLogin() {
        DataSource dataSource = null;
        String string = this.preferences().get("data source type", "database");
        if (string.equals("relational")) {
            dataSource = this.buildDefaultRdbmsDataSource();
        } else if (string.equals("eis")) {
            dataSource = this.buildDefaultEisDataSource();
        } else if (string.equals("xml")) {
            dataSource = this.buildDefaultXmlDataSource();
        } else {
            throw new IllegalArgumentException(string);
        }
        return this.buildLogin(dataSource);
    }

    private DataSource buildDefaultRdbmsDataSource() {
        String string = this.preferences().get("platform.database", "Oracle11");
        DatabasePlatform databasePlatform = DatabasePlatformRepository.getDefault().platformNamed(string);
        return new DataSource(databasePlatform);
    }

    private DataSource buildDefaultEisDataSource() {
        String string = this.preferences().get("platform.eis", "AQPlatform");
        return new DataSource(string);
    }

    private DataSource buildDefaultXmlDataSource() {
        return DataSource.buildXmlDataSource();
    }

    private final DatabaseSessionConfig databaseSession() {
        return (DatabaseSessionConfig)this.getModel();
    }

    protected void initialize() {
        super.initialize();
        this.additionalProjects = new Vector();
    }

    protected void initialize(Object object) {
        super.initialize(object);
        this.databaseSession().setAdditionalProjects(new Vector());
        this.addPrimaryProjectXmlNamed("");
    }

    protected void initializeFromModel(Object object) {
        super.initializeFromModel(object);
        this.primaryProject = (ProjectAdapter)this.adapt(this.databaseSession().getPrimaryProject());
        this.additionalProjects.addAll(this.adaptAll(this.getAdditionalProjectsConfigs()));
        this.useAdditionalProjects = !this.additionalProjects.isEmpty();
        this.login = (LoginAdapter)this.adapt(this.databaseSession().getLoginConfig());
    }

    protected void postInitializationFromModel() {
        super.postInitializationFromModel();
        if (this.configVersionIsPre10g()) {
            if (this.login == null) {
                this.login = this.buildLogin(DataSource.buildDefault());
            } else if (StringTools.stringIsEmpty((String)this.login.getPlatformClass())) {
                this.setDefaultLoginPlatform();
            }
        } else if (this.login == null) {
            this.login = this.buildLogin(DataSource.buildDefault());
        }
    }

    private void setDefaultLoginPlatform() {
        DataSource dataSource = null;
        if (this.login.platformIsRdbms()) {
            dataSource = this.buildDefaultRdbmsDataSource();
        } else if (this.login.platformIsEis()) {
            dataSource = this.buildDefaultEisDataSource();
        } else if (this.login.platformIsXml()) {
            dataSource = this.buildDefaultXmlDataSource();
        } else {
            throw new IllegalStateException();
        }
        this.login.setPlatformClass(dataSource.getPlatformClassName());
    }

    private void initializePlatforms(ServerPlatform serverPlatform, DataSource dataSource) {
        this.login = this.buildLogin(dataSource);
        this.initializeServerPlatform(serverPlatform);
    }

    protected void preSaving() {
        super.preSaving();
        if (this.getLogin().hasNoConfigToSave()) {
            this.setEmptyLoginConfig();
        } else {
            this.getLogin().preSaving();
        }
    }

    protected void postSaving() {
        super.postSaving();
        this.syncSessionConfigLogin();
        this.getLogin().postSaving();
    }

    private void setEmptyLoginConfig() {
        if (this.login.platformIsRdbms()) {
            DatabaseLoginConfig databaseLoginConfig = new DatabaseLoginConfig();
            databaseLoginConfig.setByteArrayBinding(true);
            databaseLoginConfig.setOptimizeDataConversion(true);
            databaseLoginConfig.setTrimStrings(true);
            databaseLoginConfig.setMaxBatchWritingSize(new Integer(32000));
            databaseLoginConfig.setJdbcBatchWriting(true);
            this.databaseSession().setLoginConfig((LoginConfig)databaseLoginConfig);
        } else if (this.login.platformIsEis()) {
            this.databaseSession().setLoginConfig((LoginConfig)new EISLoginConfig());
        }
    }

    private void syncSessionConfigLogin() {
        if (this.databaseSession().getLoginConfig() != (LoginConfig)this.getLogin().getModel()) {
            this.databaseSession().setLoginConfig((LoginConfig)this.getLogin().getModel());
        }
    }

    public LoginAdapter getLogin() {
        return this.login;
    }

    public String getPlatform() {
        return this.getLogin().getPlatformClass();
    }

    public String getDataSourceName() {
        return this.getLogin().getPlatformName();
    }

    public boolean platformIsRdbms() {
        return this.login.platformIsRdbms();
    }

    public boolean platformIsEis() {
        return this.login.platformIsEis();
    }

    public boolean platformIsXml() {
        return this.login.platformIsXml();
    }

    public void toString(StringBuffer stringBuffer) {
        super.toString(stringBuffer);
        stringBuffer.append(", ");
        if (this.login == null) {
            stringBuffer.append("NO LOGIN");
        } else {
            this.login.toString(stringBuffer);
        }
    }

    public void setName(String string) {
        String string2 = this.getName();
        super.setName(string);
        if (this.isManaged()) {
            this.getBroker().sessionRenamed(string2, string);
        }
    }

    public SessionBrokerAdapter getBroker() {
        return this.broker;
    }

    void setBroker(SessionBrokerAdapter sessionBrokerAdapter) {
        this.broker = sessionBrokerAdapter;
        this.setManaged(sessionBrokerAdapter != null);
    }

    protected void setManaged(boolean bl) {
        super.setManaged(bl);
        if (bl) {
            this.initializeDefaults();
        }
        this.updateExternalConnectionPooling();
    }

    void externalTransactionControllerClassChanged() {
        if (this.hasJTA() && this.getServerPlatform().isCustom()) {
            String string = ((CustomServerPlatformAdapter)this.getServerPlatform()).getExternalTransactionControllerClass();
            boolean bl = !StringTools.stringIsEmpty((String)string);
            this.getLogin().setUsesExternalTransactionController(bl);
        }
        this.getLogin().setUsesExternalTransactionController(this.hasJTA());
        this.updateExternalConnectionPooling();
    }

    public Iterator additionalProjects() {
        return new CloneIterator(this.additionalProjects);
    }

    public Iterator additionalProjectNames() {
        return new TransformationIterator(this.additionalProjects()){

            protected Object transform(Object object) {
                return ((ProjectAdapter)((Object)object)).getName();
            }
        };
    }

    private Collection getAdditionalProjectsConfigs() {
        if (this.databaseSession().getAdditionalProjects() == null) {
            this.databaseSession().setAdditionalProjects(new Vector());
        }
        return this.databaseSession().getAdditionalProjects();
    }

    private ProjectAdapter getPrimaryProject() {
        return this.primaryProject;
    }

    public boolean isPrimaryProjectXml() {
        return this.primaryProject instanceof ProjectXMLAdapter;
    }

    public boolean isPrimaryProjectClass() {
        return this.primaryProject instanceof ProjectClassAdapter;
    }

    public boolean isServer() {
        return false;
    }

    public String getPrimaryProjectName() {
        if (this.getPrimaryProject() == null) {
            return null;
        }
        return this.getPrimaryProject().getName();
    }

    public ProjectClassAdapter addPrimaryProjectClassNamed(String string) {
        ProjectClassAdapter projectClassAdapter = new ProjectClassAdapter((SCAdapter)this, string);
        this.setPrimaryProject(projectClassAdapter);
        return (ProjectClassAdapter)this.primaryProject;
    }

    public ProjectXMLAdapter addPrimaryProjectXmlNamed(String string) {
        ProjectXMLAdapter projectXMLAdapter = new ProjectXMLAdapter((SCAdapter)this, string);
        this.setPrimaryProject(projectXMLAdapter);
        return (ProjectXMLAdapter)this.primaryProject;
    }

    public void removePrimaryProject() {
        ProjectAdapter projectAdapter = this.primaryProject;
        this.primaryProject = null;
        this.databaseSession().setPrimaryProject(null);
        this.firePropertyChanged(PRIMARY_PROJECT_PROPERTY, (Object)projectAdapter, null);
    }

    private void setPrimaryProject(ProjectAdapter projectAdapter) {
        ProjectAdapter projectAdapter2 = this.primaryProject;
        this.primaryProject = projectAdapter;
        this.databaseSession().setPrimaryProject((ProjectConfig)projectAdapter.getModel());
        this.firePropertyChanged(PRIMARY_PROJECT_PROPERTY, (Object)projectAdapter2, (Object)projectAdapter);
    }

    public ProjectClassAdapter addProjectClassNamed(String string) {
        ProjectClassAdapter projectClassAdapter = new ProjectClassAdapter((SCAdapter)this, string);
        this.addAdditionalProjects(projectClassAdapter);
        this.fireItemAdded(ADDITIONAL_PROJECTS_COLLECTION, (Object)projectClassAdapter);
        return projectClassAdapter;
    }

    public ProjectXMLAdapter addProjectXmlNamed(String string) {
        ProjectXMLAdapter projectXMLAdapter = new ProjectXMLAdapter((SCAdapter)this, string);
        this.addAdditionalProjects(projectXMLAdapter);
        this.fireItemAdded(ADDITIONAL_PROJECTS_COLLECTION, (Object)projectXMLAdapter);
        return projectXMLAdapter;
    }

    public ProjectAdapter removeProject(ProjectAdapter projectAdapter) {
        this.removeAdditionalProject(projectAdapter);
        return projectAdapter;
    }

    public ProjectAdapter projectNamed(String string) {
        Iterator iterator = this.additionalProjects();
        while (iterator.hasNext()) {
            ProjectAdapter projectAdapter = (ProjectAdapter)((Object)iterator.next());
            if (!string.equals(projectAdapter.getName())) continue;
            return projectAdapter;
        }
        return null;
    }

    public void updateExternalConnectionPooling() {
        this.setExternalConnectionPooling(this.hasJTA() || this.getLogin().databaseDriverIsDataSource());
    }

    private ProjectAdapter addAdditionalProjects(ProjectAdapter projectAdapter) {
        this.getAdditionalProjectsConfigs().add(projectAdapter.getModel());
        this.additionalProjects.add(projectAdapter);
        return projectAdapter;
    }

    private void removeAdditionalProject(ProjectAdapter projectAdapter) {
        this.getAdditionalProjectsConfigs().remove(projectAdapter.getModel());
        this.removeItemFromCollection((Object)projectAdapter, this.additionalProjects, ADDITIONAL_PROJECTS_COLLECTION);
    }

    private void removeAllAdditionalProjects() {
        this.removeItemsFromCollection(CollectionTools.collection((Iterator)this.additionalProjects()), this.additionalProjects, ADDITIONAL_PROJECTS_COLLECTION);
        this.getAdditionalProjectsConfigs().clear();
    }

    public boolean usesAdditionalProjects() {
        return this.useAdditionalProjects;
    }

    public void setUseAdditionalProjects(boolean bl) {
        boolean bl2 = this.usesAdditionalProjects();
        this.useAdditionalProjects = bl;
        this.firePropertyChanged(USE_ADDITIONAL_PROJECTS_COLLECTION, bl2, bl);
        if (!this.usesAdditionalProjects()) {
            this.removeAllAdditionalProjects();
        }
    }

    public boolean usesExternalConnectionPooling() {
        return this.getLogin().usesExternalConnectionPooling();
    }

    public void setExternalConnectionPooling(boolean bl) {
        boolean bl2 = this.getLogin().usesExternalConnectionPooling();
        this.getLogin().setExternalConnectionPooling(bl);
        this.firePropertyChanged(EXTERNAL_CONNECTION_POOLING_PROPERTY, bl2, bl);
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        if (this.getLogin() != null) {
            list.add(this.getLogin());
        }
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.verifyProblemMappingProject(list);
        this.verifyProblemPlatformClass(list);
    }

    private void verifyProblemPlatformClass(List list) {
        if (!this.login.platformIsRdbms()) {
            return;
        }
        try {
            DatabasePlatformRepository.getDefault().platformForRuntimePlatformClassNamed(this.login.getPlatformClass());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            list.add(this.buildProblem("0810", this.displayString(), this.login.getPlatformClass()));
        }
    }

    private void verifyProblemMappingProject(List list) {
        if (StringTools.stringIsEmpty((String)this.getPrimaryProjectName())) {
            list.add(this.buildProblem("0805", this.displayString()));
        }
    }
}

