/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.io.File;
import java.util.List;
import org.eclipse.persistence.internal.sessions.factories.model.log.DefaultSessionLogConfig;
import org.eclipse.persistence.internal.sessions.factories.model.log.LogConfig;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.LogAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class DefaultSessionLogAdapter
extends LogAdapter {
    public static final String FILE_NAME_PROPERTY = "filename";
    public static final String LOG_LEVEL_PROPERTY = "logLevel";
    public static final String INFO_LOG_LEVEL = "info";
    public static final String SEVERE_LOG_LEVEL = "severe";
    public static final String WARNING_LOG_LEVEL = "warning";
    public static final String CONFIG_LOG_LEVEL = "config";
    public static final String FINE_LOG_LEVEL = "fine";
    public static final String FINER_LOG_LEVEL = "finer";
    public static final String FINEST_LOG_LEVEL = "finest";
    public static final String ALL_LOG_LEVEL = "all";
    public static final String OFF_LOG_LEVEL = "off";
    public static final String DEFAULT_LOG_LEVEL = "info";
    public static final String DEFAULT_LOG_FILE = "standard output";
    public static final String[] VALID_LOG_LEVEL = new String[]{"config", "info", "warning", "severe", "fine", "finer", "finest", "all", "off"};

    DefaultSessionLogAdapter(SCAdapter sCAdapter, DefaultSessionLogConfig defaultSessionLogConfig) {
        super(sCAdapter, (LogConfig)defaultSessionLogConfig);
    }

    protected DefaultSessionLogAdapter(SCAdapter sCAdapter, String string, String string2) {
        super(sCAdapter);
        this.setFileName(string);
        this.setLogLevel(string2);
    }

    protected Object buildModel() {
        return new DefaultSessionLogConfig();
    }

    public String getFileName() {
        String string = this.getFileNameInternal();
        if (string != null) {
            string = string.replace('/', File.separatorChar);
        }
        return string;
    }

    private String getFileNameInternal() {
        String string = this.log().getFilename();
        if (string == null) {
            string = DEFAULT_LOG_FILE;
        }
        return string;
    }

    public void setFileName(String string) {
        String string2 = this.log().getFilename();
        String string3 = string;
        if (string3 != null) {
            string3 = string3.replace('\\', '/');
        }
        this.setFilenameInternal(string3);
        this.firePropertyChanged(FILE_NAME_PROPERTY, string2, string);
    }

    private void setFilenameInternal(String string) {
        if (string != null && string.equals(DEFAULT_LOG_FILE)) {
            this.log().setFilename(null);
        } else {
            this.log().setFilename(string);
        }
    }

    public String getLogLevel() {
        return this.log().getLogLevel();
    }

    public void setLogLevel(String string) {
        String string2 = this.getLogLevel();
        this.log().setLogLevel(string);
        this.firePropertyChanged(LOG_LEVEL_PROPERTY, string2, string);
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.getFileName());
    }

    private final DefaultSessionLogConfig log() {
        return (DefaultSessionLogConfig)this.getModel();
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.verifyProblemFileName(list);
    }

    private void verifyProblemFileName(List list) {
        String string = this.getFileName();
        if (!DEFAULT_LOG_FILE.equals(string) && StringTools.stringIsEmpty((String)string)) {
            list.add(this.buildProblem("0807", this.getParent().displayString()));
        }
    }
}

