/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import org.eclipse.persistence.internal.sessions.factories.model.login.EISLoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.LoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.sequencing.SequencingConfig;
import org.eclipse.persistence.tools.workbench.scplugin.model.EisPlatformManager;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DataSource;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.LoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SequencingAdapter;

public final class EISLoginAdapter
extends LoginAdapter {
    public static final String CONNECTION_FACTORY_URL_PROPERTY = "connectionFactoryURL";
    public static final String CONNECTION_SPEC_CLASS_PROPERTY = "connectionSpecClass";

    EISLoginAdapter(SCAdapter sCAdapter, EISLoginConfig eISLoginConfig) {
        super(sCAdapter, (LoginConfig)eISLoginConfig);
    }

    protected EISLoginAdapter(SCAdapter sCAdapter) {
        super(sCAdapter);
    }

    protected Object buildModel() {
        return new EISLoginConfig();
    }

    protected SequencingAdapter buildSequencing() {
        SequencingAdapter sequencingAdapter = super.buildSequencing();
        this.login().setSequencingConfig((SequencingConfig)sequencingAdapter.getModel());
        return sequencingAdapter;
    }

    protected String getDefaultPlatformClassName() {
        String string = this.preferences().get("platform.eis", "AQPlatform");
        return DataSource.getClassNameForEisPlatform(string);
    }

    public String getConnectionFactoryURL() {
        return this.login().getConnectionFactoryURL();
    }

    public void setPlatformClass(String string) {
        super.setPlatformClass(string);
        this.setDefaultConnectionSpecClassName(string);
    }

    private void setDefaultConnectionSpecClassName(String string) {
        String string2 = EisPlatformManager.instance().getRuntimeConnectionSpecClassName(string);
        this.setConnectionSpecClassName(string2);
    }

    public void setConnectionFactoryURL(String string) {
        String string2 = this.login().getConnectionFactoryURL();
        this.login().setConnectionFactoryURL(string);
        this.firePropertyChanged(CONNECTION_FACTORY_URL_PROPERTY, string2, string);
    }

    public String getConnectionSpecClassName() {
        return this.login().getConnectionSpecClass();
    }

    public void setConnectionSpecClassName(String string) {
        String string2 = this.login().getConnectionSpecClass();
        this.login().setConnectionSpecClass(string);
        this.firePropertyChanged(CONNECTION_SPEC_CLASS_PROPERTY, string2, string);
    }

    public void toString(StringBuffer stringBuffer) {
        super.toString(stringBuffer);
        stringBuffer.append(", ").append(this.getConnectionSpecClassName());
    }

    boolean platformIsEis() {
        return true;
    }

    private final EISLoginConfig login() {
        return (EISLoginConfig)this.getModel();
    }
}

