/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.internal.sessions.factories.model.pool.ConnectionPoolConfig;
import org.eclipse.persistence.internal.sessions.factories.model.pool.PoolsConfig;
import org.eclipse.persistence.internal.sessions.factories.model.pool.ReadConnectionPoolConfig;
import org.eclipse.persistence.internal.sessions.factories.model.pool.WriteConnectionPoolConfig;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ReadConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.WriteConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PoolsAdapter
extends SCAdapter {
    private Collection pools;
    private volatile ReadConnectionPoolAdapter readConnectionPool;
    public static final String READ_CONNECTION_POOL_CONFIG_PROPERTY = "readConnectionPoolConfig";
    private volatile WriteConnectionPoolAdapter writeConnectionPool;
    public static final String WRITE_CONNECTION_POOL_CONFIG_PROPERTY = "writeConnectionPoolConfig";
    private volatile ConnectionPoolAdapter sequenceConnectionPool;
    public static final String SEQUENCE_CONNECTION_POOL_CONFIG_PROPERTY = "sequenceConnectionPoolConfig";

    PoolsAdapter(SCAdapter sCAdapter, PoolsConfig poolsConfig) {
        super(sCAdapter, poolsConfig);
    }

    protected PoolsAdapter(SCAdapter sCAdapter) {
        super(sCAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        Collection collection = this.pools;
        synchronized (collection) {
            list.addAll(this.pools);
        }
        if (this.readConnectionPool != null) {
            list.add(this.readConnectionPool);
        }
        if (this.writeConnectionPool != null) {
            list.add(this.writeConnectionPool);
        }
        if (this.sequenceConnectionPool != null) {
            list.add(this.sequenceConnectionPool);
        }
    }

    @Override
    protected Object buildModel() {
        return new PoolsConfig();
    }

    ReadConnectionPoolAdapter addReadConnectionPool() {
        if (this.readConnectionPool == null) {
            this.readConnectionPool = new ReadConnectionPoolAdapter(this);
            this.config().setReadConnectionPoolConfig((ReadConnectionPoolConfig)this.readConnectionPool.getModel());
        }
        return this.readConnectionPool;
    }

    ConnectionPoolAdapter addSequenceConnectionPool() {
        if (this.sequenceConnectionPool == null) {
            this.sequenceConnectionPool = new ConnectionPoolAdapter((SCAdapter)this, "SequenceConnectionPool");
            this.config().setSequenceConnectionPoolConfig((ConnectionPoolConfig)this.sequenceConnectionPool.getModel());
        }
        return this.sequenceConnectionPool;
    }

    WriteConnectionPoolAdapter addWriteConnectionPool() {
        if (this.writeConnectionPool == null) {
            this.writeConnectionPool = new WriteConnectionPoolAdapter(this);
            this.config().setWriteConnectionPoolConfig((WriteConnectionPoolConfig)this.writeConnectionPool.getModel());
        }
        return this.writeConnectionPool;
    }

    ConnectionPoolAdapter addConnectionPoolNamed(String string) {
        ConnectionPoolAdapter connectionPoolAdapter = new ConnectionPoolAdapter((SCAdapter)this, string);
        return this.addPool(connectionPoolAdapter);
    }

    ConnectionPoolAdapter removeConnectionPoolNamed(String string) {
        ConnectionPoolAdapter connectionPoolAdapter = this.poolNamed(string);
        if (connectionPoolAdapter != null) {
            if (connectionPoolAdapter == this.readConnectionPool || connectionPoolAdapter == this.sequenceConnectionPool) {
                throw new UnsupportedOperationException("Read or Sequence pool cannot be removed.");
            }
            if (connectionPoolAdapter == this.writeConnectionPool) {
                this.removeWriteConnectionPool();
            } else {
                this.removePool(connectionPoolAdapter);
            }
        }
        return connectionPoolAdapter;
    }

    ConnectionPoolAdapter removeWriteConnectionPool() {
        WriteConnectionPoolAdapter writeConnectionPoolAdapter = this.writeConnectionPool;
        this.config().setWriteConnectionPoolConfig(null);
        this.writeConnectionPool = null;
        return writeConnectionPoolAdapter;
    }

    ConnectionPoolAdapter removeReadConnectionPool() {
        ReadConnectionPoolAdapter readConnectionPoolAdapter = this.readConnectionPool;
        this.config().setReadConnectionPoolConfig(null);
        this.readConnectionPool = null;
        return readConnectionPoolAdapter;
    }

    ConnectionPoolAdapter removeSequenceConnectionPool() {
        ConnectionPoolAdapter connectionPoolAdapter = this.sequenceConnectionPool;
        this.config().setSequenceConnectionPoolConfig(null);
        this.sequenceConnectionPool = null;
        return connectionPoolAdapter;
    }

    private ConnectionPoolAdapter addPool(ConnectionPoolAdapter connectionPoolAdapter) {
        this.getConnectionPoolConfigs().add(connectionPoolAdapter.getModel());
        this.getPools().add(connectionPoolAdapter);
        return connectionPoolAdapter;
    }

    private void removePool(ConnectionPoolAdapter connectionPoolAdapter) {
        this.getConnectionPoolConfigs().remove(connectionPoolAdapter.getModel());
        this.getPools().remove(connectionPoolAdapter);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.setConfigRequired(true);
        this.pools = new Vector();
    }

    @Override
    protected void initialize(Object object) {
        super.initialize(object);
    }

    @Override
    protected void initializeFromModel(Object object) {
        super.initializeFromModel(object);
        if (!this.platformIsXml()) {
            this.readConnectionPool = (ReadConnectionPoolAdapter)this.adapt(this.config().getReadConnectionPoolConfig());
            this.writeConnectionPool = (WriteConnectionPoolAdapter)this.adapt(this.config().getWriteConnectionPoolConfig());
            this.sequenceConnectionPool = (ConnectionPoolAdapter)this.adapt(this.config().getSequenceConnectionPoolConfig());
            this.pools.addAll(this.adaptAll(this.getConnectionPoolConfigs()));
        }
    }

    public boolean platformIsRdbms() {
        return ((SessionAdapter)this.getParent()).platformIsRdbms();
    }

    public boolean platformIsEis() {
        return ((SessionAdapter)this.getParent()).platformIsEis();
    }

    public boolean platformIsXml() {
        return ((SessionAdapter)this.getParent()).platformIsXml();
    }

    private Collection getPools() {
        return this.pools;
    }

    Collection<String> getPoolNames() {
        return CollectionTools.collection((Iterator)new TransformationIterator(this.pools()){

            protected Object transform(Object object) {
                return ((ConnectionPoolAdapter)object).getName();
            }
        });
    }

    Iterator pools() {
        return new CloneIterator(this.pools);
    }

    int poolsSize() {
        return this.pools.size();
    }

    private Collection getConnectionPoolConfigs() {
        return this.config().getConnectionPoolConfigs();
    }

    private ReadConnectionPoolConfig getReadConnectionPoolConfig() {
        return this.config().getReadConnectionPoolConfig();
    }

    ReadConnectionPoolAdapter getReadConnectionPool() {
        return this.readConnectionPool;
    }

    private ConnectionPoolConfig getWriteConnectionPoolConfig() {
        return this.config().getWriteConnectionPoolConfig();
    }

    ConnectionPoolAdapter getWriteConnectionPool() {
        return this.writeConnectionPool;
    }

    private ConnectionPoolConfig getSequenceConnectionPoolConfig() {
        return this.config().getSequenceConnectionPoolConfig();
    }

    ConnectionPoolAdapter getSequenceConnectionPool() {
        return this.sequenceConnectionPool;
    }

    ConnectionPoolAdapter poolNamed(String string) {
        Iterator iterator = this.pools();
        while (iterator.hasNext()) {
            ConnectionPoolAdapter connectionPoolAdapter = (ConnectionPoolAdapter)iterator.next();
            if (!string.equals(connectionPoolAdapter.getName())) continue;
            return connectionPoolAdapter;
        }
        return null;
    }

    private final PoolsConfig config() {
        return (PoolsConfig)this.getModel();
    }
}

