/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.util.List;
import org.eclipse.persistence.internal.sessions.factories.model.transport.RMITransportManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.TransportManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.discovery.DiscoveryConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.naming.JNDINamingServiceConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.naming.RMIRegistryNamingServiceConfig;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DiscoveryAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.JNDINamingServiceAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.RMIRegistryNamingServiceAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TransportManagerAdapter;

public class RMITransportManagerAdapter
extends TransportManagerAdapter {
    private volatile JNDINamingServiceAdapter namingService;
    public static final String JNDI_NAMING_SERVICE_PROPERTY = "jndiNamingService";
    private volatile DiscoveryAdapter discovery;
    public static final String DISCOVERY_PROPERTY = "discovery";
    private volatile RMIRegistryNamingServiceAdapter rmiRegistryNamingService;
    public static final String RMI_REGISTRY_NAMING_SERVICE_PROPERTY = "rmiRegistryNamingService";
    public static final String JNDI_ENCRYPTION_CLASS_PROPERTY = "encryptionClass";
    public static final String JNDI_PROPERTIES_COLLECTION = "properties";
    public static final String DISCOVER_MULTICAST_GROUP_ADDRESS_PROPERTY = "multicastGroupAddress";
    public static final String DISCOVER_MULTICAST_PORT_PROPERTY = "multicastPort";
    public static final String DISCOVER_ANNOUNCEMENT_DELAY_PROPERTY = "announcementDelay";
    public static final String DISCOVER_PACKET_TIME_TO_LIVE_PROPERTY = "packetTimeToLive";
    public volatile String namingServiceType;
    public static final String NAMING_SERVICE_TYPE_PROPERTY = "namingServiceType";
    public static final String SEND_MODE_PROPERTY = "sendMode";

    RMITransportManagerAdapter(SCAdapter sCAdapter, RMITransportManagerConfig rMITransportManagerConfig) {
        super(sCAdapter, (TransportManagerConfig)rMITransportManagerConfig);
    }

    protected RMITransportManagerAdapter(SCAdapter sCAdapter) {
        super(sCAdapter);
    }

    protected Object buildModel() {
        return new RMITransportManagerConfig();
    }

    private DiscoveryAdapter buildDiscovery() {
        return new DiscoveryAdapter(this);
    }

    private RMIRegistryNamingServiceAdapter buildRegistryNamingService() {
        return new RMIRegistryNamingServiceAdapter(this);
    }

    private final RMITransportManagerConfig manager() {
        return (RMITransportManagerConfig)this.getModel();
    }

    protected void initializeFromModel(Object object) {
        super.initializeFromModel(object);
        this.discovery = (DiscoveryAdapter)this.adapt(this.manager().getDiscoveryConfig());
        this.namingService = (JNDINamingServiceAdapter)this.adapt(this.manager().getJNDINamingServiceConfig());
        this.rmiRegistryNamingService = (RMIRegistryNamingServiceAdapter)this.adapt(this.manager().getRMIRegistryNamingServiceConfig());
        this.namingServiceType = this.namingService != null ? JNDI_NAMING_SERVICE_PROPERTY : RMI_REGISTRY_NAMING_SERVICE_PROPERTY;
    }

    protected void initialize(Object object) {
        super.initialize(object);
        this.setDiscovery(this.buildDiscovery());
        this.setJNDINamingService(this.buildJNDINamingService());
        this.namingServiceType = JNDI_NAMING_SERVICE_PROPERTY;
    }

    protected void initializeDefaults() {
        super.initializeDefaults();
        this.setMulticastGroupAddress("226.10.12.64");
        this.setMulticastPort(3121);
        this.setAnnouncementDelay(1000);
        this.setSynchronous("Asynchronous".equals("Asynchronous"));
        this.setPacketTimeToLive(2);
    }

    DiscoveryAdapter getDiscovery() {
        return this.discovery;
    }

    public JNDINamingServiceAdapter getJNDINamingService() {
        return this.namingService;
    }

    public RMIRegistryNamingServiceAdapter getRMIRegistryNamingService() {
        return this.rmiRegistryNamingService;
    }

    private void setDiscovery(DiscoveryAdapter discoveryAdapter) {
        JNDINamingServiceAdapter jNDINamingServiceAdapter = this.namingService;
        this.discovery = discoveryAdapter;
        this.manager().setDiscoveryConfig((DiscoveryConfig)discoveryAdapter.getModel());
        this.firePropertyChanged(DISCOVERY_PROPERTY, jNDINamingServiceAdapter, (Object)discoveryAdapter);
    }

    private void setJNDINamingService(JNDINamingServiceAdapter jNDINamingServiceAdapter) {
        JNDINamingServiceAdapter jNDINamingServiceAdapter2 = this.namingService;
        this.namingService = jNDINamingServiceAdapter;
        JNDINamingServiceConfig jNDINamingServiceConfig = jNDINamingServiceAdapter != null ? (JNDINamingServiceConfig)jNDINamingServiceAdapter.getModel() : null;
        this.manager().setJNDINamingServiceConfig(jNDINamingServiceConfig);
        this.firePropertyChanged(JNDI_NAMING_SERVICE_PROPERTY, jNDINamingServiceAdapter2, jNDINamingServiceAdapter);
    }

    private void setRegistryNamingService(RMIRegistryNamingServiceAdapter rMIRegistryNamingServiceAdapter) {
        JNDINamingServiceAdapter jNDINamingServiceAdapter = this.namingService;
        this.rmiRegistryNamingService = rMIRegistryNamingServiceAdapter;
        if (rMIRegistryNamingServiceAdapter != null) {
            this.manager().setRMIRegistryNamingServiceConfig((RMIRegistryNamingServiceConfig)rMIRegistryNamingServiceAdapter.getModel());
        } else {
            this.manager().setRMIRegistryNamingServiceConfig(null);
        }
        this.firePropertyChanged(RMI_REGISTRY_NAMING_SERVICE_PROPERTY, jNDINamingServiceAdapter, (Object)rMIRegistryNamingServiceAdapter);
    }

    public String getMulticastGroupAddress() {
        return this.discovery.getMulticastGroupAddress();
    }

    public void setMulticastGroupAddress(String string) {
        String string2 = this.discovery.getMulticastGroupAddress();
        this.discovery.setMulticastGroupAddress(string);
        this.firePropertyChanged(DISCOVER_MULTICAST_GROUP_ADDRESS_PROPERTY, string2, string);
    }

    public int getMulticastPort() {
        return this.discovery.getMulticastPort();
    }

    public void setMulticastPort(int n) {
        int n2 = this.discovery.getMulticastPort();
        this.discovery.setMulticastPort(n);
        this.firePropertyChanged(DISCOVER_MULTICAST_PORT_PROPERTY, n2, n);
    }

    public int getPacketTimeToLive() {
        return this.discovery.getPacketTimeToLive();
    }

    public void setPacketTimeToLive(int n) {
        int n2 = this.discovery.getPacketTimeToLive();
        this.discovery.setPacketTimeToLive(n);
        this.firePropertyChanged(DISCOVER_PACKET_TIME_TO_LIVE_PROPERTY, n2, n);
    }

    public int getAnnouncementDelay() {
        return this.discovery.getAnnouncementDelay();
    }

    public void setAnnouncementDelay(int n) {
        int n2 = this.discovery.getAnnouncementDelay();
        this.discovery.setAnnouncementDelay(n);
        this.firePropertyChanged(DISCOVER_ANNOUNCEMENT_DELAY_PROPERTY, n2, n);
    }

    public String getNamingServiceType() {
        return this.namingServiceType;
    }

    public JNDINamingServiceAdapter setNamingServiceToJNDINamingService() {
        String string = this.getNamingServiceType();
        this.setJNDINamingService(this.buildJNDINamingService());
        this.setRegistryNamingService(null);
        this.namingServiceType = JNDI_NAMING_SERVICE_PROPERTY;
        this.firePropertyChanged(NAMING_SERVICE_TYPE_PROPERTY, string, this.namingServiceType);
        return this.getJNDINamingService();
    }

    public RMIRegistryNamingServiceAdapter setNamingServiceToRMIRegistryNamingService() {
        String string = this.getNamingServiceType();
        this.setJNDINamingService(null);
        this.setRegistryNamingService(this.buildRegistryNamingService());
        this.namingServiceType = RMI_REGISTRY_NAMING_SERVICE_PROPERTY;
        this.firePropertyChanged(NAMING_SERVICE_TYPE_PROPERTY, string, this.namingServiceType);
        return this.getRMIRegistryNamingService();
    }

    public String getEncryptionClass() {
        return this.namingService.getEncryptionClass();
    }

    public void setEncryptionClass(String string) {
        String string2 = this.namingService.getEncryptionClass();
        this.namingService.setEncryptionClass(string);
        this.firePropertyChanged(JNDI_ENCRYPTION_CLASS_PROPERTY, string2, string);
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        if (this.getJNDINamingService() != null) {
            list.add(this.getJNDINamingService());
        }
        if (this.getRMIRegistryNamingService() != null) {
            list.add(this.getRMIRegistryNamingService());
        }
    }

    public boolean isSynchronous() {
        String string = this.manager().getSendMode();
        return string != null && string.equalsIgnoreCase("Synchronous");
    }

    public void setSynchronous(boolean bl) {
        boolean bl2 = this.removeConnectionOnError();
        if (bl) {
            this.manager().setSendMode("Synchronous");
        } else {
            this.manager().setSendMode("Asynchronous");
        }
        this.firePropertyChanged(SEND_MODE_PROPERTY, bl2, bl);
    }
}

