/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.util.List;
import org.eclipse.persistence.internal.sessions.factories.model.rcm.RemoteCommandManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.rcm.command.CommandsConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.TransportManagerConfig;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.CommandsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.JMSTopicTransportManagerAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.RMIIIOPTransportManagerAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.RMITransportManagerAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SunCORBATransportManagerAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TransportManagerAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.UserDefinedTransportManagerAdapter;

public class RemoteCommandManagerAdapter
extends SCAdapter {
    public static final String CHANNEL_PROPERTY = "channelConfig";
    private volatile CommandsAdapter commands;
    public static final String COMMANDS_PROPERTY = "commandsConfig";
    private volatile TransportManagerAdapter transportManager;
    public static final String TRANSPORT_MANAGER_PROPERTY = "transportManagerConfig";
    public static final String CACHE_SYNC_PROPERTY = "cacheSyncConfig";

    RemoteCommandManagerAdapter(SCAdapter sCAdapter, RemoteCommandManagerConfig remoteCommandManagerConfig) {
        super(sCAdapter, remoteCommandManagerConfig);
    }

    protected RemoteCommandManagerAdapter(SCAdapter sCAdapter) {
        super(sCAdapter);
    }

    private final RemoteCommandManagerConfig rcm() {
        return (RemoteCommandManagerConfig)this.getModel();
    }

    protected Object buildModel() {
        return new RemoteCommandManagerConfig();
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        if (this.transportManager != null) {
            list.add(this.getTransportManager());
        }
        if (this.commands != null) {
            list.add(this.getCommands());
        }
    }

    private CommandsAdapter buildCommands() {
        CommandsConfig commandsConfig = new CommandsConfig();
        this.rcm().setCommandsConfig(commandsConfig);
        return new CommandsAdapter((SCAdapter)this, commandsConfig);
    }

    private TransportManagerAdapter buildDefaultTransportManager() {
        return this.buildJMSTransportManager();
    }

    private JMSTopicTransportManagerAdapter buildJMSTransportManager() {
        return new JMSTopicTransportManagerAdapter(this);
    }

    private RMITransportManagerAdapter buildRMITransportManager() {
        return new RMITransportManagerAdapter(this);
    }

    private RMIIIOPTransportManagerAdapter buildRMIIIOPTransportManager() {
        return new RMIIIOPTransportManagerAdapter(this);
    }

    private UserDefinedTransportManagerAdapter buildUserDefinedTransportManager() {
        return new UserDefinedTransportManagerAdapter(this);
    }

    private SunCORBATransportManagerAdapter buildSunCORBATransportManager() {
        return new SunCORBATransportManagerAdapter(this);
    }

    protected void initializeFromModel(Object object) {
        super.initializeFromModel(object);
        this.commands = (CommandsAdapter)this.adapt(this.rcm().getCommandsConfig());
        this.transportManager = (TransportManagerAdapter)this.adapt(this.rcm().getTransportManagerConfig());
    }

    protected void initialize(Object object) {
        super.initialize(object);
        this.commands = null;
        this.transportManager = null;
    }

    protected void initializeDefaults() {
        super.initializeDefaults();
        this.setCacheSync(true);
        if (this.rcm().getChannel() == null) {
            this.setChannel("TopLinkCommandChannel");
        }
    }

    public TransportManagerAdapter getTransportManager() {
        if (this.transportManager == null) {
            this.setTransportManager(this.buildDefaultTransportManager());
        }
        return this.transportManager;
    }

    private void setTransportManager(TransportManagerAdapter transportManagerAdapter) {
        TransportManagerAdapter transportManagerAdapter2 = this.transportManager;
        this.transportManager = transportManagerAdapter;
        this.rcm().setTransportManagerConfig((TransportManagerConfig)transportManagerAdapter.getModel());
        this.firePropertyChanged(TRANSPORT_MANAGER_PROPERTY, (Object)transportManagerAdapter2, (Object)transportManagerAdapter);
    }

    public String getChannel() {
        return this.rcm().getChannel();
    }

    public void setChannel(String string) {
        String string2 = this.rcm().getChannel();
        this.rcm().setChannel(string);
        this.firePropertyChanged(CHANNEL_PROPERTY, string2, string);
    }

    public boolean usesCacheSync() {
        return this.getCommands().usesCacheSync();
    }

    private void setCacheSync(boolean bl) {
        boolean bl2 = this.getCommands().usesCacheSync();
        this.commands.setCacheSync(bl);
        this.firePropertyChanged(CACHE_SYNC_PROPERTY, bl2, bl);
    }

    CommandsAdapter getCommands() {
        if (this.commands == null) {
            this.setCommands(this.buildCommands());
        }
        return this.commands;
    }

    private void setCommands(CommandsAdapter commandsAdapter) {
        CommandsAdapter commandsAdapter2 = this.commands;
        this.commands = commandsAdapter;
        this.rcm().setCommandsConfig((CommandsConfig)commandsAdapter.getModel());
        this.firePropertyChanged(COMMANDS_PROPERTY, (Object)commandsAdapter2, (Object)commandsAdapter);
    }

    public JMSTopicTransportManagerAdapter setTransportAsJMSTopic() {
        if (!(this.transportManager instanceof JMSTopicTransportManagerAdapter)) {
            this.setTransportManager(this.buildJMSTransportManager());
        }
        this.setChannel("TopLinkCommandChannel");
        return (JMSTopicTransportManagerAdapter)this.transportManager;
    }

    public RMITransportManagerAdapter setTransportAsRMI() {
        this.setTransportManager(this.buildRMITransportManager());
        return (RMITransportManagerAdapter)this.transportManager;
    }

    public RMIIIOPTransportManagerAdapter setTransportAsRMIIIOP() {
        this.setTransportManager(this.buildRMIIIOPTransportManager());
        return (RMIIIOPTransportManagerAdapter)this.transportManager;
    }

    public UserDefinedTransportManagerAdapter setTransportAsUserDefined() {
        this.setTransportManager(this.buildUserDefinedTransportManager());
        return (UserDefinedTransportManagerAdapter)this.transportManager;
    }

    public SunCORBATransportManagerAdapter setTransportAsSunCORBA() {
        this.setTransportManager(this.buildSunCORBATransportManager());
        return (SunCORBATransportManagerAdapter)this.transportManager;
    }
}

