/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.ListIterator;
import java.util.prefs.Preferences;
import org.eclipse.persistence.internal.sessions.factories.XMLSessionConfigWriter;
import org.eclipse.persistence.internal.sessions.factories.model.SessionConfigs;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.Nominative;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.meta.ClassRepository;
import org.eclipse.persistence.tools.workbench.scplugin.model.meta.SCSessionsProperties;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.events.DefaultChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

abstract class RootSCAdapter
extends SCAdapter
implements Nominative {
    private volatile String name;
    private volatile SessionManager sessionManager;
    private volatile SCSessionsProperties properties;
    private volatile Preferences preferences;
    private volatile File savePath;
    public static final String SAVE_PATH_PROPERTY = "configSavePath";
    private ChangeNotifier changeNotifier;
    private volatile Node.Validator validator;
    private static final String CR = System.getProperty("line.separator");

    RootSCAdapter(SCSessionsProperties sCSessionsProperties, Preferences preferences, boolean bl) {
        this.initialize(sCSessionsProperties, preferences);
        if (bl) {
            this.initialize(this.buildModel());
            this.initializeDefaults();
            this.setConfigClean(true);
        } else {
            this.initializeFromModel(this.load());
            this.markEntireBranchClean();
            this.postInitializationFromModel();
            this.setConfigClean(false);
        }
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.getClassRepository());
    }

    protected void initialize() {
        super.initialize();
        this.sessionManager = SessionManager.getManager();
    }

    private void initialize(SCSessionsProperties sCSessionsProperties, Preferences preferences) {
        this.changeNotifier = DefaultChangeNotifier.instance();
        this.validator = NULL_VALIDATOR;
        this.properties = sCSessionsProperties;
        this.preferences = preferences;
        this.savePath = sCSessionsProperties.getPath();
        this.setName(this.savePath.getName());
        sCSessionsProperties.getClassRepository().setParent((Node)this);
    }

    private SessionConfigs load() {
        SessionConfigs sessionConfigs = this.sessionManager.getInternalMWConfigObjects(this.getPath().getPath(), this.buildLoader(), false);
        return sessionConfigs;
    }

    private URL[] buildEntries() {
        ListIterator listIterator = this.getClassRepository().classpathEntries();
        URL[] uRLArray = new URL[this.getClassRepository().classpathEntriesSize()];
        int n = 0;
        while (listIterator.hasNext()) {
            try {
                URL uRL = new URL("file", "", (String)listIterator.next());
                uRLArray[n++] = uRL;
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return uRLArray;
    }

    private ClassLoader buildLoader() {
        URLClassLoader uRLClassLoader = new URLClassLoader(this.buildEntries(), this.getClass().getClassLoader()){

            public URL findResource(String string) {
                try {
                    if (string.equals(RootSCAdapter.this.getPath().getPath())) {
                        return RootSCAdapter.this.getPath().toURL();
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                URL uRL = super.findResource(string);
                if (uRL != null) {
                    return uRL;
                }
                return this.getClass().getResource(string);
            }
        };
        return uRLClassLoader;
    }

    public void save(File file) throws IOException {
        this.setSavePath(file);
        this.save();
    }

    public void save() throws IOException {
        this.preSaving();
        XMLSessionConfigWriter.write((SessionConfigs)((SessionConfigs)this.getModel()), (String)this.getPath().toString());
        this.postSaving();
        this.markEntireBranchClean();
    }

    public String displayString() {
        return this.name;
    }

    public File getPath() {
        return this.properties.getPath();
    }

    public SCSessionsProperties getProperties() {
        return this.properties;
    }

    Preferences preferences() {
        return this.preferences;
    }

    public ClassRepository getClassRepository() {
        return this.properties.getClassRepository();
    }

    public File getSaveDirectory() {
        return this.properties.getPath().getParentFile();
    }

    private void setSavePath(File file) {
        File file2 = this.getSavePath();
        this.savePath = file;
        this.properties.pathChanged(file);
        this.firePropertyChanged(SAVE_PATH_PROPERTY, file2, file);
        this.setName(file.getName());
    }

    private File getSavePath() {
        return this.savePath;
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(CR).append("\t").append(this.displayString() + "( " + this.getConfigFileVersion() + " )");
    }

    public String getName() {
        return this.name;
    }

    private void setName(String string) {
        String string2 = this.getName();
        this.name = FileTools.stripExtension((String)string);
        this.firePropertyChanged("name", string2, string);
    }

    public ChangeNotifier getChangeNotifier() {
        return this.changeNotifier;
    }

    public void setChangeNotifier(ChangeNotifier changeNotifier) {
        this.changeNotifier = changeNotifier;
    }

    public Node.Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Node.Validator validator) {
        this.validator = validator;
    }

    protected void markEntireConfigurationClean() {
    }
}

