/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.internal.sessions.factories.model.sequencing.SequenceConfig;
import org.eclipse.persistence.internal.sessions.factories.model.sequencing.SequencingConfig;
import org.eclipse.persistence.tools.workbench.scplugin.model.SequenceType;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DefaultSequenceAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.NativeSequenceAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SequenceAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TableSequenceAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.UnaryTableSequenceAdapter;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequencingAdapter
extends SCAdapter {
    public static final String DEFAULT_SEQUENCE_NAME = "Default";
    public static final String NATIVE_SEQUENCE_NAME = "Native";
    public static final String CUSTOM_SEQUENCE_NAME = "Custom";
    private List<SequenceAdapter> sequences;
    private volatile SequenceAdapter defaultSequence;

    SequencingAdapter(SCAdapter sCAdapter, SequencingConfig sequencingConfig) {
        super(sCAdapter, sequencingConfig);
    }

    protected SequencingAdapter(SCAdapter sCAdapter) {
        super(sCAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        List<SequenceAdapter> list2 = this.sequences;
        synchronized (list2) {
            list.addAll(this.sequences);
        }
        if (this.defaultSequence != null) {
            list.add(this.defaultSequence);
        }
    }

    @Override
    protected Object buildModel() {
        return new SequencingConfig();
    }

    private final SequencingConfig config() {
        return (SequencingConfig)this.getModel();
    }

    int getDefaultSequencePreallocationSize() {
        return this.defaultSequence.getPreallocationSize();
    }

    void setDefaultSequencePreallocationSize(int n) {
        this.defaultSequence.setPreallocationSize(n);
    }

    String getTableSequenceTable() {
        if (this.defaultSequence.isNative()) {
            return null;
        }
        return ((TableSequenceAdapter)this.defaultSequence).getSequenceTable();
    }

    void setTableSequenceTable(String string) {
        ((TableSequenceAdapter)this.defaultSequence).setSequenceTable(string);
    }

    String getTableSequenceNameField() {
        if (this.defaultSequence.isNative()) {
            return null;
        }
        return ((TableSequenceAdapter)this.defaultSequence).getSequenceNameField();
    }

    void setTableSequenceNameField(String string) {
        ((TableSequenceAdapter)this.defaultSequence).setSequenceNameField(string);
    }

    String getTableSequenceCounterField() {
        if (this.defaultSequence.isNative()) {
            return null;
        }
        return ((TableSequenceAdapter)this.defaultSequence).getSequenceCounterField();
    }

    void setTableSequenceCounterField(String string) {
        ((TableSequenceAdapter)this.defaultSequence).setSequenceCounterField(string);
    }

    private boolean defaultSequenceNameEquals(String string) {
        return this.defaultSequence != null && this.defaultSequence.getName().equals(string);
    }

    SequenceAdapter setDefaultTableSequenceTable(String string, int n) {
        if (this.defaultSequenceNameEquals(string)) {
            return this.defaultSequence;
        }
        this.defaultSequence = new TableSequenceAdapter(this, string, n);
        this.config().setDefaultSequenceConfig((SequenceConfig)this.defaultSequence.getModel());
        this.initializeDefaultSequenceDefaults();
        return this.defaultSequence;
    }

    SequenceAdapter setNativeSequencing(String string, int n) {
        if (this.defaultSequenceNameEquals(string)) {
            return this.defaultSequence;
        }
        this.defaultSequence = new NativeSequenceAdapter(this, string, n);
        this.config().setDefaultSequenceConfig((SequenceConfig)this.defaultSequence.getModel());
        return this.defaultSequence;
    }

    private void initializeDefaultSequenceDefaults() {
        TableSequenceAdapter tableSequenceAdapter = (TableSequenceAdapter)this.defaultSequence;
        tableSequenceAdapter.setSequenceTable("SEQUENCE");
        tableSequenceAdapter.setSequenceCounterField("SEQ_COUNT");
        tableSequenceAdapter.setSequenceNameField("SEQ_NAME");
    }

    SequenceAdapter removeDefaultSequence() {
        if (this.defaultSequence == null) {
            return null;
        }
        SequenceAdapter sequenceAdapter = this.defaultSequence;
        this.config().setDefaultSequenceConfig(null);
        this.defaultSequence = null;
        return sequenceAdapter;
    }

    SequenceAdapter removeSequenceNamed(String string) {
        return this.removeSequence(this.sequenceNamed(string));
    }

    private SequenceAdapter addSequence(SequenceAdapter sequenceAdapter) {
        this.getSequenceConfigs().add((SequenceConfig)sequenceAdapter.getModel());
        this.sequences.add(sequenceAdapter);
        return sequenceAdapter;
    }

    public SequenceAdapter addSequence(String string, SequenceType sequenceType) {
        SequenceAdapter sequenceAdapter = this.buildSequence(string, sequenceType);
        return this.addSequence(sequenceAdapter);
    }

    private SequenceAdapter buildSequence(String string, SequenceType sequenceType) {
        switch (sequenceType) {
            case DEFAULT: {
                return new DefaultSequenceAdapter(this, string, 50);
            }
            case NATIVE: {
                return new NativeSequenceAdapter(this, string, 50);
            }
            case TABLE: {
                return new TableSequenceAdapter(this, string, 50);
            }
            case UNARY_TABLE: {
                return new UnaryTableSequenceAdapter(this, string, 50);
            }
        }
        return null;
    }

    public SequenceAdapter removeSequence(SequenceAdapter sequenceAdapter) {
        this.getSequenceConfigs().remove(sequenceAdapter.getModel());
        this.sequences.remove(sequenceAdapter);
        return sequenceAdapter;
    }

    private Collection getSequenceConfigs() {
        return this.config().getSequenceConfigs();
    }

    boolean usesNativeSequencing() {
        return this.defaultSequenceNameEquals(NATIVE_SEQUENCE_NAME);
    }

    public SequenceAdapter getDefaultSequence() {
        return this.defaultSequence;
    }

    public void setDefaultSequence(SequenceAdapter sequenceAdapter) {
        this.defaultSequence.setTheDefaultSequence(false);
        this.defaultSequence = sequenceAdapter;
        sequenceAdapter.setTheDefaultSequence(true);
        this.config().setDefaultSequenceConfig((SequenceConfig)this.defaultSequence.getModel());
    }

    public SequenceAdapter createAndSetDefaultSequence(String string, SequenceType sequenceType) {
        SequenceAdapter sequenceAdapter = this.buildSequence(string, sequenceType);
        this.setDefaultSequence(sequenceAdapter);
        return sequenceAdapter;
    }

    protected SequenceAdapter buildDefaultSequence() {
        TableSequenceAdapter tableSequenceAdapter = new TableSequenceAdapter(this, DEFAULT_SEQUENCE_NAME, 50);
        tableSequenceAdapter.setTheDefaultSequence(true);
        this.config().setDefaultSequenceConfig((SequenceConfig)tableSequenceAdapter.getModel());
        return tableSequenceAdapter;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.sequences = new Vector<SequenceAdapter>();
    }

    @Override
    protected void initialize(Object object) {
        super.initialize(object);
        this.defaultSequence = this.buildDefaultSequence();
        this.config().setSequenceConfigs(new Vector());
    }

    @Override
    protected void initializeDefaults() {
        super.initializeDefaults();
        this.setDefaultSequencePreallocationSize(50);
    }

    @Override
    protected void initializeFromModel(Object object) {
        super.initializeFromModel(object);
        this.defaultSequence = (SequenceAdapter)this.adapt(this.config().getDefaultSequenceConfig());
        if (this.defaultSequence == null) {
            this.defaultSequence = this.buildDefaultSequence();
        } else {
            this.defaultSequence.setTheDefaultSequence(true);
        }
        if (this.getSequenceConfigs() != null) {
            this.sequences.addAll(this.adaptAll(this.getSequenceConfigs()));
        }
    }

    SequenceAdapter sequenceNamed(String string) {
        ListIterator<SequenceAdapter> listIterator = this.sequences();
        while (listIterator.hasNext()) {
            SequenceAdapter sequenceAdapter = (SequenceAdapter)listIterator.next();
            if (!string.equals(sequenceAdapter.getName())) continue;
            return sequenceAdapter;
        }
        return null;
    }

    public ListIterator<SequenceAdapter> sequences() {
        return new CloneListIterator(this.sequences);
    }

    public Iterator<String> sequenceNames() {
        ListIterator<SequenceAdapter> listIterator = this.sequences();
        ArrayList<String> arrayList = new ArrayList<String>(this.sequencesSize());
        while (listIterator.hasNext()) {
            arrayList.add(((SequenceAdapter)listIterator.next()).getName());
        }
        return arrayList.iterator();
    }

    public int sequencesSize() {
        return this.sequences.size();
    }

    boolean isDefault() {
        return this.defaultSequence.isDefault();
    }

    boolean isNative() {
        return this.defaultSequence.isNative();
    }

    boolean isCustom() {
        return this.defaultSequence.isCustom();
    }
}

