/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.internal.sessions.factories.model.event.SessionEventManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.pool.ConnectionPolicyConfig;
import org.eclipse.persistence.internal.sessions.factories.model.pool.PoolsConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.DatabaseSessionConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.ServerSessionConfig;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ConnectionPolicyAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DataSource;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.PoolsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ReadConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerPlatform;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.WriteConnectionPoolAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServerSessionAdapter
extends DatabaseSessionAdapter {
    private volatile PoolsAdapter pools;
    public static final String POOLS_CONFIG_COLLECTION = "pools";
    private volatile ConnectionPolicyAdapter connectionPolicy;
    public static final String USE_EXCLUSIVE_CONNECTION_PROPERTY = "useExclusiveConnection";
    public static final String LAZY_CONNECTION_PROPERTY = "lazyConnection";
    public static final String READ_CONNECTION_POOL_PROPERTY = "readConnectionPool";
    public static final String WRITE_CONNECTION_POOL_PROPERTY = "writeConnectionPool";
    public static final String SEQUENCE_CONNECTION_POOL_PROPERTY = "sequenceConnectionPool";

    ServerSessionAdapter(SCAdapter sCAdapter, ServerSessionConfig serverSessionConfig) {
        super(sCAdapter, (DatabaseSessionConfig)serverSessionConfig);
        this.initializePoolsFromModel();
    }

    protected ServerSessionAdapter(SCAdapter sCAdapter, String string, ServerPlatform serverPlatform, DataSource dataSource) {
        super(sCAdapter, string, serverPlatform, dataSource);
        this.initializePools();
    }

    @Override
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        if (this.getPools() != null) {
            list.add(this.getPools());
        }
    }

    @Override
    protected Object buildModel() {
        ServerSessionConfig serverSessionConfig = new ServerSessionConfig();
        serverSessionConfig.setAdditionalProjects(new Vector());
        serverSessionConfig.setSessionEventManagerConfig(new SessionEventManagerConfig());
        return serverSessionConfig;
    }

    private PoolsAdapter buildPools() {
        PoolsAdapter poolsAdapter = new PoolsAdapter(this);
        this.serverSession().setPoolsConfig((PoolsConfig)poolsAdapter.getModel());
        return poolsAdapter;
    }

    public ConnectionPoolAdapter addWriteConnectionPool() {
        WriteConnectionPoolAdapter writeConnectionPoolAdapter = this.pools.addWriteConnectionPool();
        this.fireItemAdded(POOLS_CONFIG_COLLECTION, writeConnectionPoolAdapter);
        this.firePropertyChanged(WRITE_CONNECTION_POOL_PROPERTY, null, writeConnectionPoolAdapter);
        return writeConnectionPoolAdapter;
    }

    public ConnectionPoolAdapter addReadConnectionPool() {
        ReadConnectionPoolAdapter readConnectionPoolAdapter = this.pools.addReadConnectionPool();
        this.fireItemAdded(POOLS_CONFIG_COLLECTION, readConnectionPoolAdapter);
        this.firePropertyChanged(READ_CONNECTION_POOL_PROPERTY, null, readConnectionPoolAdapter);
        return readConnectionPoolAdapter;
    }

    public ConnectionPoolAdapter addSequenceConnectionPool() {
        ConnectionPoolAdapter connectionPoolAdapter = this.pools.addSequenceConnectionPool();
        this.fireItemAdded(POOLS_CONFIG_COLLECTION, connectionPoolAdapter);
        this.firePropertyChanged(SEQUENCE_CONNECTION_POOL_PROPERTY, null, connectionPoolAdapter);
        return connectionPoolAdapter;
    }

    @Override
    public void setExternalConnectionPooling(boolean bl) {
        super.setExternalConnectionPooling(bl);
        if (bl && this.pools.getReadConnectionPool() != null) {
            this.pools.getReadConnectionPool().setExclusive(false);
        }
    }

    protected void initializePoolsFromModel() {
        this.pools = this.getPoolConfigs() == null ? this.buildPools() : (PoolsAdapter)this.adapt(this.getPoolConfigs());
    }

    protected void initializePools() {
        this.pools = this.buildPools();
    }

    @Override
    protected void initialize(Object object) {
        super.initialize(object);
        this.connectionPolicy = this.buildConnectionPolicy();
    }

    @Override
    protected void initializeFromModel(Object object) {
        super.initializeFromModel(object);
        this.connectionPolicy = (ConnectionPolicyAdapter)this.adapt(this.getConnectionPolicyConfig());
        if (this.connectionPolicy == null) {
            this.connectionPolicy = this.buildConnectionPolicy();
        }
    }

    private final ServerSessionConfig serverSession() {
        return (ServerSessionConfig)this.getModel();
    }

    private PoolsConfig getPoolConfigs() {
        return this.serverSession().getPoolsConfig();
    }

    public Iterator pools() {
        return this.pools.pools();
    }

    public int poolsSize() {
        return this.pools.poolsSize();
    }

    private PoolsAdapter getPools() {
        return this.pools;
    }

    public Iterator<String> poolNames() {
        return this.getPools().getPoolNames().iterator();
    }

    public ReadConnectionPoolAdapter getReadConnectionPool() {
        return this.pools.getReadConnectionPool();
    }

    public ConnectionPoolAdapter getWriteConnectionPool() {
        return this.pools.getWriteConnectionPool();
    }

    public ConnectionPoolAdapter getSequenceConnectionPool() {
        return this.pools.getSequenceConnectionPool();
    }

    public boolean hasReadPool() {
        return this.pools.getReadConnectionPool() != null;
    }

    public boolean hasWritePool() {
        return this.pools.getWriteConnectionPool() != null;
    }

    public boolean hasAnyConnectionPool() {
        return this.hasReadPool() || this.hasWritePool() || this.hasSequencePool() || this.poolsSize() > 0;
    }

    @Override
    public boolean isServer() {
        return true;
    }

    public boolean hasSequencePool() {
        return this.pools.getSequenceConnectionPool() != null;
    }

    public ConnectionPoolAdapter poolNamed(String string) {
        return this.pools.poolNamed(string);
    }

    public ConnectionPoolAdapter addConnectionPoolNamed(String string) {
        ConnectionPoolAdapter connectionPoolAdapter = this.pools.addConnectionPoolNamed(string);
        this.fireItemAdded(POOLS_CONFIG_COLLECTION, connectionPoolAdapter);
        return connectionPoolAdapter;
    }

    public void removeConnectionPoolNamed(String string) {
        ConnectionPoolAdapter connectionPoolAdapter = this.pools.removeConnectionPoolNamed(string);
        if (connectionPoolAdapter != null) {
            this.fireItemRemoved(POOLS_CONFIG_COLLECTION, connectionPoolAdapter);
        }
    }

    public void removeWriteConnectionPool() {
        ConnectionPoolAdapter connectionPoolAdapter = this.pools.removeWriteConnectionPool();
        if (connectionPoolAdapter != null) {
            this.fireItemRemoved(POOLS_CONFIG_COLLECTION, connectionPoolAdapter);
        }
    }

    public void removeReadConnectionPool() {
        ConnectionPoolAdapter connectionPoolAdapter = this.pools.removeReadConnectionPool();
        if (connectionPoolAdapter != null) {
            this.fireItemRemoved(POOLS_CONFIG_COLLECTION, connectionPoolAdapter);
        }
    }

    public void removeAllConnectionPools() {
        this.removeReadConnectionPool();
        this.removeWriteConnectionPool();
        this.removeSequenceConnectionPool();
        Iterator<String> iterator = this.poolNames();
        while (iterator.hasNext()) {
            this.removeConnectionPoolNamed(iterator.next());
        }
    }

    public void removeSequenceConnectionPool() {
        ConnectionPoolAdapter connectionPoolAdapter = this.pools.removeSequenceConnectionPool();
        if (connectionPoolAdapter != null) {
            this.fireItemRemoved(POOLS_CONFIG_COLLECTION, connectionPoolAdapter);
        }
    }

    private ConnectionPolicyAdapter buildConnectionPolicy() {
        ConnectionPolicyAdapter connectionPolicyAdapter = new ConnectionPolicyAdapter(this);
        this.serverSession().setConnectionPolicyConfig((ConnectionPolicyConfig)connectionPolicyAdapter.getModel());
        return connectionPolicyAdapter;
    }

    private ConnectionPolicyConfig getConnectionPolicyConfig() {
        return this.serverSession().getConnectionPolicyConfig();
    }

    private ConnectionPolicyAdapter getConnectionPolicy() {
        return this.connectionPolicy;
    }

    public boolean usesExclusiveConnection() {
        return this.getConnectionPolicy().usesExclusiveConnection();
    }

    public void setUseExclusiveConnection(boolean bl) {
        boolean bl2 = this.getConnectionPolicy().usesExclusiveConnection();
        this.getConnectionPolicy().setUseExclusiveConnection(bl);
        this.firePropertyChanged(USE_EXCLUSIVE_CONNECTION_PROPERTY, bl2, bl);
    }

    public boolean usesLazyConnection() {
        return this.getConnectionPolicy().usesLazyConnection();
    }

    public void setLazyConnection(boolean bl) {
        boolean bl2 = this.getConnectionPolicy().usesLazyConnection();
        this.getConnectionPolicy().setLazyConnection(bl);
        this.firePropertyChanged(LAZY_CONNECTION_PROPERTY, bl2, bl);
    }
}

