/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.persistence.internal.sessions.factories.model.login.AppendNewElementsOrderingPolicyConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.DescriptorLevelDocumentPreservationPolicyConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.DocumentPreservationPolicyConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.IgnoreNewElementsOrderingPolicyConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.LoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.NoDocumentPreservationPolicyConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.NodeOrderingPolicyConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.RelativePositionOrderingPolicyConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.XMLBinderPolicyConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.XMLLoginConfig;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.LoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLLoginAdapter
extends LoginAdapter {
    public static final String EQUAL_NAMESPACE_RESOLVERS_PROPERTY = "equalNamespaceResolvers";
    public static final String DOCUMENT_PRESERVATION_POLICY_PROPERTY = "documentPreservationPolicy";
    public static final String DESCRIPTOR_LEVEL_DOCUMENT_PRESERVATION_POLICY = "Descriptor Level";
    public static final String NO_DOCUMENT_PRESERVATION_POLICY = "No Document";
    public static final String XML_BINDER_PRESERVATION_POLICY = "XML Binder";
    public static final String NODE_ORDERING_POLICY_PROPERTY = "nodeOrderingPolicy";
    public static final String APPEND_NEW_ELEMENTS = "Append New Elements";
    public static final String IGNORE_NEW_ELEMENTS = "Ignore New Elements";
    public static final String RELATIVE_POSITION = "Relative Position";
    public static final String SAX_RUNTIME_PLATFORM_CLASS_NAME = "oracle.toplink.ox.platform.SAXPlatform";
    public static final String DOM_RUNTIME_PLATFORM_CLASS_NAME = "oracle.toplink.ox.platform.DOMPlatform";
    public static final String DEFAULT_PLATFORM_CLASS_NAME = "oracle.toplink.ox.platform.SAXPlatform";

    XMLLoginAdapter(SCAdapter sCAdapter, XMLLoginConfig xMLLoginConfig) {
        super(sCAdapter, (LoginConfig)xMLLoginConfig);
    }

    protected XMLLoginAdapter(SCAdapter sCAdapter) {
        super(sCAdapter);
    }

    @Override
    protected void initializeDefaults() {
        super.initializeDefaults();
        this.setPlatformClass(this.getDefaultPlatformClassName());
        this.setDocumentPreservationPolicy(NO_DOCUMENT_PRESERVATION_POLICY);
        this.setNodeOrderingPolicy(APPEND_NEW_ELEMENTS);
    }

    @Override
    protected void initializeFromModel(Object object) {
        super.initializeFromModel(object);
        if (this.getDocumentPreservationPolicyConfig() == null) {
            this.setDocumentPreservationPolicy(NO_DOCUMENT_PRESERVATION_POLICY);
        }
        if (this.getNodeOrderingPolicyConfig() == null) {
            this.setNodeOrderingPolicy(APPEND_NEW_ELEMENTS);
        }
    }

    @Override
    protected Object buildModel() {
        return new XMLLoginConfig();
    }

    private DocumentPreservationPolicyConfig getDocumentPreservationPolicyConfig() {
        return this.login().getDocumentPreservationPolicy();
    }

    private NodeOrderingPolicyConfig getNodeOrderingPolicyConfig() {
        return this.getDocumentPreservationPolicyConfig().getNodeOrderingPolicy();
    }

    @Override
    protected String getDefaultPlatformClassName() {
        return "oracle.toplink.ox.platform.SAXPlatform";
    }

    public Collection<String> getPlatformClassOptions() {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add("oracle.toplink.ox.platform.SAXPlatform");
        arrayList.add(DOM_RUNTIME_PLATFORM_CLASS_NAME);
        return arrayList;
    }

    public Collection<String> getDocumentPreservationPolicyOptions() {
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(NO_DOCUMENT_PRESERVATION_POLICY);
        arrayList.add(DESCRIPTOR_LEVEL_DOCUMENT_PRESERVATION_POLICY);
        arrayList.add(XML_BINDER_PRESERVATION_POLICY);
        return arrayList;
    }

    public Collection<String> getNodeOrderingPolicyOptions() {
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(APPEND_NEW_ELEMENTS);
        arrayList.add(IGNORE_NEW_ELEMENTS);
        arrayList.add(RELATIVE_POSITION);
        return arrayList;
    }

    @Override
    boolean platformIsXml() {
        return true;
    }

    private final XMLLoginConfig login() {
        return (XMLLoginConfig)this.getModel();
    }

    public boolean isEqualNamespaceResolvers() {
        return this.login().getEqualNamespaceResolvers();
    }

    public void setEqualNamespaceResolvers(boolean bl) {
        boolean bl2 = this.login().getEqualNamespaceResolvers();
        this.login().setEqualNamespaceResolvers(bl);
        this.firePropertyChanged(EQUAL_NAMESPACE_RESOLVERS_PROPERTY, bl2, bl);
    }

    public String getDocumentPreservationPolicyType() {
        if (this.getDocumentPreservationPolicyConfig() instanceof DescriptorLevelDocumentPreservationPolicyConfig) {
            return DESCRIPTOR_LEVEL_DOCUMENT_PRESERVATION_POLICY;
        }
        if (this.getDocumentPreservationPolicyConfig() instanceof NoDocumentPreservationPolicyConfig) {
            return NO_DOCUMENT_PRESERVATION_POLICY;
        }
        if (this.getDocumentPreservationPolicyConfig() instanceof XMLBinderPolicyConfig) {
            return XML_BINDER_PRESERVATION_POLICY;
        }
        throw new IllegalStateException("Invalid document preservation policy type.");
    }

    public void setDocumentPreservationPolicy(String string) {
        DocumentPreservationPolicyConfig documentPreservationPolicyConfig = this.login().getDocumentPreservationPolicy();
        DocumentPreservationPolicyConfig documentPreservationPolicyConfig2 = this.setConfigDocumentPreservationPolicy(string);
        this.setNodeOrderingPolicy(APPEND_NEW_ELEMENTS);
        this.firePropertyChanged(DOCUMENT_PRESERVATION_POLICY_PROPERTY, documentPreservationPolicyConfig, documentPreservationPolicyConfig2);
    }

    private DocumentPreservationPolicyConfig setConfigDocumentPreservationPolicy(String string) {
        NoDocumentPreservationPolicyConfig noDocumentPreservationPolicyConfig = null;
        if (NO_DOCUMENT_PRESERVATION_POLICY.equals(string)) {
            noDocumentPreservationPolicyConfig = new NoDocumentPreservationPolicyConfig();
            this.login().setDocumentPreservationPolicy((DocumentPreservationPolicyConfig)noDocumentPreservationPolicyConfig);
        } else if (DESCRIPTOR_LEVEL_DOCUMENT_PRESERVATION_POLICY.equals(string)) {
            noDocumentPreservationPolicyConfig = new DescriptorLevelDocumentPreservationPolicyConfig();
            this.login().setDocumentPreservationPolicy((DocumentPreservationPolicyConfig)noDocumentPreservationPolicyConfig);
        } else if (XML_BINDER_PRESERVATION_POLICY.equals(string)) {
            noDocumentPreservationPolicyConfig = new XMLBinderPolicyConfig();
            this.login().setDocumentPreservationPolicy((DocumentPreservationPolicyConfig)noDocumentPreservationPolicyConfig);
        }
        return noDocumentPreservationPolicyConfig;
    }

    public String getNodeOrderingPolicyType() {
        if (this.getNodeOrderingPolicyConfig() instanceof AppendNewElementsOrderingPolicyConfig) {
            return APPEND_NEW_ELEMENTS;
        }
        if (this.getNodeOrderingPolicyConfig() instanceof IgnoreNewElementsOrderingPolicyConfig) {
            return IGNORE_NEW_ELEMENTS;
        }
        if (this.getNodeOrderingPolicyConfig() instanceof RelativePositionOrderingPolicyConfig) {
            return RELATIVE_POSITION;
        }
        throw new IllegalStateException("Invalid node ordering policy type.");
    }

    public void setNodeOrderingPolicy(String string) {
        NodeOrderingPolicyConfig nodeOrderingPolicyConfig = this.getNodeOrderingPolicyConfig();
        NodeOrderingPolicyConfig nodeOrderingPolicyConfig2 = this.setConfigNodeOrderingPolicy(string);
        this.firePropertyChanged(NODE_ORDERING_POLICY_PROPERTY, nodeOrderingPolicyConfig, nodeOrderingPolicyConfig2);
    }

    private NodeOrderingPolicyConfig setConfigNodeOrderingPolicy(String string) {
        AppendNewElementsOrderingPolicyConfig appendNewElementsOrderingPolicyConfig = null;
        if (APPEND_NEW_ELEMENTS.equals(string)) {
            appendNewElementsOrderingPolicyConfig = new AppendNewElementsOrderingPolicyConfig();
            this.getDocumentPreservationPolicyConfig().setNodeOrderingPolicy((NodeOrderingPolicyConfig)appendNewElementsOrderingPolicyConfig);
        } else if (IGNORE_NEW_ELEMENTS.equals(string)) {
            appendNewElementsOrderingPolicyConfig = new IgnoreNewElementsOrderingPolicyConfig();
            this.getDocumentPreservationPolicyConfig().setNodeOrderingPolicy((NodeOrderingPolicyConfig)appendNewElementsOrderingPolicyConfig);
        } else if (RELATIVE_POSITION.equals(string)) {
            appendNewElementsOrderingPolicyConfig = new RelativePositionOrderingPolicyConfig();
            this.getDocumentPreservationPolicyConfig().setNodeOrderingPolicy((NodeOrderingPolicyConfig)appendNewElementsOrderingPolicyConfig);
        }
        return appendNewElementsOrderingPolicyConfig;
    }
}

