/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.meta;

import java.io.File;
import java.util.prefs.Preferences;
import org.eclipse.persistence.tools.workbench.scplugin.model.meta.ClassRepository;
import org.eclipse.persistence.tools.workbench.scplugin.model.meta.SCClassRepository;
import org.eclipse.persistence.tools.workbench.scplugin.model.meta.SCSessionsPropertiesManager;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class SCSessionsProperties
extends AbstractModel {
    private volatile SCClassRepository classRepository;
    private int index;
    volatile SCSessionsPropertiesManager manager;
    private volatile File path;
    private volatile String pathString;
    public static final String CLASSPATH_NODE_TAG = "classpath";
    public static final String CLASSPATH_TAG = "classpath_";
    public static final String LOCATION_TAG = "location_";

    private SCSessionsProperties() {
    }

    SCSessionsProperties(SCSessionsPropertiesManager sCSessionsPropertiesManager, File file, String[] stringArray, int n) {
        this.manager = sCSessionsPropertiesManager;
        this.initialize(file, stringArray, n);
    }

    private SCClassRepository buildClassRepository(String[] stringArray) {
        return new SCClassRepository(stringArray);
    }

    private int findNextAvailableIndex(Preferences preferences) {
        int n = 0;
        String string = LOCATION_TAG + n;
        try {
            Object[] objectArray = preferences.keys();
            while (CollectionTools.contains((Object[])objectArray, (Object)string)) {
                string = LOCATION_TAG + ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public ClassRepository getClassRepository() {
        return this.classRepository;
    }

    public int getIndex() {
        return this.index;
    }

    public File getPath() {
        return this.path;
    }

    public String getPathString() {
        return this.pathString;
    }

    private void initialize(File file, String[] stringArray, int n) {
        if (file == null) {
            throw new NullPointerException("The fully qualified path of the sessions.xml cannot be null");
        }
        this.pathChanged(file);
        this.classRepository = this.buildClassRepository(stringArray);
        this.index = n;
    }

    public void pathChanged(File file) {
        this.path = file;
        this.pathString = file.getPath();
        this.pathString = this.pathString.replace('\\', '/');
        this.manager.pathChanged(this);
    }

    public void save(Preferences preferences) {
        preferences = preferences.node(CLASSPATH_NODE_TAG);
        if (this.shouldBeSaved()) {
            if (this.index == -1) {
                this.index = this.findNextAvailableIndex(preferences);
            }
            preferences.put(LOCATION_TAG + this.index, this.pathString);
            preferences.put(CLASSPATH_TAG + this.index, this.classRepository.entries());
        } else {
            preferences.remove(LOCATION_TAG + this.index);
            preferences.remove(CLASSPATH_TAG + this.index);
            this.index = -1;
        }
        this.manager.addSessionsProperties(this);
    }

    public void saveAs(Preferences preferences, File file) {
        this.pathChanged(file);
        this.save(preferences);
    }

    boolean shouldBeSaved() {
        return this.classRepository.shouldBeSaved();
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        StringTools.buildSimpleToStringOn((Object)((Object)this), (StringBuffer)stringBuffer);
        stringBuffer.append(" (");
        this.toString(stringBuffer);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append("path=");
        stringBuffer.append(this.path);
        stringBuffer.append(", classRepository=");
        stringBuffer.append(this.classRepository);
    }
}

