/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.meta;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import java.util.prefs.Preferences;
import org.eclipse.persistence.tools.workbench.scplugin.model.meta.SCSessionsProperties;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class SCSessionsPropertiesManager
extends AbstractModel {
    private final Preferences preferences;
    private Collection sessionsProperties;
    private Collection unsavedSessionsFileNames;
    public static final String UNTITLED_FILE_NAME = "sessions";

    public SCSessionsPropertiesManager(Preferences preferences) {
        this.preferences = preferences.node("classpath");
        this.read();
    }

    SCSessionsProperties addSessionsProperties(File file, String[] stringArray, int n) {
        SCSessionsProperties sCSessionsProperties = this.buildSessionsProperties(file, stringArray, n);
        sCSessionsProperties.manager = this;
        this.sessionsProperties.add(sCSessionsProperties);
        return sCSessionsProperties;
    }

    void addSessionsProperties(SCSessionsProperties sCSessionsProperties) {
        if (!this.sessionsProperties.contains((Object)sCSessionsProperties)) {
            this.sessionsProperties.add(sCSessionsProperties);
        }
    }

    private SCSessionsProperties buildSessionsProperties(File file, String[] stringArray, int n) {
        return new SCSessionsProperties(this, file, stringArray, n);
    }

    public SCSessionsProperties getSessionsProperties(File file) {
        Iterator iterator = this.sessionsProperties();
        while (iterator.hasNext()) {
            SCSessionsProperties sCSessionsProperties = (SCSessionsProperties)((Object)iterator.next());
            if (!sCSessionsProperties.getPath().equals(file)) continue;
            return sCSessionsProperties;
        }
        if (file.getPath().startsWith(this.untitledFileName())) {
            this.unsavedSessionsFileNames.add(file);
        }
        return this.buildSessionsProperties(file, new String[0], -1);
    }

    protected void initialize() {
        super.initialize();
        this.sessionsProperties = new Vector();
        this.unsavedSessionsFileNames = new Vector();
    }

    public File nextUntitledSessionsFile() {
        String string = this.untitledFileName();
        boolean bl = false;
        int n = 0;
        Object object = this.unsavedSessionsFileNames();
        while (object.hasNext()) {
            File file = (File)object.next();
            String string2 = FileTools.stripExtension((String)file.getPath());
            if (!string2.startsWith(string)) continue;
            String string3 = string2.substring(string.length(), string2.length());
            try {
                if (string3.length() == 0) {
                    bl = true;
                    ++n;
                    continue;
                }
                n = Math.max(new Integer(string3), n);
            }
            catch (Exception exception) {}
        }
        object = new StringBuffer(13);
        ((StringBuffer)object).append(string);
        if (bl) {
            ((StringBuffer)object).append(++n);
        }
        ((StringBuffer)object).append(".xml");
        return new File(((StringBuffer)object).toString());
    }

    public void pathChanged(SCSessionsProperties sCSessionsProperties) {
        SCSessionsProperties sCSessionsProperties2 = null;
        File file = sCSessionsProperties.getPath();
        Iterator iterator = this.sessionsProperties();
        while (iterator.hasNext()) {
            SCSessionsProperties sCSessionsProperties3 = (SCSessionsProperties)((Object)iterator.next());
            if (sCSessionsProperties == sCSessionsProperties3 || !sCSessionsProperties3.getPath().equals(file)) continue;
            sCSessionsProperties2 = sCSessionsProperties3;
            break;
        }
        if (sCSessionsProperties2 != null) {
            this.sessionsProperties.add(sCSessionsProperties);
            this.sessionsProperties.remove((Object)sCSessionsProperties2);
        }
    }

    private void read() {
        try {
            String[] stringArray = this.preferences.keys();
            for (int i = 0; i < stringArray.length; ++i) {
                Object object;
                String string = stringArray[i];
                if (string.startsWith("location_")) {
                    int n = string.indexOf("_");
                    int n2 = Integer.valueOf(string.substring(n + 1));
                    object = this.preferences.get(string, null);
                    String string2 = this.preferences.get("classpath_" + n2, null);
                    if (((String)object).length() <= 0 || StringTools.stringIsEmpty((String)string2)) continue;
                    String[] stringArray2 = string2.split(File.pathSeparator);
                    this.addSessionsProperties(new File((String)object), stringArray2, n2);
                    continue;
                }
                if (string.startsWith("classpath_")) continue;
                String string3 = this.preferences.get(string, null);
                if (string.length() <= 0 || StringTools.stringIsEmpty((String)string3)) continue;
                String[] stringArray3 = string3.split(File.pathSeparator);
                object = this.addSessionsProperties(new File(string), stringArray3, -1);
                ((SCSessionsProperties)((Object)object)).save(this.preferences.parent());
                this.preferences.remove(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Iterator sessionsProperties() {
        return this.sessionsProperties.iterator();
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        StringTools.buildSimpleToStringOn((Object)((Object)this), (StringBuffer)stringBuffer);
        stringBuffer.append(" (");
        this.toString(stringBuffer);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(", sessions=");
        stringBuffer.append(this.sessionsProperties);
    }

    private Iterator unsavedSessionsFileNames() {
        return this.unsavedSessionsFileNames.iterator();
    }

    private String untitledFileName() {
        return this.preferences.parent().get("new name.sessions configuration", UNTITLED_FILE_NAME);
    }
}

