/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui;

import java.io.File;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.scplugin.SCPlugin;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.meta.SCSessionsProperties;
import org.eclipse.persistence.tools.workbench.scplugin.ui.project.ProjectNode;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public class AddNewSessionsAction
extends AbstractFrameworkAction {
    private SCPlugin plugin;

    public AddNewSessionsAction(WorkbenchContext workbenchContext, SCPlugin sCPlugin) {
        super(workbenchContext);
        this.plugin = sCPlugin;
    }

    protected void initialize() {
        this.initializeText("NEW_SESSIONS_CONFIGURATION");
        this.initializeMnemonic("NEW_SESSIONS_CONFIGURATION");
        this.initializeIcon("NEW_SESSIONS_CONFIGURATION");
        this.initializeToolTipText("NEW_SESSIONS_CONFIGURATION.TOOL_TIP");
    }

    protected void execute() {
        this.navigatorSelectionModel().pushExpansionState();
        File file = this.plugin.nextUntitledFile(this.getApplicationContext());
        ApplicationNode applicationNode = this.buildTopLinkSessionsNode(file);
        this.nodeManager().addProjectNode(applicationNode);
        this.navigatorSelectionModel().setSelectedNode(applicationNode);
        this.navigatorSelectionModel().popAndRestoreExpansionState();
    }

    private ApplicationNode buildTopLinkSessionsNode(File file) {
        SCSessionsProperties sCSessionsProperties = this.plugin.getSessionsProperties(this.getApplicationContext(), file);
        TopLinkSessionsAdapter topLinkSessionsAdapter = this.buildTopLinkSessions(sCSessionsProperties);
        this.updateClasspath(topLinkSessionsAdapter);
        return new ProjectNode(topLinkSessionsAdapter, this.nodeManager().getRootNode(), this.plugin, this.getApplicationContext());
    }

    private TopLinkSessionsAdapter buildTopLinkSessions(SCSessionsProperties sCSessionsProperties) {
        return new TopLinkSessionsAdapter(sCSessionsProperties, this.preferences(), true);
    }

    private void updateClasspath(TopLinkSessionsAdapter topLinkSessionsAdapter) {
        String string = this.preferences().get("default classpath", null);
        if (string != null && !"".equals(string)) {
            Object[] objectArray = string.split(System.getProperty("path.separator"));
            topLinkSessionsAdapter.getClassRepository().addClasspathEntries(0, CollectionTools.list((Object[])objectArray));
        }
    }
}

