/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.broker;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.CheckList;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;

final class SessionsListDialog
extends AbstractDialog {
    private final CollectionValueModel itemHolder;
    private final CellRendererAdapter labelDecorator;
    private ObjectListSelectionModel selectionModel;

    SessionsListDialog(WorkbenchContext workbenchContext, CollectionValueModel collectionValueModel, ObjectListSelectionModel objectListSelectionModel, CellRendererAdapter cellRendererAdapter) {
        super(workbenchContext, workbenchContext.getApplicationContext().getResourceRepository().getString("SESSIONS_LIST_DIALOG_TITLE"));
        this.itemHolder = collectionValueModel;
        this.labelDecorator = cellRendererAdapter;
        this.selectionModel = objectListSelectionModel;
    }

    protected String helpTopicId() {
        return "dialog.sessions";
    }

    protected Component buildMainPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(this.resourceRepository().getString("SESSIONS_LIST_DIALOG_SESSIONS_LIST"));
        jLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("SESSIONS_LIST_DIALOG_SESSIONS_LIST"));
        jLabel.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("SESSIONS_LIST_DIALOG_SESSIONS_LIST"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        CheckList checkList = new CheckList(this.itemHolder, (ListSelectionModel)this.selectionModel, this.labelDecorator);
        this.installSelectionModelListener();
        Dimension dimension = checkList.getPreferredSize();
        dimension.width = Math.max(300, dimension.width);
        dimension.height = Math.max(100, dimension.height);
        checkList.setPreferredSize(dimension);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        jPanel.add((Component)checkList, gridBagConstraints);
        jLabel.setLabelFor(checkList);
        return jPanel;
    }

    private void installSelectionModelListener() {
        this.selectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                SessionsListDialog.this.getOKAction().setEnabled(SessionsListDialog.this.selectionModel.getSelectedValues().length > 0);
            }
        });
    }

    protected void prepareToShow() {
        super.prepareToShow();
        this.getOKAction().setEnabled(false);
    }
}

