/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.broker;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionBrokerAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.broker.SessionsListDialog;
import org.eclipse.persistence.tools.workbench.scplugin.ui.tools.AbstractSessionsListPane;
import org.eclipse.persistence.tools.workbench.scplugin.ui.tools.SessionCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;

final class SessionsListPane
extends AbstractSessionsListPane {
    SessionsListPane(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    protected void addNewSession() {
        CollectionValueModel collectionValueModel = this.buildUnmanagedSessionsCollectionHolder();
        ObjectListSelectionModel objectListSelectionModel = this.buildSelectionModel(collectionValueModel);
        SessionsListDialog sessionsListDialog = new SessionsListDialog(this.getWorkbenchContext(), collectionValueModel, objectListSelectionModel, this.buildLabelDecorator());
        sessionsListDialog.setVisible(true);
        if (sessionsListDialog.wasCanceled()) {
            return;
        }
        Iterator iterator = CollectionTools.iterator((Object[])objectListSelectionModel.getSelectedValues());
        while (iterator.hasNext()) {
            SessionBrokerAdapter sessionBrokerAdapter = (SessionBrokerAdapter)this.subject();
            SessionAdapter sessionAdapter = (SessionAdapter)iterator.next();
            sessionBrokerAdapter.manage(sessionAdapter.getName());
        }
    }

    private CellRendererAdapter buildLabelDecorator() {
        return new SessionCellRendererAdapter(this.resourceRepository());
    }

    private ObjectListSelectionModel buildSelectionModel(CollectionValueModel collectionValueModel) {
        ListModelAdapter listModelAdapter = new ListModelAdapter(collectionValueModel);
        return new ObjectListSelectionModel(listModelAdapter);
    }

    protected AddRemoveListPanel buildSessionListPane() {
        AddRemoveListPanel addRemoveListPanel = super.buildSessionListPane();
        this.registerListenerToUpdateAddButtonEnableState(addRemoveListPanel);
        return addRemoveListPanel;
    }

    protected CollectionValueModel buildSessionsCollectionHolder() {
        return new CollectionAspectAdapter(this.getSubjectHolder(), "sessions"){

            protected Iterator getValueFromSubject() {
                return ((SessionBrokerAdapter)this.subject).sessions();
            }

            protected int sizeFromSubject() {
                return ((SessionBrokerAdapter)this.subject).sessionsSize();
            }
        };
    }

    private CollectionValueModel buildUnmanagedSessionsCollectionHolder() {
        Iterator iterator = this.buildUnmanagedSessionsIterator();
        return new ReadOnlyCollectionValueModel(CollectionTools.collection((Iterator)iterator));
    }

    private Iterator buildUnmanagedSessionsIterator() {
        SessionBrokerAdapter sessionBrokerAdapter = (SessionBrokerAdapter)this.subject();
        TopLinkSessionsAdapter topLinkSessionsAdapter = (TopLinkSessionsAdapter)sessionBrokerAdapter.getParent();
        return topLinkSessionsAdapter.databaseSessions();
    }

    private void registerListenerToUpdateAddButtonEnableState(final AddRemoveListPanel addRemoveListPanel) {
        PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter(this.getSubjectHolder(), ""){

            protected Object getValueFromSubject() {
                SessionBrokerAdapter sessionBrokerAdapter = (SessionBrokerAdapter)this.subject;
                return sessionBrokerAdapter.getParent();
            }
        };
        CollectionAspectAdapter collectionAspectAdapter = new CollectionAspectAdapter(propertyAspectAdapter, "sessions"){

            protected Iterator getValueFromSubject() {
                TopLinkSessionsAdapter topLinkSessionsAdapter = (TopLinkSessionsAdapter)this.subject;
                return topLinkSessionsAdapter.databaseSessions();
            }
        };
        collectionAspectAdapter.addCollectionChangeListener("value", new CollectionChangeListener(){

            public void collectionChanged(CollectionChangeEvent collectionChangeEvent) {
                SessionsListPane.this.updateAddButtonEnableState(addRemoveListPanel);
            }

            public void itemsAdded(CollectionChangeEvent collectionChangeEvent) {
                SessionsListPane.this.updateAddButtonEnableState(addRemoveListPanel);
            }

            public void itemsRemoved(CollectionChangeEvent collectionChangeEvent) {
                SessionsListPane.this.updateAddButtonEnableState(addRemoveListPanel);
            }
        });
        this.updateAddButtonEnableState(addRemoveListPanel);
    }

    protected void removeSessions(Collection collection) {
        SessionBrokerAdapter sessionBrokerAdapter = (SessionBrokerAdapter)this.subject();
        sessionBrokerAdapter.unManage(collection);
    }

    private void updateAddButtonEnableState(AddRemoveListPanel addRemoveListPanel) {
        SessionBrokerAdapter sessionBrokerAdapter = (SessionBrokerAdapter)this.subject();
        if (sessionBrokerAdapter != null) {
            TopLinkSessionsAdapter topLinkSessionsAdapter = (TopLinkSessionsAdapter)sessionBrokerAdapter.getParent();
            boolean bl = topLinkSessionsAdapter.databaseSessionsSize() > 0;
            addRemoveListPanel.setAddButtonEnabled(bl);
        }
    }
}

