/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.pool;

import java.util.List;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.ui.view.EmptyPropertiesPage;
import org.eclipse.persistence.tools.workbench.scplugin.SCPlugin;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.SCApplicationNode;
import org.eclipse.persistence.tools.workbench.scplugin.ui.pool.DeletePoolAction;
import org.eclipse.persistence.tools.workbench.scplugin.ui.pool.EisPoolTabbedPropertiesPage;
import org.eclipse.persistence.tools.workbench.scplugin.ui.pool.EisReadPoolTabbedPropertiesPage;
import org.eclipse.persistence.tools.workbench.scplugin.ui.pool.PoolTabbedPropertiesPage;
import org.eclipse.persistence.tools.workbench.scplugin.ui.pool.RdbmsReadPoolTabbedPropertiesPage;
import org.eclipse.persistence.tools.workbench.scplugin.ui.pool.RenamePoolAction;
import org.eclipse.persistence.tools.workbench.scplugin.ui.pool.WritePoolTabbedPropertiesPage;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;

public class PoolNode
extends SCApplicationNode {
    public PoolNode(ConnectionPoolAdapter connectionPoolAdapter, TreeNodeValueModel treeNodeValueModel, SCPlugin sCPlugin, ApplicationContext applicationContext) {
        super(connectionPoolAdapter, treeNodeValueModel, sCPlugin, applicationContext);
    }

    protected List buildDisplayStringPropertyNamesList() {
        List list = super.buildDisplayStringPropertyNamesList();
        list.add("name");
        return list;
    }

    protected FrameworkAction buildDeleteNodeAction(WorkbenchContext workbenchContext) {
        return new DeletePoolAction(workbenchContext);
    }

    ConnectionPoolAdapter pool() {
        return (ConnectionPoolAdapter)this.getValue();
    }

    protected AbstractPropertiesPage buildPropertiesPage(WorkbenchContext workbenchContext) {
        AbstractPropertiesPage abstractPropertiesPage = null;
        if (this.pool().platformIsXml()) {
            abstractPropertiesPage = new EmptyPropertiesPage(workbenchContext);
        } else if (this.pool().platformIsRdbms()) {
            abstractPropertiesPage = this.buildRdbmsPropertiesPage(workbenchContext);
        } else if (this.pool().platformIsEis()) {
            abstractPropertiesPage = this.buildEisPropertiesPage(workbenchContext);
        }
        return abstractPropertiesPage;
    }

    private AbstractPropertiesPage buildRdbmsPropertiesPage(WorkbenchContext workbenchContext) {
        if (this.pool().isWriteConnectionPool()) {
            return new WritePoolTabbedPropertiesPage(workbenchContext);
        }
        if (this.pool().isReadConnectionPool()) {
            return new RdbmsReadPoolTabbedPropertiesPage(workbenchContext);
        }
        return new PoolTabbedPropertiesPage(workbenchContext);
    }

    private AbstractPropertiesPage buildEisPropertiesPage(WorkbenchContext workbenchContext) {
        if (this.pool().isWriteConnectionPool()) {
            return new WritePoolTabbedPropertiesPage(workbenchContext);
        }
        if (this.pool().isReadConnectionPool()) {
            return new EisReadPoolTabbedPropertiesPage(workbenchContext);
        }
        return new EisPoolTabbedPropertiesPage(workbenchContext);
    }

    private Object rdbmsPropertiesPageKey() {
        if (this.pool().isWriteConnectionPool()) {
            return WritePoolTabbedPropertiesPage.class;
        }
        if (this.pool().isReadConnectionPool()) {
            return RdbmsReadPoolTabbedPropertiesPage.class;
        }
        return PoolTabbedPropertiesPage.class;
    }

    private Object eisPropertiesPageKey() {
        if (this.pool().isWriteConnectionPool()) {
            return WritePoolTabbedPropertiesPage.class;
        }
        if (this.pool().isReadConnectionPool()) {
            return EisReadPoolTabbedPropertiesPage.class;
        }
        return EisPoolTabbedPropertiesPage.class;
    }

    protected Object propertiesPageKey() {
        if (this.pool().platformIsRdbms()) {
            return this.rdbmsPropertiesPageKey();
        }
        if (this.pool().platformIsEis()) {
            return this.eisPropertiesPageKey();
        }
        return EmptyPropertiesPage.class;
    }

    public String helpTopicID() {
        return "navigator.connectionPool";
    }

    protected String buildIconKey() {
        if (this.pool().isReadConnectionPool()) {
            return "CONNECTION_POOL_READ";
        }
        if (this.pool().isSequenceConnectionPool()) {
            return "CONNECTION_POOL_SEQUENCE";
        }
        if (this.pool().isWriteConnectionPool()) {
            return "CONNECTION_POOL_WRITE";
        }
        return "CONNECTION_POOL";
    }

    protected FrameworkAction buildRenameNodeAction(WorkbenchContext workbenchContext) {
        return new RenamePoolAction(workbenchContext);
    }
}

