/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.pool;

import java.util.Collection;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractEnablableFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.AbstractApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.project.RenameDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public class RenamePoolAction
extends AbstractEnablableFrameworkAction {
    public RenamePoolAction(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    protected void initialize() {
        super.initialize();
        this.initializeText("RENAME_POOL");
        this.initializeMnemonic("RENAME_POOL");
        this.initializeIcon("RENAME");
        this.initializeToolTipText("RENAME_POOL.TOOL_TIP");
    }

    protected void execute(ApplicationNode applicationNode) {
        ConnectionPoolAdapter connectionPoolAdapter = (ConnectionPoolAdapter)applicationNode.getValue();
        ServerSessionAdapter serverSessionAdapter = (ServerSessionAdapter)connectionPoolAdapter.getParent().getParent();
        SimplePropertyValueModel simplePropertyValueModel = new SimplePropertyValueModel();
        simplePropertyValueModel.setValue(connectionPoolAdapter.getName());
        Collection collection = CollectionTools.collection(serverSessionAdapter.poolNames());
        collection.add("ReadConnectionPool");
        RenameDialog renameDialog = new RenameDialog(this.getWorkbenchContext(), simplePropertyValueModel, collection);
        renameDialog.show();
        if (renameDialog.wasConfirmed()) {
            this.navigatorSelectionModel().pushExpansionState();
            connectionPoolAdapter.setName((String)simplePropertyValueModel.getValue());
            this.navigatorSelectionModel().popAndRestoreExpansionState();
            ((AbstractApplicationNode)applicationNode.getProjectRoot()).selectDescendantNodeForValue((Node)connectionPoolAdapter, this.navigatorSelectionModel());
        }
    }

    protected boolean shouldBeEnabled(ApplicationNode applicationNode) {
        ConnectionPoolAdapter connectionPoolAdapter = (ConnectionPoolAdapter)applicationNode.getValue();
        return !connectionPoolAdapter.isWriteConnectionPool() && !connectionPoolAdapter.isReadConnectionPool() && !connectionPoolAdapter.isSequenceConnectionPool();
    }
}

