/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.pool.basic;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingTools;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.LoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ReadConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerSessionAdapter;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.SwitcherPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.Transformer;

abstract class AbstractReadPoolLoginPropertiesPage
extends ScrollablePropertiesPage {
    private JComponent loginPane;

    AbstractReadPoolLoginPropertiesPage(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    private PropertyValueModel buildEnableStateHolder() {
        PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter(this.getSelectionHolder(), ""){

            protected Object getValueFromSubject() {
                ConnectionPoolAdapter connectionPoolAdapter = (ConnectionPoolAdapter)this.subject;
                return connectionPoolAdapter.getParent().getParent();
            }
        };
        PropertyAspectAdapter propertyAspectAdapter2 = new PropertyAspectAdapter(propertyAspectAdapter, "login"){

            protected Object getValueFromSubject() {
                ServerSessionAdapter serverSessionAdapter = (ServerSessionAdapter)this.subject;
                return serverSessionAdapter.getLogin();
            }
        };
        PropertyAspectAdapter propertyAspectAdapter3 = new PropertyAspectAdapter(propertyAspectAdapter2, "externalConnectionPooling"){

            protected Object getValueFromSubject() {
                LoginAdapter loginAdapter = (LoginAdapter)this.subject;
                DatabaseSessionAdapter databaseSessionAdapter = (DatabaseSessionAdapter)loginAdapter.getParent();
                return databaseSessionAdapter.usesExternalConnectionPooling();
            }
        };
        return new TransformationPropertyValueModel(propertyAspectAdapter3){

            protected Object transform(Object object) {
                return Boolean.FALSE.equals(object);
            }
        };
    }

    private ButtonModel buildExclusiveConnectionsCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildExclusiveConnectionsHolder());
    }

    private PropertyValueModel buildExclusiveConnectionsHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "exclusive"){

            protected Object getValueFromSubject() {
                ReadConnectionPoolAdapter readConnectionPoolAdapter = (ReadConnectionPoolAdapter)this.subject;
                return readConnectionPoolAdapter.isExclusive();
            }

            protected void setValueOnSubject(Object object) {
                ReadConnectionPoolAdapter readConnectionPoolAdapter = (ReadConnectionPoolAdapter)this.subject;
                readConnectionPoolAdapter.setExclusive((Boolean)object);
            }
        };
    }

    protected final PropertyValueModel buildLoginHolder() {
        String[] stringArray = new String[]{"loginConfig", "useNonTransactionalReadLogin"};
        return new PropertyAspectAdapter(this.getSelectionHolder(), stringArray){

            protected Object getValueFromSubject() {
                ReadConnectionPoolAdapter readConnectionPoolAdapter = (ReadConnectionPoolAdapter)this.subject;
                return readConnectionPoolAdapter.usesNonTransactionalReadLogin() ? readConnectionPoolAdapter.getLogin() : null;
            }
        };
    }

    protected abstract JComponent buildLoginPane();

    private Transformer buildLoginPaneTransformer() {
        return new Transformer(){

            public Object transform(Object object) {
                if (object != null && ((Boolean)object).booleanValue()) {
                    return AbstractReadPoolLoginPropertiesPage.this.loginPane;
                }
                return null;
            }
        };
    }

    protected final Component buildPage() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = SwingTools.checkBoxIconWidth();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JCheckBox jCheckBox = this.buildCheckBox("CONNECTION_READ_EXCLUSIVE_CONNECTIONS_CHECK_BOX", this.buildExclusiveConnectionsCheckBoxAdapter());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        this.helpManager().addTopicID(jCheckBox, "connectionPool.exclusiveTransactions");
        JCheckBox jCheckBox2 = this.buildCheckBox("CONNECTION_READ_USE_NON_TRANSACTIONAL_READ_LOGIN_CHECK_BOX", this.buildUseNonTransactionalReadLoginCheckBoxAdapter());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)jCheckBox2, gridBagConstraints);
        this.helpManager().addTopicID(jCheckBox2, "connectionPool.nonTransactional");
        this.loginPane = this.buildLoginPane();
        SwitcherPanel switcherPanel = new SwitcherPanel(this.buildUseNonTransactionalReadLoginHolder(), this.buildLoginPaneTransformer());
        this.loginPane.setName("CONNECTION_READ_LOGIN_PANE");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(0, n, 0, 0);
        jPanel.add((Component)switcherPanel, gridBagConstraints);
        this.helpManager().addTopicID(this.loginPane, "session.login.database.connection");
        this.installExclusiveConnectionsEnabler(jCheckBox);
        return jPanel;
    }

    private ButtonModel buildUseNonTransactionalReadLoginCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildUseNonTransactionalReadLoginHolder());
    }

    private PropertyValueModel buildUseNonTransactionalReadLoginHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "useNonTransactionalReadLogin"){

            protected Object getValueFromSubject() {
                ReadConnectionPoolAdapter readConnectionPoolAdapter = (ReadConnectionPoolAdapter)this.subject;
                return readConnectionPoolAdapter.usesNonTransactionalReadLogin();
            }

            protected void setValueOnSubject(Object object) {
                ReadConnectionPoolAdapter readConnectionPoolAdapter = (ReadConnectionPoolAdapter)this.subject;
                readConnectionPoolAdapter.setUseNonTransactionalReadLogin(Boolean.TRUE.equals(object));
            }
        };
    }

    private ComponentEnabler installExclusiveConnectionsEnabler(JComponent jComponent) {
        return new ComponentEnabler((ValueModel)this.buildEnableStateHolder(), jComponent);
    }
}

