/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.pool.basic;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.LoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerSessionAdapter;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.NumberSpinnerModelAdapter;

public final class ConnectionCountPane
extends AbstractSubjectPanel {
    public ConnectionCountPane(PropertyValueModel propertyValueModel, ApplicationContext applicationContext) {
        super((ValueModel)propertyValueModel, applicationContext);
    }

    private ComponentEnabler buildComponentEnabler() {
        return new ComponentEnabler((ValueModel)this.buildEnableStateHolder(), this.getComponents());
    }

    private PropertyValueModel buildEnableStateHolder() {
        PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter(this.getSubjectHolder(), ""){

            protected Object getValueFromSubject() {
                ConnectionPoolAdapter connectionPoolAdapter = (ConnectionPoolAdapter)this.subject;
                return connectionPoolAdapter.getParent().getParent();
            }
        };
        PropertyAspectAdapter propertyAspectAdapter2 = new PropertyAspectAdapter(propertyAspectAdapter, "login"){

            protected Object getValueFromSubject() {
                ServerSessionAdapter serverSessionAdapter = (ServerSessionAdapter)this.subject;
                return serverSessionAdapter.getLogin();
            }
        };
        PropertyAspectAdapter propertyAspectAdapter3 = new PropertyAspectAdapter(propertyAspectAdapter2, "externalConnectionPooling"){

            protected Object getValueFromSubject() {
                LoginAdapter loginAdapter = (LoginAdapter)this.subject;
                DatabaseSessionAdapter databaseSessionAdapter = (DatabaseSessionAdapter)loginAdapter.getParent();
                return databaseSessionAdapter.usesExternalConnectionPooling();
            }
        };
        return new TransformationPropertyValueModel(propertyAspectAdapter3){

            protected Object transform(Object object) {
                return Boolean.FALSE.equals(object);
            }
        };
    }

    private PropertyValueModel buildMaximumCountHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "maxConnections"){

            protected Object getValueFromSubject() {
                ConnectionPoolAdapter connectionPoolAdapter = (ConnectionPoolAdapter)this.subject;
                return new Integer(connectionPoolAdapter.getMaxConnections());
            }

            protected void setValueOnSubject(Object object) {
                ConnectionPoolAdapter connectionPoolAdapter = (ConnectionPoolAdapter)this.subject;
                connectionPoolAdapter.setMaxConnections((Integer)object);
            }
        };
    }

    private SpinnerNumberModel buildMaximumCountSpinnerAdapter() {
        return new NumberSpinnerModelAdapter(this.buildMaximumCountHolder(), 0, Integer.MAX_VALUE, 1);
    }

    private PropertyValueModel buildMinimumCountHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "minConnections"){

            protected Object getValueFromSubject() {
                ConnectionPoolAdapter connectionPoolAdapter = (ConnectionPoolAdapter)this.subject;
                return new Integer(connectionPoolAdapter.getMinConnections());
            }

            protected void setValueOnSubject(Object object) {
                ConnectionPoolAdapter connectionPoolAdapter = (ConnectionPoolAdapter)this.subject;
                connectionPoolAdapter.setMinConnections((Integer)object);
            }
        };
    }

    private SpinnerNumberModel buildMinimumCountSpinnerAdapter() {
        return new NumberSpinnerModelAdapter(this.buildMinimumCountHolder(), 0, Integer.MAX_VALUE, 1);
    }

    protected void initializeLayout() {
        this.setBorder(this.buildTitledBorder("CONNECTION_POOL_CONNECTION_COUNT_TITLE"));
        this.setName("CONNECTION_POOL_CONNECTION_COUNT_PANE");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = this.buildLabel("CONNECTION_POOL_MINIMUM_CONNECTIONS_SPINNER");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)jLabel, gridBagConstraints);
        JSpinner jSpinner = SwingComponentFactory.buildSpinnerNumber(this.buildMinimumCountSpinnerAdapter());
        jSpinner.setName("CONNECTION_POOL_MINIMUM_CONNECTIONS_SPINNER");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)jSpinner, gridBagConstraints);
        jLabel.setLabelFor(jSpinner);
        JLabel jLabel2 = this.buildLabel("CONNECTION_POOL_MAXIMUM_CONNECTIONS_SPINNER");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)jLabel2, gridBagConstraints);
        JSpinner jSpinner2 = SwingComponentFactory.buildSpinnerNumber(this.buildMaximumCountSpinnerAdapter());
        jSpinner2.setName("CONNECTION_POOL_MAXIMUM_CONNECTIONS_SPINNER");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)jSpinner2, gridBagConstraints);
        jLabel2.setLabelFor(jSpinner2);
        this.buildComponentEnabler();
    }
}

