/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.SortedSet;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.eclipse.persistence.tools.workbench.framework.context.PreferencesContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.GroupBox;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingTools;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.PlatformComponentFactory;
import org.eclipse.persistence.tools.workbench.scplugin.model.EisPlatformManager;
import org.eclipse.persistence.tools.workbench.scplugin.model.ServerPlatformManager;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.NullServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.BufferedPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimpleCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.adapters.PreferencePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.BidiStringConverter;

final class PlatformPreferencesPage
extends AbstractPanel {
    private String previousServerClassName;
    private JComboBox serverPlatformChooser;
    private BufferedPropertyValueModel serverPlatformHolder;
    private JComponent serverPlatformWidgets;
    private JCheckBox useServerPlatformCheckBox;

    PlatformPreferencesPage(PreferencesContext preferencesContext) {
        super((LayoutManager)new BorderLayout(), preferencesContext);
        this.intializeLayout();
        this.addHelpTopicId(this, "preferences.sessions.platform");
    }

    private void buildChooserComponentEnabler(JRadioButton jRadioButton, JComponent jComponent) {
        final SimplePropertyValueModel simplePropertyValueModel = new SimplePropertyValueModel(jRadioButton.isSelected());
        jRadioButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JRadioButton jRadioButton = (JRadioButton)itemEvent.getSource();
                Boolean bl = jRadioButton.isSelected();
                simplePropertyValueModel.setValue(bl);
            }
        });
        new ComponentEnabler((ValueModel)simplePropertyValueModel, Collections.singleton(jComponent));
    }

    private ListDataListener buildComboBoxListDataListener() {
        return new ListDataListener(){

            public void contentsChanged(ListDataEvent listDataEvent) {
                if (listDataEvent.getIndex0() == -1 && listDataEvent.getIndex1() == -1) {
                    String string = (String)PlatformPreferencesPage.this.serverPlatformChooser.getSelectedItem();
                    PlatformPreferencesPage.this.updateServerPlatformWidgets(string);
                }
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
            }
        };
    }

    private PropertyValueModel buildDatabaseTypeHolder() {
        return new BufferedPropertyValueModel(this.buildDatabaseTypeHolderImp(), this.getPreferencesContext().getBufferTrigger());
    }

    private PropertyValueModel buildDatabaseTypeHolderImp() {
        PreferencePropertyValueModel preferencePropertyValueModel = new PreferencePropertyValueModel(this.preferences(), "data source type", (Object)"relational");
        preferencePropertyValueModel.setConverter(new BidiStringConverter(){

            public Object convertToObject(String string) {
                return this.convertToString(string);
            }

            public String convertToString(Object object) {
                if ("relational".equals(object)) {
                    return "relational";
                }
                if ("eis".equals(object)) {
                    return "eis";
                }
                if ("xml".equals(object)) {
                    return "xml";
                }
                return object != null ? object.toString() : null;
            }
        });
        return preferencePropertyValueModel;
    }

    private JComponent buildDefaultDatabaseSourceTypePane() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        PropertyValueModel propertyValueModel = this.buildDatabaseTypeHolder();
        int n = SwingTools.checkBoxIconWidth();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(this.buildTitledBorder("PREFERENCES_DEFAULT_DATA_SOURCE_TYPE_GROUP_BOX"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        JRadioButton jRadioButton = this.buildRadioButton("RELATIONAL_RADIO_BUTTON", this.buildRelationalButtonModelAdapter(propertyValueModel));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jRadioButton, gridBagConstraints);
        JComponent jComponent = this.buildRelationalPlatformWidgets();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, n, 0, 0);
        jPanel.add((Component)jComponent, gridBagConstraints);
        this.buildChooserComponentEnabler(jRadioButton, jComponent);
        JRadioButton jRadioButton2 = this.buildRadioButton("EIS_RADIO_BUTTON", this.buildEisButtonModelAdapter(propertyValueModel));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)jRadioButton2, gridBagConstraints);
        JComponent jComponent2 = this.buildEisPlatformWidgets();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, n, 0, 0);
        jPanel.add((Component)jComponent2, gridBagConstraints);
        this.buildChooserComponentEnabler(jRadioButton2, jComponent2);
        JRadioButton jRadioButton3 = this.buildRadioButton("XML_RADIO_BUTTON", this.buildXmlButtonModelAdapter(propertyValueModel));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)jRadioButton3, gridBagConstraints);
        return jPanel;
    }

    private JPanel buildDefaultServerPlatformPane() {
        this.useServerPlatformCheckBox = this.buildCheckBox("USE_SERVER_PLATFORM_CHECK_BOX", new DefaultButtonModel());
        this.useServerPlatformCheckBox.addActionListener(this.buildServerPlatformAction());
        this.serverPlatformChooser = new JComboBox(this.buildServerPlatformComboBoxModel());
        this.serverPlatformChooser.setRenderer(this.buildServerPlatformRenderer());
        this.serverPlatformChooser.getModel().addListDataListener(this.buildComboBoxListDataListener());
        this.serverPlatformWidgets = this.buildLabeledComponent("PREFERENCES_DEFAULT_SERVER_PLATFORM_COMBO_BOX", this.serverPlatformChooser);
        this.serverPlatformWidgets.setBorder(BorderFactory.createEmptyBorder(0, SwingTools.checkBoxIconWidth(), 0, 0));
        String string = (String)this.serverPlatformChooser.getSelectedItem();
        this.updateServerPlatformWidgets(string);
        return new GroupBox(this.useServerPlatformCheckBox, this.serverPlatformWidgets);
    }

    private ButtonModel buildEisButtonModelAdapter(PropertyValueModel propertyValueModel) {
        return new RadioButtonModelAdapter(propertyValueModel, "eis");
    }

    private ListCellRenderer buildEisNameRenderer() {
        return new SimpleListCellRenderer(){

            protected String buildText(Object object) {
                if (((String)object).equals("AQPlatform")) {
                    return "Oracle AQ";
                }
                if (((String)object).equals("JMSPlatform")) {
                    return "JMS";
                }
                if (((String)object).equals("MQPlatform")) {
                    return "IBM MQSeries";
                }
                return "XML File";
            }
        };
    }

    private ComboBoxModel buildEisPlatformCollectionHolder() {
        SortedSet sortedSet = CollectionTools.sortedSet((Iterator)EisPlatformManager.instance().platformShortNames());
        return new ComboBoxModelAdapter(new SimpleCollectionValueModel(sortedSet), this.buildEisPlatformHolder());
    }

    private PropertyValueModel buildEisPlatformHolder() {
        return new BufferedPropertyValueModel(this.buildEisPlatformHolderImp(), this.getPreferencesContext().getBufferTrigger());
    }

    private PropertyValueModel buildEisPlatformHolderImp() {
        PreferencePropertyValueModel preferencePropertyValueModel = new PreferencePropertyValueModel(this.preferences(), "platform.eis", (Object)"AQPlatform");
        preferencePropertyValueModel.setConverter(BidiStringConverter.DEFAULT_INSTANCE);
        return preferencePropertyValueModel;
    }

    private JComponent buildEisPlatformWidgets() {
        JComboBox jComboBox = new JComboBox(this.buildEisPlatformCollectionHolder());
        jComboBox.setRenderer(this.buildEisNameRenderer());
        return this.buildLabeledComponent("EIS_PLATFORM_LABEL", jComboBox);
    }

    private ButtonModel buildRelationalButtonModelAdapter(PropertyValueModel propertyValueModel) {
        return new RadioButtonModelAdapter(propertyValueModel, "relational");
    }

    private PropertyValueModel buildRelationalPlatformHolder() {
        return new BufferedPropertyValueModel(this.buildRelationalPlatformHolderImp(), this.getPreferencesContext().getBufferTrigger());
    }

    private PropertyValueModel buildRelationalPlatformHolderImp() {
        PreferencePropertyValueModel preferencePropertyValueModel = new PreferencePropertyValueModel(this.preferences(), "platform.database", (Object)DatabasePlatformRepository.getDefault().platformNamed("Oracle11"));
        preferencePropertyValueModel.setConverter(new BidiStringConverter(){

            public Object convertToObject(String string) {
                if (string == null) {
                    return null;
                }
                return DatabasePlatformRepository.getDefault().platformNamed(string);
            }

            public String convertToString(Object object) {
                if (object == null) {
                    return null;
                }
                DatabasePlatform databasePlatform = (DatabasePlatform)object;
                return databasePlatform.getName();
            }
        });
        return preferencePropertyValueModel;
    }

    private JComponent buildRelationalPlatformWidgets() {
        PropertyValueModel propertyValueModel = this.buildRelationalPlatformHolder();
        JComboBox jComboBox = PlatformComponentFactory.buildPlatformChooser(propertyValueModel);
        return this.buildLabeledComponent("DATABASE_PLATFORM_LABEL", jComboBox);
    }

    private ActionListener buildServerPlatformAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
                if (bl) {
                    PlatformPreferencesPage.this.previousServerClassName = (String)PlatformPreferencesPage.this.serverPlatformHolder.getValue();
                    string = NullServerPlatformAdapter.instance().getServerClassName();
                    string = ClassTools.shortNameForClassNamed((String)string);
                } else {
                    if (PlatformPreferencesPage.this.previousServerClassName == null) {
                        PlatformPreferencesPage.this.previousServerClassName = "WebLogic_10_Platform";
                    }
                    string = PlatformPreferencesPage.this.previousServerClassName;
                }
                PlatformPreferencesPage.this.serverPlatformHolder.setValue(string);
            }
        };
    }

    private CollectionValueModel buildServerPlatformCollectionHolder() {
        return new SimpleCollectionValueModel(this.buildServerPlatformNames());
    }

    private ComboBoxModel buildServerPlatformComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildServerPlatformCollectionHolder(), this.buildServerPlatformSelectionHolder());
    }

    private Collection buildServerPlatformNames() {
        SortedSet sortedSet = CollectionTools.sortedSet((Iterator)ServerPlatformManager.instance().platformShortNames());
        String string = NullServerPlatformAdapter.instance().getServerClassName();
        sortedSet.remove(ClassTools.shortNameForClassNamed((String)string));
        return sortedSet;
    }

    private ListCellRenderer buildServerPlatformRenderer() {
        return new SimpleListCellRenderer(){

            protected String buildText(Object object) {
                if (object == null) {
                    return "";
                }
                return PlatformPreferencesPage.this.resourceRepository().getString((String)object);
            }
        };
    }

    private PropertyValueModel buildServerPlatformSelectionHolder() {
        if (this.serverPlatformHolder == null) {
            this.serverPlatformHolder = new BufferedPropertyValueModel(this.buildServerPlatformSelectionHolderImp(), this.getPreferencesContext().getBufferTrigger());
        }
        return this.serverPlatformHolder;
    }

    private PropertyValueModel buildServerPlatformSelectionHolderImp() {
        PreferencePropertyValueModel preferencePropertyValueModel = new PreferencePropertyValueModel(this.preferences(), "platform.server");
        preferencePropertyValueModel.setConverter(BidiStringConverter.DEFAULT_INSTANCE);
        return preferencePropertyValueModel;
    }

    private ButtonModel buildXmlButtonModelAdapter(PropertyValueModel propertyValueModel) {
        return new RadioButtonModelAdapter(propertyValueModel, "xml");
    }

    private void intializeLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setBorder(null);
        jScrollPane.setViewportBorder(null);
        this.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = this.buildDefaultServerPlatformPane();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JComponent jComponent = this.buildDefaultDatabaseSourceTypePane();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)jComponent, gridBagConstraints);
    }

    private void updateServerPlatformWidgets(String string) {
        boolean bl;
        boolean bl2 = bl = string != null;
        if (bl) {
            ServerPlatformAdapter serverPlatformAdapter = NullServerPlatformAdapter.instance();
            String string2 = ClassTools.shortNameForClassNamed((String)serverPlatformAdapter.getServerClassName());
            bl = !string.equals(string2);
        }
        this.useServerPlatformCheckBox.setSelected(bl);
        this.serverPlatformWidgets.setEnabled(bl);
    }
}

