/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.project;

import java.util.Vector;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractEnablableFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;

public class DeleteSessionAction
extends AbstractEnablableFrameworkAction {
    public DeleteSessionAction(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    protected void initialize() {
        super.initialize();
        this.initializeText("DELETE_SESSION");
        this.initializeMnemonic("DELETE_SESSION");
        this.initializeToolTipText("DELETE_SESSION.TOOL_TIP");
        this.initializeIcon("DELETE");
    }

    protected void execute(ApplicationNode applicationNode) {
        SessionAdapter sessionAdapter = (SessionAdapter)applicationNode.getValue();
        TopLinkSessionsAdapter topLinkSessionsAdapter = (TopLinkSessionsAdapter)sessionAdapter.getParent();
        if (!this.canRemoveSessions(topLinkSessionsAdapter, sessionAdapter)) {
            return;
        }
        if (sessionAdapter.isManaged()) {
            DatabaseSessionAdapter databaseSessionAdapter = (DatabaseSessionAdapter)sessionAdapter;
            databaseSessionAdapter.getBroker().unManage(sessionAdapter.getName());
        } else {
            topLinkSessionsAdapter.removeSession(sessionAdapter);
        }
        this.navigatorSelectionModel().setSelectedNode((ApplicationNode)applicationNode.getParent());
    }

    protected boolean canRemoveSessions(TopLinkSessionsAdapter topLinkSessionsAdapter, SessionAdapter sessionAdapter) {
        if (sessionAdapter.isManaged()) {
            return true;
        }
        String string = topLinkSessionsAdapter.getName();
        int n = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("PROJECT_SESSIONS_PROMPT_REMOVE_MULTI", string), this.resourceRepository().getString("PROJECT_SESSIONS_PROMPT_REMOVE_MULTI_TITLE"), 0);
        return n == 0;
    }

    public void execute() {
        super.execute();
    }

    protected void updateEnabledState() {
        ApplicationNode[] applicationNodeArray = this.selectedNodes();
        Vector<SessionAdapter> vector = new Vector<SessionAdapter>();
        if (applicationNodeArray.length > 0) {
            for (int i = 0; i < applicationNodeArray.length; ++i) {
                ApplicationNode applicationNode = applicationNodeArray[i];
                SessionAdapter sessionAdapter = (SessionAdapter)applicationNode.getValue();
                if (!sessionAdapter.isManaged()) continue;
                vector.add(sessionAdapter);
            }
        }
        if (vector.size() > 0 && applicationNodeArray.length == vector.size()) {
            this.initializeText("UNMANAGED_SESSION");
            this.initializeMnemonic("UNMANAGED_SESSION");
            this.initializeToolTipText("UNMANAGED_SESSION.TOOL_TIP");
            this.initializeIcon("REMOVE");
        } else {
            this.initializeText("DELETE_SESSION");
            this.initializeMnemonic("DELETE_SESSION");
            this.initializeToolTipText("DELETE_SESSION.TOOL_TIP");
            this.initializeIcon("DELETE");
        }
    }

    protected boolean shouldBeEnabled(ApplicationNode applicationNode) {
        throw new UnsupportedOperationException();
    }
}

