/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.project;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.AbstractApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.GroupContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.RootMenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarButtonGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarDescription;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPropertiesPage;
import org.eclipse.persistence.tools.workbench.scplugin.SCPlugin;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionBrokerAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.broker.SessionBrokerNode;
import org.eclipse.persistence.tools.workbench.scplugin.ui.project.AddNewBrokerAction;
import org.eclipse.persistence.tools.workbench.scplugin.ui.project.AddNewSessionAction;
import org.eclipse.persistence.tools.workbench.scplugin.ui.project.ProjectPropertiesPage;
import org.eclipse.persistence.tools.workbench.scplugin.ui.project.SessionsNode;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class ProjectNode
extends SessionsNode {
    private boolean firstTimeReadOnlyFlagWasDetected;

    public ProjectNode(TopLinkSessionsAdapter topLinkSessionsAdapter, TreeNodeValueModel treeNodeValueModel, SCPlugin sCPlugin, ApplicationContext applicationContext) {
        super(topLinkSessionsAdapter, treeNodeValueModel, sCPlugin, applicationContext);
        this.firstTimeReadOnlyFlagWasDetected = topLinkSessionsAdapter.getPath().canWrite();
    }

    protected AbstractApplicationNode buildChildNode(SessionAdapter sessionAdapter) {
        AbstractApplicationNode abstractApplicationNode = null;
        try {
            abstractApplicationNode = super.buildChildNode(sessionAdapter);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (sessionAdapter instanceof SessionBrokerAdapter) {
                abstractApplicationNode = new SessionBrokerNode((SessionBrokerAdapter)sessionAdapter, (TreeNodeValueModel)this, (SCPlugin)this.getPlugin(), this.getApplicationContext());
            }
            throw new IllegalArgumentException("Invalid Session");
        }
        return abstractApplicationNode;
    }

    protected CollectionValueModel buildSessionsAspectAdapter() {
        return new CollectionAspectAdapter(this, "sessions"){

            protected Iterator getValueFromSubject() {
                return ((TopLinkSessionsAdapter)this.subject).sessions();
            }

            protected int sizeFromSubject() {
                return ((TopLinkSessionsAdapter)this.subject).sessionsSize();
            }
        };
    }

    protected AbstractPropertiesPage buildPropertiesPage(WorkbenchContext workbenchContext) {
        return new ProjectPropertiesPage(workbenchContext);
    }

    protected Object propertiesPageKey() {
        return ProjectPropertiesPage.class;
    }

    protected String buildIconKey() {
        return "SESSIONS_CONFIGURATION";
    }

    protected FrameworkAction buildRenameNodeAction(WorkbenchContext workbenchContext) {
        return null;
    }

    protected String buildDisplayString() {
        String string = super.buildDisplayString();
        File file = this.topLinkSessions().getPath();
        if (file.exists() && !file.canWrite()) {
            string = this.resourceRepository().getString("PROJECT_NODE_DISPLAY_STRING_READ_ONLY", string);
        }
        return string;
    }

    protected List buildDisplayStringPropertyNamesList() {
        List list = super.buildDisplayStringPropertyNamesList();
        list.add("name");
        return list;
    }

    private FrameworkAction getAddSessionAction(WorkbenchContext workbenchContext) {
        return new AddNewSessionAction(workbenchContext);
    }

    private FrameworkAction getAddBrokerAction(WorkbenchContext workbenchContext) {
        return new AddNewBrokerAction(workbenchContext);
    }

    public GroupContainerDescription buildMenuDescription(WorkbenchContext workbenchContext) {
        WorkbenchContext workbenchContext2 = this.buildLocalWorkbenchContext(workbenchContext);
        RootMenuDescription rootMenuDescription = new RootMenuDescription();
        MenuGroupDescription menuGroupDescription = new MenuGroupDescription();
        menuGroupDescription.add(this.getAddSessionAction(workbenchContext2));
        menuGroupDescription.add(this.getAddBrokerAction(workbenchContext2));
        MenuDescription menuDescription = new MenuDescription(this.resourceRepository().getString("NEW_MENU"), this.resourceRepository().getString("NEW_MENU"), this.resourceRepository().getMnemonic("NEW_MENU"), EMPTY_ICON);
        menuDescription.add(menuGroupDescription);
        MenuGroupDescription menuGroupDescription2 = new MenuGroupDescription();
        menuGroupDescription2.add(menuDescription);
        rootMenuDescription.add(menuGroupDescription2);
        MenuGroupDescription menuGroupDescription3 = new MenuGroupDescription();
        menuGroupDescription3.add(this.getCloseAction(workbenchContext));
        rootMenuDescription.add(menuGroupDescription3);
        MenuGroupDescription menuGroupDescription4 = new MenuGroupDescription();
        menuGroupDescription4.add(this.getSaveAction(workbenchContext));
        menuGroupDescription4.add(this.getSaveAsAction(workbenchContext));
        rootMenuDescription.add(menuGroupDescription4);
        rootMenuDescription.add(this.buildHelpMenuGroup(workbenchContext2));
        return rootMenuDescription;
    }

    public GroupContainerDescription buildToolBarDescription(WorkbenchContext workbenchContext) {
        WorkbenchContext workbenchContext2 = this.buildLocalWorkbenchContext(workbenchContext);
        ToolBarDescription toolBarDescription = new ToolBarDescription();
        ToolBarButtonGroupDescription toolBarButtonGroupDescription = new ToolBarButtonGroupDescription();
        toolBarButtonGroupDescription.add(this.getAddSessionAction(workbenchContext2));
        toolBarButtonGroupDescription.add(this.getAddBrokerAction(workbenchContext2));
        toolBarDescription.add(toolBarButtonGroupDescription);
        return toolBarDescription;
    }

    protected FrameworkAction getCloseAction(WorkbenchContext workbenchContext) {
        return workbenchContext.getActionRepository().getCloseAction();
    }

    protected FrameworkAction buildDeleteNodeAction(WorkbenchContext workbenchContext) {
        return null;
    }

    protected FrameworkAction getSaveAction(WorkbenchContext workbenchContext) {
        return workbenchContext.getActionRepository().getSaveAction();
    }

    protected FrameworkAction getSaveAsAction(WorkbenchContext workbenchContext) {
        return workbenchContext.getActionRepository().getSaveAsAction();
    }

    TopLinkSessionsAdapter topLinkSessions() {
        return (TopLinkSessionsAdapter)this.getValue();
    }

    public String helpTopicID() {
        return "navigator.scproject";
    }

    public boolean save(File file, WorkbenchContext workbenchContext) {
        TopLinkSessionsAdapter topLinkSessionsAdapter = this.topLinkSessions();
        File file2 = topLinkSessionsAdapter.getPath();
        boolean bl = false;
        if (file2.getPath().startsWith("sessions")) {
            bl = this.saveAs(file, workbenchContext);
        } else if (!file2.canWrite()) {
            if (this.firstTimeReadOnlyFlagWasDetected) {
                this.showErrorReadOnlyMessage(workbenchContext);
                this.firstTimeReadOnlyFlagWasDetected = false;
                if (this.canRetryToSave(workbenchContext) && (bl = this.saveAs(file, workbenchContext))) {
                    this.displayStringChanged();
                }
            } else {
                bl = this.saveAs(file, workbenchContext);
            }
        } else {
            bl = this.saveImp(file2, workbenchContext);
            this.firstTimeReadOnlyFlagWasDetected = false;
            if (bl) {
                this.displayStringChanged();
            }
        }
        return bl;
    }

    private boolean canRetryToSave(WorkbenchContext workbenchContext) {
        return 0 == JOptionPane.showConfirmDialog(workbenchContext.getCurrentWindow(), this.resourceRepository().getString("SAVE_RETRY_TO_SAVE_MESSAGE"), workbenchContext.getApplicationContext().getApplication().getShortProductName(), 0);
    }

    private boolean saveImp(File file, WorkbenchContext workbenchContext) {
        TopLinkSessionsAdapter topLinkSessionsAdapter = this.topLinkSessions();
        try {
            topLinkSessionsAdapter.getProperties().saveAs(this.preferences(), file);
            topLinkSessionsAdapter.save(file);
            return true;
        }
        catch (Throwable throwable) {
            this.showErrorMessage(throwable, workbenchContext);
            return false;
        }
    }

    public boolean saveAs(File file, WorkbenchContext workbenchContext) {
        File file2 = this.topLinkSessions().getPath();
        File file3 = file2.getParentFile();
        if (file3 == null) {
            file3 = file;
        }
        FileChooserDialog fileChooserDialog = new FileChooserDialog(workbenchContext);
        fileChooserDialog.setDialogTitle(this.resourceRepository().getString("SAVE_AS_DIALOG_TITLE"));
        fileChooserDialog.setCurrentDirectory(file3);
        fileChooserDialog.setSelectedFile(file2);
        fileChooserDialog.setMultiSelectionEnabled(false);
        int n = fileChooserDialog.showSaveDialog(workbenchContext.getCurrentWindow());
        if (n != 0) {
            return false;
        }
        workbenchContext.getNavigatorSelectionModel().pushExpansionState();
        boolean bl = this.saveImp(fileChooserDialog.getSelectedFile(), workbenchContext);
        workbenchContext.getNavigatorSelectionModel().popAndRestoreExpansionState();
        return bl;
    }

    public File saveFile() {
        File file = this.topLinkSessions().getPath();
        return file.exists() ? file : null;
    }

    private void showErrorReadOnlyMessage(WorkbenchContext workbenchContext) {
        String string = FileTools.canonicalFile((File)this.topLinkSessions().getPath()).getPath();
        String string2 = this.resourceRepository().getString("SAVE_READ_ONLY_ERROR_MESSAGE", workbenchContext.getApplicationContext().getApplication().getShortProductName(), string, StringTools.CR);
        LabelArea labelArea = new LabelArea(string2);
        JOptionPane.showMessageDialog(workbenchContext.getCurrentWindow(), labelArea, workbenchContext.getApplicationContext().getApplication().getShortProductName(), 2);
    }

    private void showErrorMessage(Throwable throwable, WorkbenchContext workbenchContext) {
        ((SCPlugin)this.getPlugin()).showWarning(workbenchContext, this.resourceRepository().getString("SAVE_ERROR_MESSAGE", this.topLinkSessions().getPath().getPath()), throwable);
    }

    private class FileChooserDialog
    extends JFileChooser {
        private WorkbenchContext workbenchContext;

        private FileChooserDialog(WorkbenchContext workbenchContext) {
            this.workbenchContext = workbenchContext;
        }

        public void approveSelection() {
            int n = this.canReplaceExistingFile();
            if (n == 0) {
                super.approveSelection();
            } else if (n == 2) {
                this.cancelSelection();
            }
        }

        private int canReplaceExistingFile() {
            File file = this.getSelectedFile();
            String string = this.workbenchContext.getApplicationContext().getApplication().getShortProductName();
            if (this.isDocumentOpened(file)) {
                String string2 = ProjectNode.this.resourceRepository().getString("SAVE_AS_DIALOG_ALREADY_OPENED", string, file, StringTools.CR);
                LabelArea labelArea = new LabelArea(string2);
                labelArea.setPreferredWidth(800);
                JOptionPane.showMessageDialog(this.workbenchContext.getCurrentWindow(), labelArea, string, 2);
                return 1;
            }
            if (file.exists() && !file.canWrite()) {
                String string3 = ProjectNode.this.resourceRepository().getString("SAVE_AS_DIALOG_CANT_SAVE", file);
                LabelArea labelArea = new LabelArea(string3);
                labelArea.setPreferredWidth(800);
                JOptionPane.showMessageDialog(this.workbenchContext.getCurrentWindow(), labelArea, string, 2);
                return 1;
            }
            if (file.exists() && !ProjectNode.this.topLinkSessions().getPath().equals(file)) {
                String string4 = ProjectNode.this.resourceRepository().getString("SAVE_AS_DIALOG_REPLACE", this.getSelectedFile().getPath());
                LabelArea labelArea = new LabelArea(string4);
                labelArea.setPreferredWidth(800);
                return JOptionPane.showConfirmDialog(this.workbenchContext.getCurrentWindow(), labelArea, string, 1);
            }
            return 0;
        }

        private boolean isDocumentOpened(File file) {
            ApplicationNode[] applicationNodeArray = ProjectNode.this.nodeManager().projectNodesFor(ProjectNode.this.getPlugin());
            for (int i = 0; i < applicationNodeArray.length; ++i) {
                File file2;
                ProjectNode projectNode = (ProjectNode)applicationNodeArray[i];
                if (projectNode == ProjectNode.this || !file.equals(file2 = projectNode.topLinkSessions().getPath())) continue;
                return true;
            }
            return false;
        }
    }
}

