/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.GridLayout;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ProjectAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ProjectXMLAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.AbstractCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;

abstract class AbstractSessionMultipleProjectsPane
extends AbstractSubjectPanel {
    private ObjectListSelectionModel selectionModel;

    AbstractSessionMultipleProjectsPane(ValueModel valueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(valueModel, workbenchContextHolder);
    }

    protected abstract void addProject(ObjectListSelectionModel var1);

    private ActionListener buildAddAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractSessionMultipleProjectsPane.this.addProject(AbstractSessionMultipleProjectsPane.this.selectionModel);
            }
        };
    }

    private CollectionValueModel buildAddionalProjectsCollectionHolder() {
        return new CollectionAspectAdapter(this.getSubjectHolder(), "additionalProjects"){

            protected Iterator getValueFromSubject() {
                DatabaseSessionAdapter databaseSessionAdapter = (DatabaseSessionAdapter)this.subject;
                return databaseSessionAdapter.additionalProjects();
            }
        };
    }

    private ListModel buildAddionalProjectsListAdapter() {
        return new ListModelAdapter(new SortedListValueModelAdapter(this.buildAddionalProjectsCollectionHolder()));
    }

    private ListCellRenderer buildAddiontalProjectsCellRenderer() {
        return new AdaptableListCellRenderer(new CellRendererAdapter());
    }

    private ActionListener buildRemoveAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = AbstractSessionMultipleProjectsPane.this.selectionModel.getSelectedValues();
                DatabaseSessionAdapter databaseSessionAdapter = (DatabaseSessionAdapter)AbstractSessionMultipleProjectsPane.this.subject();
                for (int i = 0; i < objectArray.length; ++i) {
                    databaseSessionAdapter.removeProject((ProjectAdapter)((Object)objectArray[i]));
                }
            }
        };
    }

    private void buildRemoveButtonEnabler(final JButton jButton) {
        this.selectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                jButton.setEnabled(AbstractSessionMultipleProjectsPane.this.selectionModel.getSelectedValues().length > 0);
            }
        });
    }

    protected void initializeLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = this.buildLabel("SESSION_MULTIPLE_PROJECTS_LIST");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jLabel, gridBagConstraints);
        JList jList = SwingComponentFactory.buildList(this.buildAddionalProjectsListAdapter());
        jList.setCellRenderer(this.buildAddiontalProjectsCellRenderer());
        this.selectionModel = new ObjectListSelectionModel(jList.getModel());
        jList.setSelectionModel(this.selectionModel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.add((Component)new JScrollPane(jList), gridBagConstraints);
        jLabel.setLabelFor(jList);
        JPanel jPanel = new JPanel(new GridLayout(2, 1, 0, 5));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(1, 5, 0, 0);
        this.add((Component)jPanel, gridBagConstraints);
        JButton jButton = this.buildButton("SESSION_MULTIPLE_PROJECTS_ADD_BUTTON");
        jButton.addActionListener(this.buildAddAction());
        jPanel.add(jButton);
        JButton jButton2 = this.buildButton("SESSION_MULTIPLE_PROJECTS_REMOVE_BUTTON");
        jButton2.setEnabled(false);
        jButton2.addActionListener(this.buildRemoveAction());
        this.buildRemoveButtonEnabler(jButton2);
        jPanel.add(jButton2);
    }

    private class CellRendererAdapter
    extends AbstractCellRendererAdapter {
        private CellRendererAdapter() {
        }

        public Icon buildFileIcon(String string) {
            File file = new File(string);
            return AbstractSessionMultipleProjectsPane.this.resourceRepository().getIcon(file.exists() ? (file.isDirectory() ? "folder" : "file") : "file");
        }

        public Icon buildIcon(Object object) {
            if (object instanceof ProjectXMLAdapter) {
                return this.buildFileIcon(((ProjectXMLAdapter)((Object)object)).getName());
            }
            return AbstractSessionMultipleProjectsPane.this.resourceRepository().getIcon("class.public");
        }

        public String buildText(Object object) {
            String string = ((ProjectAdapter)((Object)object)).getName();
            return string.replace('/', File.separatorChar);
        }
    }
}

