/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.FileChooserPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.GroupBox;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DefaultSessionLogAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.JavaLogAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.LogAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.NoLogAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerLogAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic.LoggingOptionsPane;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimpleListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;
import org.eclipse.persistence.tools.workbench.utility.node.AbstractNodeModel;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class SessionLoggingPropertiesPage
extends ScrollablePropertiesPage {
    private PseudoLogginOptionsModel pseudoModel;
    private static final Object LOGGING_TYPE_JAVA_CHOICE = JavaLogAdapter.class;
    private static final Object LOGGING_TYPE_NO_LOGGING_CHOICE = NoLogAdapter.class;
    private static final Object LOGGING_TYPE_SERVER_CHOICE = ServerLogAdapter.class;
    private static final Object LOGGING_TYPE_STANDARD_CHOICE = DefaultSessionLogAdapter.class;

    public SessionLoggingPropertiesPage(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    private PropertyValueModel buildLogAdapterHolder() {
        return new PropertyAspectAdapter("logOptions", (Model)this.pseudoModel){

            protected Object getValueFromSubject() {
                PseudoLogginOptionsModel pseudoLogginOptionsModel = (PseudoLogginOptionsModel)((Object)this.subject);
                return pseudoLogginOptionsModel.getLogOptions();
            }
        };
    }

    private PropertyValueModel buildLoggingOptionsCheckBoxEnablerHolder() {
        return new TransformationPropertyValueModel(this.buildLoggingTypeSelectionHolder()){

            protected Object transform(Object object) {
                if (object == null) {
                    return null;
                }
                return object == LOGGING_TYPE_STANDARD_CHOICE || object == LOGGING_TYPE_JAVA_CHOICE;
            }
        };
    }

    private PropertyValueModel buildLoggingOptionsPaneEnablerHolder() {
        return new TransformationPropertyValueModel(this.buildLogAdapterHolder()){

            protected Object transform(Object object) {
                return object != null;
            }
        };
    }

    private PropertyValueModel buildLoggingTypeHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "log"){

            protected Object getValueFromSubject() {
                SessionAdapter sessionAdapter = (SessionAdapter)this.subject;
                return sessionAdapter.getLog();
            }

            protected void setValueOnSubject(Object object) {
                SessionAdapter sessionAdapter = (SessionAdapter)this.subject;
                LogAdapter logAdapter = sessionAdapter.getLog();
                if (object == LOGGING_TYPE_JAVA_CHOICE && !(logAdapter instanceof JavaLogAdapter)) {
                    sessionAdapter.setJavaLogging();
                } else if (object == LOGGING_TYPE_SERVER_CHOICE && !(logAdapter instanceof ServerLogAdapter)) {
                    sessionAdapter.setServerLogging();
                } else if (object == LOGGING_TYPE_STANDARD_CHOICE && !(logAdapter instanceof DefaultSessionLogAdapter)) {
                    sessionAdapter.setDefaultLogging();
                }
            }
        };
    }

    private PropertyValueModel buildLoggingTypeSelectionHolder() {
        return new TransformationPropertyValueModel(this.buildLoggingTypeHolder()){

            protected Object transform(Object object) {
                return object != null ? object.getClass() : null;
            }
        };
    }

    private PropertyValueModel buildLogHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "log"){

            protected Object getValueFromSubject() {
                SessionAdapter sessionAdapter = (SessionAdapter)this.subject;
                return sessionAdapter.getLog();
            }
        };
    }

    private ButtonModel buildOptionsCheckBoxModelAdapter() {
        return new CheckBoxModelAdapter(this.buildOptionsHolder());
    }

    private PropertyValueModel buildOptionsHolder() {
        PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter(this.buildLogHolder(), "logOptions"){

            protected Object getValueFromSubject() {
                LogAdapter logAdapter = (LogAdapter)((Object)this.subject);
                if (logAdapter.optionsIsEnable()) {
                    return Boolean.TRUE;
                }
                return null;
            }

            protected void setValueOnSubject(Object object) {
                LogAdapter logAdapter = (LogAdapter)((Object)this.subject);
                if (Boolean.TRUE.equals(object) && !logAdapter.optionsIsEnable()) {
                    logAdapter.enableOptions();
                } else if (Boolean.FALSE.equals(object) && logAdapter.optionsIsEnable()) {
                    logAdapter.disableOptions();
                }
            }
        };
        return new TransformationPropertyValueModel(propertyAspectAdapter){

            protected Object transform(Object object) {
                return object != null;
            }
        };
    }

    protected Component buildPage() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        PropertyValueModel propertyValueModel = this.buildLoggingTypeSelectionHolder();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JRadioButton jRadioButton = this.buildRadioButton("DATABASE_SESSION_LOGGING_TYPE_SERVER", new RadioButtonModelAdapter(propertyValueModel, LOGGING_TYPE_SERVER_CHOICE));
        this.addHelpTopicId(jRadioButton, "session.logging.server");
        JRadioButton jRadioButton2 = this.buildRadioButton("DATABASE_SESSION_LOGGING_TYPE_JAVA", new RadioButtonModelAdapter(propertyValueModel, LOGGING_TYPE_JAVA_CHOICE));
        this.addHelpTopicId(jRadioButton2, "session.logging.java");
        JRadioButton jRadioButton3 = this.buildRadioButton("DATABASE_SESSION_LOGGING_TYPE_STANDARD", new RadioButtonModelAdapter(propertyValueModel, LOGGING_TYPE_STANDARD_CHOICE));
        this.addHelpTopicId(jRadioButton3, "session.logging.standard");
        StandardPane standardPane = new StandardPane(this.buildStandardLogHolder());
        this.addPaneForAlignment(standardPane);
        new ComponentEnabler((ValueModel)this.buildStandardPaneEnableStateHolder(), standardPane.getComponents());
        this.addHelpTopicId(standardPane, "session.logging.standard");
        GroupBox groupBox = new GroupBox(new AbstractButton[]{jRadioButton, jRadioButton2, jRadioButton3}, (JComponent)standardPane);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)groupBox, gridBagConstraints);
        JCheckBox jCheckBox = this.buildCheckBox("LOGGING_OPTIONS_CHECK_BOX", this.buildOptionsCheckBoxModelAdapter());
        LoggingOptionsPane loggingOptionsPane = new LoggingOptionsPane((ValueModel)this.buildLogAdapterHolder(), this.getApplicationContext());
        groupBox = new GroupBox(jCheckBox, (JComponent)loggingOptionsPane);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)groupBox, gridBagConstraints);
        new ComponentEnabler((ValueModel)this.buildLoggingOptionsCheckBoxEnablerHolder(), jCheckBox);
        new ComponentEnabler((ValueModel)this.buildLoggingOptionsPaneEnablerHolder(), loggingOptionsPane.getComponents());
        this.addHelpTopicId(groupBox, "session.logging.options");
        this.addHelpTopicId(this, "session.logging");
        return jPanel;
    }

    private PropertyChangeListener buildSelectionHolderListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SessionLoggingPropertiesPage.this.pseudoModel.setParentNode((Node)((AbstractNodeModel)propertyChangeEvent.getNewValue()));
            }
        };
    }

    private PropertyValueModel buildStandardLogHolder() {
        return new TransformationPropertyValueModel(this.buildLogHolder()){

            protected Object transform(Object object) {
                if (object == null) {
                    return null;
                }
                if (object instanceof DefaultSessionLogAdapter) {
                    return object;
                }
                return null;
            }
        };
    }

    private PropertyValueModel buildStandardPaneEnableStateHolder() {
        return new TransformationPropertyValueModel(this.buildLoggingTypeSelectionHolder()){

            protected Object transform(Object object) {
                if (object == null) {
                    return null;
                }
                return object == LOGGING_TYPE_STANDARD_CHOICE;
            }
        };
    }

    protected void initialize(PropertyValueModel propertyValueModel) {
        super.initialize(propertyValueModel);
        this.getSelectionHolder().addPropertyChangeListener("value", this.buildSelectionHolderListener());
        this.pseudoModel = new PseudoLogginOptionsModel();
        this.pseudoModel.setParentNode((Node)((AbstractNodeModel)this.selection()));
    }

    private class StandardPane
    extends AbstractSubjectPanel {
        private StandardPane(PropertyValueModel propertyValueModel) {
            super((ValueModel)propertyValueModel, SessionLoggingPropertiesPage.this.getApplicationContext());
            this.addHelpTopicId(this, "session.logging.standard");
        }

        private PropertyValueModel buildDestinationSelectionHolder() {
            return new PropertyAspectAdapter(this.getSubjectHolder(), "filename"){

                protected Object getValueFromSubject() {
                    DefaultSessionLogAdapter defaultSessionLogAdapter = (DefaultSessionLogAdapter)((Object)this.subject);
                    String string = defaultSessionLogAdapter.getFileName();
                    return "standard output".equals(string);
                }

                protected void setValueOnSubject(Object object) {
                    DefaultSessionLogAdapter defaultSessionLogAdapter = (DefaultSessionLogAdapter)((Object)this.subject);
                    String string = defaultSessionLogAdapter.getFileName();
                    if (Boolean.TRUE.equals(object) && !"standard output".equals(string)) {
                        defaultSessionLogAdapter.setFileName("standard output");
                    } else if (Boolean.FALSE.equals(object) && "standard output".equals(string)) {
                        defaultSessionLogAdapter.setFileName("");
                    }
                }
            };
        }

        private void buildLocationWidgetsEnabler(JComponent jComponent) {
            new ComponentEnabler((ValueModel)this.buildLocationWidgetsEnablerHolder(), Collections.singleton(jComponent), true);
        }

        private PropertyValueModel buildLocationWidgetsEnablerHolder() {
            return new TransformationPropertyValueModel(this.buildLogFileHolder()){

                protected Object transform(Object object) {
                    if (object == null) {
                        return null;
                    }
                    return !"standard output".equals(object);
                }
            };
        }

        private PropertyValueModel buildLogFileHolder() {
            return new PropertyAspectAdapter(this.getSubjectHolder(), "filename"){

                protected Object getValueFromSubject() {
                    DefaultSessionLogAdapter defaultSessionLogAdapter = (DefaultSessionLogAdapter)((Object)this.subject);
                    String string = defaultSessionLogAdapter.getFileName();
                    if ("standard output".equals(string)) {
                        string = StandardPane.this.resourceRepository().getString("SESSIONS_LOGGING_PROPERTIES_PAGE_DEFAULT_LOG_FILENAME");
                    }
                    return string;
                }

                protected void setValueOnSubject(Object object) {
                    DefaultSessionLogAdapter defaultSessionLogAdapter = (DefaultSessionLogAdapter)((Object)this.subject);
                    String string = (String)object;
                    if (string != null) {
                        string = string.trim();
                    }
                    defaultSessionLogAdapter.setFileName(string);
                    if (!StringTools.stringIsEmpty((String)string)) {
                        File file = new File(string);
                        if ((file = file.getParentFile()) != null) {
                            StandardPane.this.preferences().get("location", file.getPath());
                        }
                    }
                }
            };
        }

        private ComboBoxModel buildLogLevelComboAdapter() {
            return new ComboBoxModelAdapter(this.buildLogLevelListHolder(), this.buildLogLevelSelectionHolder());
        }

        private ListValueModel buildLogLevelListHolder() {
            return new SimpleListValueModel(CollectionTools.list((Object[])DefaultSessionLogAdapter.VALID_LOG_LEVEL));
        }

        private PropertyValueModel buildLogLevelSelectionHolder() {
            return new PropertyAspectAdapter(this.getSubjectHolder(), "logLevel"){

                protected Object getValueFromSubject() {
                    DefaultSessionLogAdapter defaultSessionLogAdapter = (DefaultSessionLogAdapter)((Object)this.subject);
                    return defaultSessionLogAdapter.getLogLevel();
                }

                protected void setValueOnSubject(Object object) {
                    DefaultSessionLogAdapter defaultSessionLogAdapter = (DefaultSessionLogAdapter)((Object)this.subject);
                    defaultSessionLogAdapter.setLogLevel((String)object);
                }
            };
        }

        protected void initializeLayout() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JComboBox<String> jComboBox = new JComboBox<String>(this.buildLogLevelComboAdapter());
            jComboBox.setPrototypeDisplayValue("warningmmm");
            JComponent jComponent = this.buildLabeledComponent("DATABASE_SESSION_LOGGING_LEVEL_COMBO_BOX", jComboBox);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)jComponent, gridBagConstraints);
            JRadioButton jRadioButton = this.buildRadioButton("DATABASE_SESSION_DESTINATION_CONSOLE", new RadioButtonModelAdapter(this.buildDestinationSelectionHolder(), Boolean.TRUE));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = new Insets(8, 0, 0, 0);
            this.add((Component)jRadioButton, gridBagConstraints);
            JRadioButton jRadioButton2 = this.buildRadioButton("DATABASE_SESSION_DESTINATION_FILE", new RadioButtonModelAdapter(this.buildDestinationSelectionHolder(), Boolean.FALSE));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)jRadioButton2, gridBagConstraints);
            CustomizedFileChooserPanel customizedFileChooserPanel = new CustomizedFileChooserPanel();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            this.add((Component)customizedFileChooserPanel, gridBagConstraints);
            this.addPaneForAlignment(customizedFileChooserPanel);
            this.buildLocationWidgetsEnabler(customizedFileChooserPanel);
        }

        private class CustomizedFileChooserPanel
        extends FileChooserPanel {
            private CustomizedFileChooserPanel() {
                super(StandardPane.this.getApplicationContext(), StandardPane.this.buildLogFileHolder(), "DATABASE_SESSION_LOG_FILE_LOCATION_FIELD", "SESSION_LOGGING_BROWSE_BUTTON", 0);
            }

            protected File getFileChooserDefaultDirectory() {
                DefaultSessionLogAdapter defaultSessionLogAdapter = (DefaultSessionLogAdapter)((Object)StandardPane.this.subject());
                String string = defaultSessionLogAdapter.getFileName();
                if (!StringTools.stringIsEmpty((String)string)) {
                    File file = new File(string);
                    if (file.isFile()) {
                        file = file.getParentFile();
                    }
                    return file;
                }
                SessionAdapter sessionAdapter = (SessionAdapter)defaultSessionLogAdapter.getParent();
                TopLinkSessionsAdapter topLinkSessionsAdapter = (TopLinkSessionsAdapter)sessionAdapter.getParent();
                File file = topLinkSessionsAdapter.getSaveDirectory();
                if (file == null) {
                    file = FileTools.userHomeDirectory();
                }
                return new File(this.preferences().get("location", file.getPath()));
            }

            public void setEnabled(boolean bl) {
                DefaultSessionLogAdapter defaultSessionLogAdapter = (DefaultSessionLogAdapter)((Object)StandardPane.this.subject());
                if (bl) {
                    bl = defaultSessionLogAdapter != null ? (bl &= !"standard output".equals(defaultSessionLogAdapter.getFileName())) : false;
                }
                super.setEnabled(bl);
            }
        }
    }

    private class PseudoLogginOptionsModel
    extends AbstractNodeModel {
        private ChangeNotifier changeNotifier;
        private PropertyChangeListener listener;
        private LogAdapter logOptions;
        private Node parentNode;
        private Node.Validator validator;
        public static final String LOG_OPTIONS_PROPERTY = "logOptions";

        private PseudoLogginOptionsModel() {
        }

        private PropertyChangeListener buildPropertyChangeListener() {
            return new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("log".equals(propertyChangeEvent.getPropertyName())) {
                        LogAdapter logAdapter = (LogAdapter)((Object)propertyChangeEvent.getOldValue());
                        logAdapter.removePropertyChangeListener(PseudoLogginOptionsModel.LOG_OPTIONS_PROPERTY, this);
                        LogAdapter logAdapter2 = (LogAdapter)((Object)propertyChangeEvent.getNewValue());
                        logAdapter2.addPropertyChangeListener(PseudoLogginOptionsModel.LOG_OPTIONS_PROPERTY, this);
                    }
                    PseudoLogginOptionsModel.this.updateLogOptions();
                }
            };
        }

        protected void checkParent(Node node) {
        }

        private void disengageListeners() {
            SessionAdapter sessionAdapter = (SessionAdapter)this.parentNode;
            sessionAdapter.removePropertyChangeListener("log", this.listener);
            sessionAdapter.getLog().removePropertyChangeListener(LOG_OPTIONS_PROPERTY, this.listener);
        }

        public String displayString() {
            return null;
        }

        private void engageListeners() {
            SessionAdapter sessionAdapter = (SessionAdapter)this.parentNode;
            sessionAdapter.addPropertyChangeListener("log", this.listener);
            sessionAdapter.getLog().addPropertyChangeListener(LOG_OPTIONS_PROPERTY, this.listener);
        }

        public ChangeNotifier getChangeNotifier() {
            return this.changeNotifier;
        }

        public LogAdapter getLogOptions() {
            return this.logOptions;
        }

        public Node.Validator getValidator() {
            return this.validator;
        }

        protected void initialize() {
            super.initialize();
            this.listener = this.buildPropertyChangeListener();
        }

        private void setLogOptions(LogAdapter logAdapter) {
            LogAdapter logAdapter2 = this.getLogOptions();
            this.logOptions = logAdapter;
            this.firePropertyChanged(LOG_OPTIONS_PROPERTY, (Object)logAdapter2, (Object)logAdapter);
        }

        public void setParentNode(Node node) {
            if (this.parentNode != null) {
                this.disengageListeners();
                this.setLogOptions(null);
                this.validator = null;
                this.changeNotifier = null;
            }
            this.parentNode = node;
            if (node != null) {
                this.validator = node.getValidator();
                this.changeNotifier = node.getChangeNotifier();
                this.engageListeners();
                this.updateLogOptions();
            }
        }

        private void updateLogOptions() {
            SessionAdapter sessionAdapter = (SessionAdapter)this.parentNode;
            LogAdapter logAdapter = sessionAdapter.getLog();
            if (!logAdapter.optionsIsEnable()) {
                logAdapter = null;
            }
            this.setLogOptions(logAdapter);
        }
    }
}

