/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.SortedSet;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.text.Document;
import org.eclipse.persistence.platform.server.CustomServerPlatform;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.GroupBox;
import org.eclipse.persistence.tools.workbench.scplugin.model.ServerPlatformManager;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.CustomServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.NullServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerPlatform;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.tools.ClassChooserTools;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.ComponentVisibilityEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimpleCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public class SessionServerPlatformPropertiesPage
extends ScrollablePropertiesPage {
    public SessionServerPlatformPropertiesPage(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    protected Component buildPage() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JCheckBox jCheckBox = this.buildCheckBox("SERVER_PLATFORM_CHECK_BOX", this.buildUseServerPlatformButtonModel());
        jCheckBox.addActionListener(this.buildServerPlatformAction());
        ServerPlatformPane serverPlatformPane = new ServerPlatformPane(this.buildServerPlatformPaneSubjectHolder());
        new ComponentEnabler((ValueModel)this.buildServerPlatformBooleanHolder(), serverPlatformPane.getComponents());
        GroupBox groupBox = new GroupBox(jCheckBox, (JComponent)serverPlatformPane);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)groupBox, gridBagConstraints);
        this.addHelpTopicId(jPanel, "session.serverPlatform");
        return jPanel;
    }

    private ActionListener buildServerPlatformAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                SessionAdapter sessionAdapter = (SessionAdapter)SessionServerPlatformPropertiesPage.this.selection();
                boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
                String string2 = NullServerPlatformAdapter.instance().getServerClassName();
                string2 = ClassTools.shortNameForClassNamed((String)string2);
                if (!bl) {
                    string = string2;
                } else {
                    string = SessionServerPlatformPropertiesPage.this.preferences().get("platform.server", "WebLogic_10_Platform");
                    if (string2.equals(string)) {
                        string = "WebLogic_10_Platform";
                    }
                }
                sessionAdapter.setServerPlatform(new ServerPlatform(string));
            }
        };
    }

    private PropertyValueModel buildServerPlatformBooleanHolder() {
        return new TransformationPropertyValueModel(this.buildServerPlatformHolder()){

            protected Object transform(Object object) {
                if (object == null) {
                    return null;
                }
                ServerPlatformAdapter serverPlatformAdapter = (ServerPlatformAdapter)((Object)object);
                return !serverPlatformAdapter.isNull();
            }
        };
    }

    private PropertyValueModel buildServerPlatformHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "serverPlatform"){

            protected Object getValueFromSubject() {
                SessionAdapter sessionAdapter = (SessionAdapter)this.subject;
                return sessionAdapter.getServerPlatform();
            }

            protected void setValueOnSubject(Object object) {
            }
        };
    }

    private PropertyValueModel buildServerPlatformPaneSubjectHolder() {
        return new TransformationPropertyValueModel(this.buildServerPlatformHolder()){

            protected Object transform(Object object) {
                if (object == null) {
                    return null;
                }
                ServerPlatformAdapter serverPlatformAdapter = (ServerPlatformAdapter)((Object)object);
                return serverPlatformAdapter.isNull() ? null : object;
            }
        };
    }

    private ButtonModel buildUseServerPlatformButtonModel() {
        return new CheckBoxModelAdapter(this.buildUseServerPlatformHolder());
    }

    private PropertyValueModel buildUseServerPlatformHolder() {
        return new TransformationPropertyValueModel(this.buildServerPlatformHolder()){

            protected Object transform(Object object) {
                if (object == null) {
                    return null;
                }
                ServerPlatformAdapter serverPlatformAdapter = (ServerPlatformAdapter)((Object)object);
                return !serverPlatformAdapter.isNull();
            }
        };
    }

    private class ServerPlatformPane
    extends AbstractSubjectPanel {
        private ServerPlatformPane(PropertyValueModel propertyValueModel) {
            super((ValueModel)propertyValueModel, SessionServerPlatformPropertiesPage.this.getWorkbenchContextHolder());
        }

        private ComponentVisibilityEnabler buildCustomServerPlatformComponentVisibilityUpdater(Component component) {
            return new ComponentVisibilityEnabler((ValueModel)this.buildCustomServerPlatformVisibilityHolder(), Collections.singleton(component));
        }

        private PropertyValueModel buildCustomServerPlatformHolder() {
            return new TransformationPropertyValueModel(SessionServerPlatformPropertiesPage.this.buildServerPlatformHolder()){

                protected Object transform(Object object) {
                    if (object == null) {
                        return null;
                    }
                    ServerPlatformAdapter serverPlatformAdapter = (ServerPlatformAdapter)((Object)object);
                    return serverPlatformAdapter.isCustom() ? object : null;
                }
            };
        }

        private JComponent buildCustomServerPlatformSubPane() {
            return new CustomServerPlatformSubPane(this.buildCustomServerPlatformHolder());
        }

        private PropertyValueModel buildCustomServerPlatformVisibilityHolder() {
            return new TransformationPropertyValueModel(SessionServerPlatformPropertiesPage.this.buildServerPlatformHolder()){

                protected Object transform(Object object) {
                    if (object == null) {
                        return null;
                    }
                    ServerPlatformAdapter serverPlatformAdapter = (ServerPlatformAdapter)((Object)object);
                    return serverPlatformAdapter.isCustom();
                }
            };
        }

        private ButtonModel buildEnableExternalTransactionControllerButtonModel() {
            return new CheckBoxModelAdapter(this.buildEnableExternalTransactionControllerHolder());
        }

        private PropertyValueModel buildEnableExternalTransactionControllerHolder() {
            return new PropertyAspectAdapter(this.getSubjectHolder(), "enableJTA"){

                protected Object getValueFromSubject() {
                    ServerPlatformAdapter serverPlatformAdapter = (ServerPlatformAdapter)((Object)this.subject);
                    return serverPlatformAdapter.getEnableJTA();
                }

                protected void setValueOnSubject(Object object) {
                    ServerPlatformAdapter serverPlatformAdapter = (ServerPlatformAdapter)((Object)this.subject);
                    serverPlatformAdapter.setEnableJTA(Boolean.TRUE.equals(object));
                }
            };
        }

        private ButtonModel buildEnableRuntimeServicesButtonModel() {
            return new CheckBoxModelAdapter(this.buildEnableRuntimeServicesHolder());
        }

        private PropertyValueModel buildEnableRuntimeServicesHolder() {
            return new PropertyAspectAdapter(this.getSubjectHolder(), "enableRuntimeServices"){

                protected Object getValueFromSubject() {
                    ServerPlatformAdapter serverPlatformAdapter = (ServerPlatformAdapter)((Object)this.subject);
                    return serverPlatformAdapter.getEnableRuntimeServices();
                }

                protected void setValueOnSubject(Object object) {
                    ServerPlatformAdapter serverPlatformAdapter = (ServerPlatformAdapter)((Object)this.subject);
                    serverPlatformAdapter.setEnableRuntimeServices(Boolean.TRUE.equals(object));
                }
            };
        }

        private CollectionValueModel buildServerPlatformCollectionHolder() {
            return new SimpleCollectionValueModel(this.buildServerPlatformNames());
        }

        private ComboBoxModel buildServerPlatformComboBoxModel() {
            return new ComboBoxModelAdapter(this.buildServerPlatformCollectionHolder(), this.buildServerPlatformSelectionHolder());
        }

        private Collection buildServerPlatformNames() {
            SortedSet sortedSet = CollectionTools.sortedSet((Iterator)ServerPlatformManager.instance().platformShortNames());
            String string = NullServerPlatformAdapter.instance().getServerClassName();
            sortedSet.remove(ClassTools.shortNameForClassNamed((String)string));
            return sortedSet;
        }

        private ListCellRenderer buildServerPlatformRenderer() {
            return new SimpleListCellRenderer(){

                protected String buildText(Object object) {
                    if (object == null) {
                        return "";
                    }
                    return ServerPlatformPane.this.resourceRepository().getString((String)object);
                }
            };
        }

        private PropertyValueModel buildServerPlatformSelectionHolder() {
            PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter(SessionServerPlatformPropertiesPage.this.getSelectionHolder(), "serverPlatform"){

                protected Object getValueFromSubject() {
                    SessionAdapter sessionAdapter = (SessionAdapter)this.subject;
                    return sessionAdapter.getServerPlatform();
                }

                protected void setValueOnSubject(Object object) {
                    SessionAdapter sessionAdapter = (SessionAdapter)this.subject;
                    ServerPlatformAdapter serverPlatformAdapter = sessionAdapter.getServerPlatform();
                    String string = (String)object;
                    String string2 = serverPlatformAdapter.isCustom() ? NullServerPlatformAdapter.instance().getServerClassName() : serverPlatformAdapter.getServerClassName();
                    if (!(string2 = ClassTools.shortNameForClassNamed((String)string2)).equals(string)) {
                        sessionAdapter.setServerPlatform(new ServerPlatform(string));
                    }
                }
            };
            return new TransformationPropertyValueModel(propertyAspectAdapter){

                protected Object transform(Object object) {
                    if (object == null) {
                        return null;
                    }
                    ServerPlatformAdapter serverPlatformAdapter = (ServerPlatformAdapter)((Object)object);
                    String string = serverPlatformAdapter.getServerClassName();
                    if (serverPlatformAdapter.isCustom()) {
                        string = CustomServerPlatform.class.getName();
                    }
                    if (serverPlatformAdapter.isNull()) {
                        return null;
                    }
                    return ClassTools.shortNameForClassNamed((String)string);
                }
            };
        }

        protected void initializeLayout() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JComponent jComponent = this.buildLabeledComboBox("SERVER_PLATFORM_COMBO_BOX", this.buildServerPlatformComboBoxModel(), this.buildServerPlatformRenderer());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)jComponent, gridBagConstraints);
            JCheckBox jCheckBox = this.buildCheckBox("SERVER_PLATFORM_ENABLE_RUNTIME_SERVICES_CHECK_BOX", this.buildEnableRuntimeServicesButtonModel());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            this.add((Component)jCheckBox, gridBagConstraints);
            JCheckBox jCheckBox2 = this.buildCheckBox("SERVER_PLATFORM_ENABLE_EXTERNAL_TRANSACTION_CONTROLLER_CHECK_BOX", this.buildEnableExternalTransactionControllerButtonModel());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)jCheckBox2, gridBagConstraints);
            JComponent jComponent2 = this.buildCustomServerPlatformSubPane();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 19;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            this.add((Component)jComponent2, gridBagConstraints);
            this.buildCustomServerPlatformComponentVisibilityUpdater(jComponent2);
        }
    }

    private class CustomServerPlatformSubPane
    extends AbstractSubjectPanel {
        private CustomServerPlatformSubPane(PropertyValueModel propertyValueModel) {
            super((ValueModel)propertyValueModel, SessionServerPlatformPropertiesPage.this.getWorkbenchContextHolder());
        }

        private ValueModel buildClassRepositoryHolder() {
            return new PropertyAspectAdapter(SessionServerPlatformPropertiesPage.this.getSelectionHolder()){

                protected Object getValueFromSubject() {
                    SCAdapter sCAdapter = (SCAdapter)((Object)this.subject);
                    return sCAdapter.getClassRepository();
                }
            };
        }

        private JButton buildExternalTransactionControllerBrowseButton() {
            return ClassChooserTools.buildBrowseButton(this.getWorkbenchContextHolder(), "SERVER_PLATFORM_CUSTOM_EXTERNAL_TRANSACTION_CONTROLLER_BROWSE_BUTTON", this.buildClassRepositoryHolder(), this.buildExternalTransactionControllerHolder());
        }

        private Document buildExternalTransactionControllerDocument() {
            return new DocumentAdapter(this.buildExternalTransactionControllerHolder());
        }

        private PropertyValueModel buildExternalTransactionControllerHolder() {
            return new PropertyAspectAdapter(this.getSubjectHolder(), "externalTransactionControllerClass"){

                protected Object getValueFromSubject() {
                    CustomServerPlatformAdapter customServerPlatformAdapter = (CustomServerPlatformAdapter)((Object)this.subject);
                    return customServerPlatformAdapter.getExternalTransactionControllerClass();
                }

                protected void setValueOnSubject(Object object) {
                    CustomServerPlatformAdapter customServerPlatformAdapter = (CustomServerPlatformAdapter)((Object)this.subject);
                    customServerPlatformAdapter.setExternalTransactionControllerClass((String)object);
                }
            };
        }

        private JButton buildServerClassBrowseButton() {
            return ClassChooserTools.buildBrowseButton(this.getWorkbenchContextHolder(), "SERVER_PLATFORM_CUSTOM_SERVER_CLASS_BROWSE_BUTTON", this.buildClassRepositoryHolder(), this.buildServerClassHolder());
        }

        private Document buildServerClassDocument() {
            return new DocumentAdapter(this.buildServerClassHolder());
        }

        private PropertyValueModel buildServerClassHolder() {
            return new PropertyAspectAdapter(this.getSubjectHolder(), "serverClassName"){

                protected Object getValueFromSubject() {
                    CustomServerPlatformAdapter customServerPlatformAdapter = (CustomServerPlatformAdapter)((Object)this.subject);
                    return customServerPlatformAdapter.getServerClassName();
                }

                protected void setValueOnSubject(Object object) {
                    CustomServerPlatformAdapter customServerPlatformAdapter = (CustomServerPlatformAdapter)((Object)this.subject);
                    customServerPlatformAdapter.setServerClassName((String)object);
                }
            };
        }

        protected void initializeLayout() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JComponent jComponent = this.buildLabeledTextField("SERVER_PLATFORM_CUSTOM_SERVER_CLASS_CHOOSER", this.buildServerClassDocument(), this.buildServerClassBrowseButton());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)jComponent, gridBagConstraints);
            JComponent jComponent2 = this.buildLabeledTextField("SERVER_PLATFORM_CUSTOM_EXTERNAL_TRANSACTION_CONTROLLER_CHOOSER", this.buildExternalTransactionControllerDocument(), this.buildExternalTransactionControllerBrowseButton());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            this.add((Component)jComponent2, gridBagConstraints);
        }
    }
}

