/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractValidatingDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ProjectAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ProjectXMLAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic.AbstractSessionMultipleProjectsPane;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

final class XmlSessionMultipleProjectsPane
extends AbstractSessionMultipleProjectsPane {
    XmlSessionMultipleProjectsPane(ValueModel valueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(valueModel, workbenchContextHolder);
    }

    protected void addProject(ObjectListSelectionModel objectListSelectionModel) {
        DatabaseSessionAdapter databaseSessionAdapter = (DatabaseSessionAdapter)this.subject();
        SimplePropertyValueModel simplePropertyValueModel = new SimplePropertyValueModel();
        ProjectXmlEditDialog projectXmlEditDialog = new ProjectXmlEditDialog(simplePropertyValueModel);
        projectXmlEditDialog.setVisible(true);
        if (projectXmlEditDialog.wasCanceled()) {
            return;
        }
        String string = (String)simplePropertyValueModel.getValue();
        String string2 = string.replace('\\', '/');
        if (CollectionTools.contains((Iterator)databaseSessionAdapter.additionalProjectNames(), (Object)string2)) {
            ProjectAdapter projectAdapter = databaseSessionAdapter.projectNamed(string2);
            objectListSelectionModel.setSelectedValue((Object)projectAdapter);
        } else {
            ProjectXMLAdapter projectXMLAdapter = databaseSessionAdapter.addProjectXmlNamed(string);
            objectListSelectionModel.setSelectedValue((Object)projectXMLAdapter);
        }
    }

    private File retrieveLastDirectory() {
        DatabaseSessionAdapter databaseSessionAdapter = (DatabaseSessionAdapter)this.subject();
        TopLinkSessionsAdapter topLinkSessionsAdapter = (TopLinkSessionsAdapter)databaseSessionAdapter.getParent();
        File file = topLinkSessionsAdapter.getSaveDirectory();
        if (file == null) {
            file = FileTools.userHomeDirectory();
        }
        return new File(this.preferences().get("location", file.getPath()));
    }

    private class XmlFileFilter
    extends FileFilter {
        private XmlFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || ".xml".equalsIgnoreCase(FileTools.extension((File)file));
        }

        public String getDescription() {
            return XmlSessionMultipleProjectsPane.this.resourceRepository().getString("SESSION_PROJECT_ADVANCED_FILE_CHOOSER_DESCRIPTION");
        }
    }

    private class ProjectXmlEditDialog
    extends AbstractValidatingDialog {
        private final PropertyValueModel projectXmlHolder;
        private JTextField textField;

        ProjectXmlEditDialog(PropertyValueModel propertyValueModel) {
            super(XmlSessionMultipleProjectsPane.this.getWorkbenchContext(), XmlSessionMultipleProjectsPane.this.resourceRepository().getString("PROJECT_TYPE_EDIT_DIALOG_TITLE_ADD"));
            this.projectXmlHolder = propertyValueModel;
            propertyValueModel.addPropertyChangeListener("value", this.buildPropertyChangeListener());
        }

        private void addProjectXML() {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileFilter(new XmlFileFilter());
            jFileChooser.setCurrentDirectory(XmlSessionMultipleProjectsPane.this.retrieveLastDirectory());
            jFileChooser.setFileSelectionMode(0);
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                this.preferences().put("location", file.getParent());
                String string = file.getAbsolutePath();
                this.projectXmlHolder.setValue(string);
            }
        }

        protected Component buildMainPanel() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JPanel jPanel = new JPanel(new GridBagLayout());
            JButton jButton = SwingComponentFactory.buildButton("PROJECT_TYPE_EDIT_DIALOG_XML_BROWSE_BUTTON", this.resourceRepository());
            jButton.addActionListener(this.buildXMLBrowseAction());
            this.textField = new JTextField(this.buildProjectXmlDocumentAdapter(), null, 30);
            JComponent jComponent = this.buildLabeledComponent("PROJECT_TYPE_EDIT_DIALOG_XML_FIELD", (JComponent)this.textField, (JComponent)jButton);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            jPanel.add((Component)jComponent, gridBagConstraints);
            return jPanel;
        }

        private Document buildProjectXmlDocumentAdapter() {
            return new DocumentAdapter(this.projectXmlHolder);
        }

        private PropertyChangeListener buildPropertyChangeListener() {
            return new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = (String)propertyChangeEvent.getNewValue();
                    boolean bl = !StringTools.stringIsEmpty((String)string);
                    ProjectXmlEditDialog.this.getOKAction().setEnabled(bl);
                    if (bl) {
                        ProjectXmlEditDialog.this.clearErrorMessage();
                    } else {
                        ProjectXmlEditDialog.this.setErrorMessageKey("PROJECT_TYPE_EDIT_DIALOG_ERROR_MESSAGE");
                    }
                }
            };
        }

        private ActionListener buildXMLBrowseAction() {
            return new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ProjectXmlEditDialog.this.addProjectXML();
                }
            };
        }

        protected String helpTopicId() {
            return "dialog.session.projectType";
        }

        protected Component initialFocusComponent() {
            return this.textField;
        }

        protected void prepareToShow() {
            super.prepareToShow();
            this.getOKAction().setEnabled(false);
        }
    }
}

