/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic.AbstractSessionProjectlPane;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;

final class XmlSessionProjectPane
extends AbstractSessionProjectlPane {
    XmlSessionProjectPane(ValueModel valueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(valueModel, workbenchContextHolder);
    }

    private ActionListener buildEditAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XmlSessionProjectPane.this.edit();
            }
        };
    }

    protected PropertyValueModel buildPrimaryProjectNameHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "primaryProject"){

            protected Object getValueFromSubject() {
                DatabaseSessionAdapter databaseSessionAdapter = (DatabaseSessionAdapter)this.subject;
                return databaseSessionAdapter.getPrimaryProjectName();
            }

            protected void setValueOnSubject(Object object) {
                DatabaseSessionAdapter databaseSessionAdapter = (DatabaseSessionAdapter)this.subject;
                databaseSessionAdapter.addPrimaryProjectXmlNamed((String)object);
            }
        };
    }

    protected JButton buildEditButton() {
        JButton jButton = this.buildButton("SESSION_PROJECT_BROWSE_BUTTON");
        jButton.addActionListener(this.buildEditAction());
        return jButton;
    }

    private void edit() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new XmlFileFilter());
        jFileChooser.setCurrentDirectory(this.retrieveLastDirectory());
        jFileChooser.setFileSelectionMode(0);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            DatabaseSessionAdapter databaseSessionAdapter = (DatabaseSessionAdapter)this.subject();
            File file = jFileChooser.getSelectedFile();
            this.preferences().put("location", file.getParent());
            String string = file.getAbsolutePath();
            if (string != null) {
                string = string.replace('\\', '/');
            }
            databaseSessionAdapter.addPrimaryProjectXmlNamed(string);
        }
    }

    private File retrieveLastDirectory() {
        DatabaseSessionAdapter databaseSessionAdapter = (DatabaseSessionAdapter)this.subject();
        TopLinkSessionsAdapter topLinkSessionsAdapter = (TopLinkSessionsAdapter)databaseSessionAdapter.getParent();
        File file = topLinkSessionsAdapter.getSaveDirectory();
        if (file == null) {
            file = FileTools.userHomeDirectory();
        }
        return new File(this.preferences().get("location", file.getPath()));
    }

    private class XmlFileFilter
    extends FileFilter {
        private XmlFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || ".xml".equalsIgnoreCase(FileTools.extension((File)file));
        }

        public String getDescription() {
            return XmlSessionProjectPane.this.resourceRepository().getString("SESSION_PROJECT_ADVANCED_FILE_CHOOSER_DESCRIPTION");
        }
    }
}

