/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.clustering;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingTools;
import org.eclipse.persistence.tools.workbench.framework.uitools.TriStateBooleanCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.clustering.RemoteCommandManagerPane;
import org.eclipse.persistence.tools.workbench.uitools.SwitcherPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.utility.Transformer;
import org.eclipse.persistence.tools.workbench.utility.TriStateBoolean;
import org.eclipse.persistence.tools.workbench.utility.iterators.ArrayIterator;

public final class SessionClusteringPropertiesPage
extends ScrollablePropertiesPage {
    public SessionClusteringPropertiesPage(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    private CollectionValueModel buildClusteringCollectionHolder() {
        return new CollectionAspectAdapter(this.getSelectionHolder(), null){

            protected Iterator getValueFromSubject() {
                return new ArrayIterator(new Object[]{TriStateBoolean.UNDEFINED, TriStateBoolean.TRUE, TriStateBoolean.FALSE});
            }
        };
    }

    private ComboBoxModel buildClusteringComboBoxAdapter() {
        return new ComboBoxModelAdapter(this.buildClusteringCollectionHolder(), this.buildClusteringTypeSelectionHolder());
    }

    private CellRendererAdapter buildClusteringLabelDecorator() {
        ResourceRepository resourceRepository = this.resourceRepository();
        return new TriStateBooleanCellRendererAdapter(resourceRepository){

            protected String trueResourceKey() {
                return "REMOTE_COMMAND";
            }

            protected String falseResourceKey() {
                return "CACHE_SYNCHRONIZATION";
            }

            protected String undefinedResourceKey() {
                return "DEFAULT_CLUSTERING_TYPE";
            }
        };
    }

    private SwitcherPanel buildClusteringSwitcherPanel() {
        return new SwitcherPanel(this.buildClusteringTypeHolder(), this.buildClusteringTypeTransformer());
    }

    private PropertyValueModel buildClusteringTypeHolder() {
        String[] stringArray = new String[]{"remoteCommandManager"};
        return new PropertyAspectAdapter(this.getSelectionHolder(), stringArray){

            protected Object getValueFromSubject() {
                SessionAdapter sessionAdapter = (SessionAdapter)this.subject;
                if (sessionAdapter.hasRemoteCommandManager()) {
                    return sessionAdapter.getRemoteCommandManager();
                }
                return null;
            }
        };
    }

    private PropertyValueModel buildClusteringTypeSelectionHolder() {
        String[] stringArray = new String[]{"remoteCommandManager"};
        return new PropertyAspectAdapter(this.getSelectionHolder(), stringArray){

            protected Object getValueFromSubject() {
                SessionAdapter sessionAdapter = (SessionAdapter)this.subject;
                if (sessionAdapter.hasNoClusteringService()) {
                    return TriStateBoolean.UNDEFINED;
                }
                return TriStateBoolean.valueOf((boolean)sessionAdapter.hasRemoteCommandManager());
            }

            protected void setValueOnSubject(Object object) {
                SessionAdapter sessionAdapter = (SessionAdapter)this.subject;
                if (TriStateBoolean.TRUE.equals(object)) {
                    sessionAdapter.setClusteringToRemoteCommandManager();
                } else if (TriStateBoolean.FALSE.equals(object) || TriStateBoolean.UNDEFINED.equals(object)) {
                    sessionAdapter.setClusteringToNothing();
                }
            }
        };
    }

    private Transformer buildClusteringTypeTransformer() {
        final Object[] objectArray = new Object[]{new RemoteCommandManagerChoice()};
        return new Transformer(){

            public Object transform(Object object) {
                SessionAdapter sessionAdapter = (SessionAdapter)SessionClusteringPropertiesPage.this.selection();
                if (object == null || sessionAdapter == null) {
                    return null;
                }
                Transformer transformer = (Transformer)objectArray[0];
                return transformer.transform(object);
            }
        };
    }

    private JPanel buildInternalPage() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JComponent jComponent = this.buildLabeledComboBox("CLUSTERING_CLUSTERING_COMBO_BOX", this.buildClusteringComboBoxAdapter(), new AdaptableListCellRenderer(this.buildClusteringLabelDecorator()));
        jComponent.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jComponent, gridBagConstraints);
        this.addHelpTopicId(jComponent, "session.clustering");
        SwitcherPanel switcherPanel = this.buildClusteringSwitcherPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)switcherPanel, gridBagConstraints);
        return jPanel;
    }

    protected Component buildPage() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = SwingTools.checkBoxIconWidth();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel2 = this.buildInternalPage();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, n, 0, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.addHelpTopicId(this, "session.clustering");
        return jPanel;
    }

    private class RemoteCommandManagerChoice
    implements Transformer {
        private RemoteCommandManagerPane pane;

        private RemoteCommandManagerChoice() {
        }

        private PropertyValueModel buildRemoteCommandManagerHolder() {
            return new PropertyAspectAdapter(SessionClusteringPropertiesPage.this.getSelectionHolder(), "remoteCommandManager"){

                protected Object getValueFromSubject() {
                    SessionAdapter sessionAdapter = (SessionAdapter)this.subject;
                    return sessionAdapter.getRemoteCommandManager();
                }
            };
        }

        public Object transform(Object object) {
            if (this.pane == null) {
                this.pane = new RemoteCommandManagerPane((ValueModel)this.buildRemoteCommandManagerHolder(), SessionClusteringPropertiesPage.this.getWorkbenchContextHolder());
                SessionClusteringPropertiesPage.this.addPaneForAlignment(this.pane);
            }
            return this.pane;
        }
    }
}

