/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.login;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.uitools.Spacer;
import org.eclipse.persistence.tools.workbench.scplugin.model.EisPlatformManager;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.EISLoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.login.EisLoginPane;
import org.eclipse.persistence.tools.workbench.scplugin.ui.login.LoginExternalOptionsPane;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.login.AbstractLoginPropertiesPage;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public class EisConnectionPropertiesPage
extends AbstractLoginPropertiesPage {
    public EisConnectionPropertiesPage(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    private Comparator buildEisPlatformNameCompator() {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                String string = ((String)object).replaceFirst("Platform", "");
                String string2 = ((String)object2).replaceFirst("Platform", "");
                return string.compareTo(string2);
            }
        };
    }

    protected Component buildPage() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel jLabel = this.buildLabel("CONNECTION_EIS_PLATFORM_FIELD");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.addAlignLeft(jLabel);
        this.helpManager().addTopicID(jLabel, "session.login.database.connection.platform");
        JComboBox jComboBox = new JComboBox(this.buildPlatformComboAdapter());
        jComboBox.setName("CONNECTION_EIS_PLATFORM_FIELD");
        jComboBox.setRenderer(this.buildPlatformLabelDecorator());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add(jComboBox, gridBagConstraints);
        jLabel.setLabelFor(jComboBox);
        this.helpManager().addTopicID(jComboBox, "session.login.database.connection.platform");
        Spacer spacer = new Spacer();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)spacer, gridBagConstraints);
        this.addAlignRight(spacer);
        EisLoginPane eisLoginPane = new EisLoginPane(this.getSelectionHolder(), this.getWorkbenchContextHolder());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)eisLoginPane, gridBagConstraints);
        this.addPaneForAlignment(eisLoginPane);
        LoginExternalOptionsPane loginExternalOptionsPane = new LoginExternalOptionsPane(this.getSelectionHolder(), this.getApplicationContext());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)loginExternalOptionsPane, gridBagConstraints);
        this.helpManager().addTopicID(loginExternalOptionsPane, "session.login.externalPool");
        return jPanel;
    }

    private CollectionValueModel buildPlatformCollectionHolder() {
        SortedSet sortedSet = CollectionTools.sortedSet((Iterator)EisPlatformManager.instance().platformShortNames());
        return new ReadOnlyCollectionValueModel(sortedSet);
    }

    private ComboBoxModel buildPlatformComboAdapter() {
        return new ComboBoxModelAdapter(this.buildPlatformListHolder(), this.buildPlatformHolder());
    }

    private PropertyValueModel buildPlatformHolder() {
        PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter(this.getSelectionHolder(), "platformClass"){

            protected Object getValueFromSubject() {
                EISLoginAdapter eISLoginAdapter = (EISLoginAdapter)this.subject;
                return eISLoginAdapter.getPlatformClass();
            }

            protected void setValueOnSubject(Object object) {
                EISLoginAdapter eISLoginAdapter = (EISLoginAdapter)this.subject;
                eISLoginAdapter.setPlatformClass((String)object);
            }
        };
        return new TransformationPropertyValueModel(propertyAspectAdapter){

            protected Object reverseTransform(Object object) {
                if (object == null) {
                    return null;
                }
                return EisPlatformManager.instance().getRuntimePlatformClassNameForClass((String)object);
            }

            protected Object transform(Object object) {
                if (object == null) {
                    return null;
                }
                return ClassTools.shortNameForClassNamed((String)((String)object));
            }
        };
    }

    private ListCellRenderer buildPlatformLabelDecorator() {
        return new SimpleListCellRenderer(){

            protected String buildText(Object object) {
                if (((String)object).equals("AQPlatform")) {
                    return "Oracle AQ";
                }
                if (((String)object).equals("JMSPlatform")) {
                    return "JMS";
                }
                if (((String)object).equals("MQPlatform")) {
                    return "IBM MQSeries";
                }
                return "XML File";
            }
        };
    }

    private ListValueModel buildPlatformListHolder() {
        return new SortedListValueModelAdapter(this.buildPlatformCollectionHolder(), this.buildEisPlatformNameCompator());
    }
}

