/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.login;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseLoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.tools.ClassChooserTools;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

final class StructConvertersPane
extends AbstractSubjectPanel {
    public StructConvertersPane(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super((LayoutManager)new BorderLayout(), (ValueModel)propertyValueModel, workbenchContextHolder);
        this.addHelpTopicId(this, "rdbms.options.structConverters");
    }

    private AddRemovePanel.Adapter buildAddRemoveListPanelAdapter() {
        return new AddRemoveListAdapter();
    }

    private ListValueModel buildStructConverterListHolder() {
        return new ListAspectAdapter(this.getSubjectHolder(), "structConverters"){

            protected ListIterator getValueFromSubject() {
                DatabaseLoginAdapter databaseLoginAdapter = (DatabaseLoginAdapter)this.subject;
                return databaseLoginAdapter.structConvertersClasses();
            }
        };
    }

    private AddRemoveListPanel buildStructConverterListPane() {
        return new CustomizedAddRemoveListPanel();
    }

    protected void initializeLayout() {
        AddRemoveListPanel addRemoveListPanel = this.buildStructConverterListPane();
        addRemoveListPanel.setCellRenderer(new SimpleListCellRenderer());
        addRemoveListPanel.setBorder(BorderFactory.createCompoundBorder(this.buildTitledBorder("OPTIONS_STRUCT_CONVERTER_LIST"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.add((Component)addRemoveListPanel, "Center");
        this.addPaneForAlignment(addRemoveListPanel);
    }

    private class CustomizedAddRemoveListPanel
    extends AddRemoveListPanel {
        private CustomizedAddRemoveListPanel() {
            super(StructConvertersPane.this.getApplicationContext(), StructConvertersPane.this.buildAddRemoveListPanelAdapter(), StructConvertersPane.this.buildStructConverterListHolder(), 3);
        }

        protected String addButtonKey() {
            return "OPTIONS_STRUCT_CONVERTERS_ADD_BUTTON";
        }

        protected void buildButtonPanel(JComponent jComponent, JButton jButton, JButton jButton2, JButton jButton3) {
            jComponent.add(jButton);
            jComponent.add(jButton2);
        }

        protected String removeButtonKey() {
            return "OPTIONS_STRUCT_CONVERTERS_REMOVE_BUTTON";
        }
    }

    private class AddRemoveListAdapter
    implements AddRemovePanel.Adapter {
        private AddRemoveListAdapter() {
        }

        public void addNewItem(ObjectListSelectionModel objectListSelectionModel) {
            DatabaseLoginAdapter databaseLoginAdapter = (DatabaseLoginAdapter)StructConvertersPane.this.subject();
            SimplePropertyValueModel simplePropertyValueModel = new SimplePropertyValueModel();
            ClassChooserTools.promptForType(StructConvertersPane.this.getWorkbenchContext(), databaseLoginAdapter.getClassRepository(), simplePropertyValueModel);
            String string = (String)simplePropertyValueModel.getValue();
            if (string != null && !CollectionTools.contains(databaseLoginAdapter.structConvertersClasses(), (Object)string)) {
                databaseLoginAdapter.addStructConverterClass(string);
            }
        }

        public void removeSelectedItems(ObjectListSelectionModel objectListSelectionModel) {
            DatabaseLoginAdapter databaseLoginAdapter = (DatabaseLoginAdapter)StructConvertersPane.this.subject();
            Object[] objectArray = objectListSelectionModel.getSelectedValues();
            int n = objectArray.length;
            while (--n >= 0) {
                databaseLoginAdapter.removeStructConverterClass((String)objectArray[n]);
            }
        }
    }
}

