/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.tools;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.Nominative;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.project.RenameDialog;
import org.eclipse.persistence.tools.workbench.scplugin.ui.tools.SessionCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public abstract class AbstractSessionsListPane
extends AbstractSubjectPanel {
    protected AbstractSessionsListPane(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super((ValueModel)propertyValueModel, workbenchContextHolder);
    }

    protected abstract void addNewSession();

    private ListCellRenderer buidlAddRemoveListCellRenderer() {
        return new AdaptableListCellRenderer(new SessionCellRendererAdapter(this.resourceRepository()));
    }

    protected AddRemovePanel.Adapter buildAddRemoveListPanelAdapter() {
        return new AddRemoveListAdapter();
    }

    protected PropertyValueModel buildDisplayStringHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "displayString"){

            protected Object getValueFromSubject() {
                Nominative nominative = (Nominative)this.subject;
                return nominative.getName();
            }
        };
    }

    protected PropertyChangeListener buildDisplayStringListener(final TitledBorder titledBorder) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getNewValue() != null) {
                    titledBorder.setTitle(AbstractSessionsListPane.this.resourceRepository().getString("PROJECT_SESSIONS_LIST", propertyChangeEvent.getNewValue()));
                    AbstractSessionsListPane.this.repaint();
                }
            }
        };
    }

    protected AddRemoveListPanel buildSessionListPane() {
        return new CustomizedSessionListPanel();
    }

    protected abstract CollectionValueModel buildSessionsCollectionHolder();

    private ItemPropertyListValueModelAdapter buildSessionsItemListAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildSessionsCollectionHolder(), "name");
    }

    private SortedListValueModelAdapter buildSortedSessionsListHolder() {
        return new SortedListValueModelAdapter(this.buildSessionsItemListAdapter());
    }

    protected boolean canRemoveSessions(Collection collection) {
        return true;
    }

    protected void initializeLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        TitledBorder titledBorder = new TitledBorder("");
        PropertyValueModel propertyValueModel = this.buildDisplayStringHolder();
        propertyValueModel.addPropertyChangeListener("value", this.buildDisplayStringListener(titledBorder));
        titledBorder.setTitle(this.resourceRepository().getString("PROJECT_SESSIONS_LIST", propertyValueModel.getValue()));
        this.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        AddRemoveListPanel addRemoveListPanel = this.buildSessionListPane();
        addRemoveListPanel.setCellRenderer(this.buidlAddRemoveListCellRenderer());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)addRemoveListPanel, gridBagConstraints);
        this.addPaneForAlignment(addRemoveListPanel);
    }

    protected abstract void removeSessions(Collection var1);

    protected void renameSession(SessionAdapter sessionAdapter) {
        TopLinkSessionsAdapter topLinkSessionsAdapter = (TopLinkSessionsAdapter)sessionAdapter.getParent();
        SimplePropertyValueModel simplePropertyValueModel = new SimplePropertyValueModel();
        simplePropertyValueModel.setValue(sessionAdapter.getName());
        RenameDialog renameDialog = new RenameDialog(this.getWorkbenchContext(), simplePropertyValueModel, topLinkSessionsAdapter.getAllSessionsNames());
        renameDialog.setVisible(true);
        if (renameDialog.wasConfirmed()) {
            sessionAdapter.setName((String)simplePropertyValueModel.getValue());
        }
    }

    protected class CustomizedSessionListPanel
    extends AddRemoveListPanel {
        protected CustomizedSessionListPanel() {
            super(AbstractSessionsListPane.this.getApplicationContext(), AbstractSessionsListPane.this.buildAddRemoveListPanelAdapter(), (ListValueModel)AbstractSessionsListPane.this.buildSortedSessionsListHolder(), 3);
        }

        protected String addButtonKey() {
            return "PROJECT_SESSIONS_ADD_BUTTON";
        }

        protected String removeButtonKey() {
            return "PROJECT_SESSIONS_REMOVE_BUTTON";
        }
    }

    protected class AddRemoveListAdapter
    implements AddRemovePanel.OptionAdapter {
        protected AddRemoveListAdapter() {
        }

        public void addNewItem(ObjectListSelectionModel objectListSelectionModel) {
            AbstractSessionsListPane.this.addNewSession();
        }

        public String optionalButtonKey() {
            return "PROJECT_SESSIONS_RENAME_BUTTON";
        }

        public void optionOnSelection(ObjectListSelectionModel objectListSelectionModel) {
            AbstractSessionsListPane.this.renameSession((SessionAdapter)objectListSelectionModel.getSelectedValue());
        }

        public boolean enableOptionOnSelectionChange(ObjectListSelectionModel objectListSelectionModel) {
            return objectListSelectionModel.getSelectedValuesSize() == 1;
        }

        public void removeSelectedItems(ObjectListSelectionModel objectListSelectionModel) {
            Collection collection = CollectionTools.collection((Object[])objectListSelectionModel.getSelectedValues());
            if (AbstractSessionsListPane.this.canRemoveSessions(collection)) {
                AbstractSessionsListPane.this.removeSessions(collection);
            }
        }
    }
}

