/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.tools;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionRepository;
import org.eclipse.persistence.tools.workbench.framework.uitools.CursorConstants;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;

public final class ClassChooserTools {
    public static JButton buildBrowseButton(WorkbenchContextHolder workbenchContextHolder, String string, ValueModel valueModel, PropertyValueModel propertyValueModel) {
        ResourceRepository resourceRepository = workbenchContextHolder.getWorkbenchContext().getApplicationContext().getResourceRepository();
        JButton jButton = new JButton();
        jButton.setText(resourceRepository.getString(string));
        jButton.setMnemonic(resourceRepository.getMnemonic(string));
        jButton.setDisplayedMnemonicIndex(resourceRepository.getMnemonicIndex(string));
        jButton.setName(string);
        BrowseAction browseAction = new BrowseAction(workbenchContextHolder, valueModel, propertyValueModel);
        jButton.addActionListener(browseAction);
        ClassChooserTools.installBrowseButtonEnabler(valueModel, jButton);
        return jButton;
    }

    private static void installBrowseButtonEnabler(ValueModel valueModel, final JButton jButton) {
        valueModel.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                jButton.setEnabled(propertyChangeEvent.getNewValue() != null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void promptForType(WorkbenchContext workbenchContext, ClassDescriptionRepository classDescriptionRepository, PropertyValueModel propertyValueModel) {
        try {
            workbenchContext.getCurrentWindow().setCursor(CursorConstants.WAIT_CURSOR);
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                }
            };
            propertyValueModel.addPropertyChangeListener("value", propertyChangeListener);
            ClassChooserDialog classChooserDialog = ClassChooserDialog.createDialog(classDescriptionRepository, workbenchContext);
            classChooserDialog.setVisible(true);
            if (classChooserDialog.wasConfirmed()) {
                propertyValueModel.setValue(classChooserDialog.selection());
            }
            propertyValueModel.removePropertyChangeListener("value", propertyChangeListener);
        }
        finally {
            workbenchContext.getCurrentWindow().setCursor(CursorConstants.DEFAULT_CURSOR);
        }
    }

    private static class BrowseAction
    implements ActionListener {
        private final ValueModel classRepositoryHolder;
        private final WorkbenchContextHolder contextHolder;
        private final PropertyValueModel selectionHolder;

        private BrowseAction(WorkbenchContextHolder workbenchContextHolder, ValueModel valueModel, PropertyValueModel propertyValueModel) {
            this.classRepositoryHolder = valueModel;
            this.contextHolder = workbenchContextHolder;
            this.selectionHolder = propertyValueModel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ClassChooserTools.promptForType(this.contextHolder.getWorkbenchContext(), (ClassDescriptionRepository)this.classRepositoryHolder.getValue(), this.selectionHolder);
        }
    }
}

