/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.tools;

import javax.swing.Icon;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AbstractCellRendererAdapter;

public final class ConnectionPoolCellRendererAdapter
extends AbstractCellRendererAdapter {
    private final ResourceRepository repository;

    public ConnectionPoolCellRendererAdapter(ResourceRepository resourceRepository) {
        this.repository = resourceRepository;
    }

    private static String buildKey(ConnectionPoolAdapter connectionPoolAdapter) {
        StringBuffer stringBuffer = new StringBuffer("CONNECTION_POOL");
        if (connectionPoolAdapter.isReadConnectionPool()) {
            stringBuffer.append("_READ");
        } else if (connectionPoolAdapter.isSequenceConnectionPool()) {
            stringBuffer.append("_SEQUENCE");
        } else if (connectionPoolAdapter.isWriteConnectionPool()) {
            stringBuffer.append("_WRITE");
        }
        return stringBuffer.toString();
    }

    public static String iconKey(ConnectionPoolAdapter connectionPoolAdapter) {
        return ConnectionPoolCellRendererAdapter.buildKey(connectionPoolAdapter);
    }

    public String buildAccessibleName(Object object) {
        ConnectionPoolAdapter connectionPoolAdapter = (ConnectionPoolAdapter)object;
        String string = ConnectionPoolCellRendererAdapter.buildKey(connectionPoolAdapter);
        return this.repository.getString(string, connectionPoolAdapter.displayString());
    }

    public Icon buildIcon(Object object) {
        ConnectionPoolAdapter connectionPoolAdapter = (ConnectionPoolAdapter)object;
        return this.repository.getIcon(ConnectionPoolCellRendererAdapter.iconKey(connectionPoolAdapter));
    }

    public String buildText(Object object) {
        ConnectionPoolAdapter connectionPoolAdapter = (ConnectionPoolAdapter)object;
        String string = ConnectionPoolCellRendererAdapter.buildKey(connectionPoolAdapter);
        return this.repository.getString(string, connectionPoolAdapter.displayString());
    }
}

