/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.tools;

import java.text.ParseException;
import java.util.StringTokenizer;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class IPAddress {
    private final String ipAddress;
    private final int[] ipAddresses;

    public IPAddress() {
        this.ipAddress = "0.0.0.0";
        this.ipAddresses = new int[4];
    }

    public IPAddress(int[] nArray) throws ParseException {
        if (nArray == null) {
            this.ipAddress = "0.0.0.0";
            this.ipAddresses = new int[4];
        } else {
            this.ipAddress = IPAddress.convert(nArray);
            this.ipAddresses = nArray;
        }
    }

    public IPAddress(String string) throws ParseException {
        if (string == null) {
            this.ipAddress = "0.0.0.0";
            this.ipAddresses = new int[4];
        } else {
            this.ipAddress = string;
            this.ipAddresses = IPAddress.convert(string);
        }
    }

    public static String convert(int[] nArray) throws ParseException {
        if (nArray == null) {
            throw new ParseException("The array of integers cannot be null", 0);
        }
        if (nArray.length != 4) {
            throw new ParseException("The array does not have a length of 4", 0);
        }
        if (!IPAddress.isValid(nArray)) {
            throw new ParseException("The values are not in the range [0, 255]", 0);
        }
        StringBuffer stringBuffer = new StringBuffer(15);
        stringBuffer.append(nArray[0]);
        stringBuffer.append(".");
        stringBuffer.append(nArray[1]);
        stringBuffer.append(".");
        stringBuffer.append(nArray[2]);
        stringBuffer.append(".");
        stringBuffer.append(nArray[3]);
        return stringBuffer.toString();
    }

    public static int[] convert(String string) throws ParseException {
        if (string == null) {
            throw new ParseException("The value cannot be null", 0);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            throw new ParseException("The IP address is not valid, it does not have 4 sets of digits", 0);
        }
        int[] nArray = new int[4];
        try {
            for (int i = 0; i < 4; ++i) {
                nArray[i] = new Integer(stringTokenizer.nextToken());
            }
        }
        catch (Throwable throwable) {
            throw new ParseException("The IP address is not valid, then cannot be converted into an array of integers", 0);
        }
        if (!IPAddress.isValid(nArray)) {
            throw new ParseException("The values are not in the range [0, 255]", 0);
        }
        return nArray;
    }

    public static boolean isValid(int[] nArray) {
        if (nArray == null || nArray.length != 4) {
            return false;
        }
        int n = nArray.length;
        while (--n >= 0) {
            if (nArray[n] >= 0 && nArray[n] <= 255) continue;
            return false;
        }
        return true;
    }

    public static boolean isValid(String string) {
        try {
            return IPAddress.isValid(IPAddress.convert(string));
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public int[] ipAddresses() {
        return this.ipAddresses;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        StringTools.buildSimpleToStringOn((Object)this, (StringBuffer)stringBuffer);
        stringBuffer.append(" (");
        this.toString(stringBuffer);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append("ipAddress=");
        stringBuffer.append(this.ipAddress);
    }
}

