/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.tools;

import javax.swing.Icon;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionBrokerAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AbstractCellRendererAdapter;

public final class SessionCellRendererAdapter
extends AbstractCellRendererAdapter {
    private final String prefixKey;
    private final ResourceRepository repository;

    public SessionCellRendererAdapter(ResourceRepository resourceRepository) {
        this(resourceRepository, "PROJECT_SESSIONS_SESSION_TYPE");
    }

    public SessionCellRendererAdapter(ResourceRepository resourceRepository, String string) {
        this.repository = resourceRepository;
        this.prefixKey = string;
    }

    private static String buildKey(SessionAdapter sessionAdapter, String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (sessionAdapter instanceof ServerSessionAdapter) {
            stringBuffer.append("_SERVER");
        } else if (sessionAdapter instanceof DatabaseSessionAdapter) {
            stringBuffer.append("_DATABASE");
        } else if (sessionAdapter instanceof SessionBrokerAdapter) {
            stringBuffer.append("_BROKER");
        }
        if (sessionAdapter.platformIsXml()) {
            stringBuffer.append("_XML");
        } else if (sessionAdapter.platformIsRdbms()) {
            stringBuffer.append("_RDBMS");
        } else if (sessionAdapter.platformIsEis()) {
            stringBuffer.append("_EIS");
        }
        return stringBuffer.toString();
    }

    public static String iconKey(SessionAdapter sessionAdapter) {
        return SessionCellRendererAdapter.buildKey(sessionAdapter, "SESSION");
    }

    public String buildAccessibleName(Object object) {
        SessionAdapter sessionAdapter = (SessionAdapter)object;
        String string = SessionCellRendererAdapter.buildKey(sessionAdapter, "SESSION_DISPLAY_STRING_TITLE_BAR");
        return this.repository.getString(string, sessionAdapter.displayString(), sessionAdapter.getDataSourceName());
    }

    public Icon buildIcon(Object object) {
        SessionAdapter sessionAdapter = (SessionAdapter)object;
        return this.repository.getIcon(SessionCellRendererAdapter.iconKey(sessionAdapter));
    }

    public String buildText(Object object) {
        SessionAdapter sessionAdapter = (SessionAdapter)object;
        String string = SessionCellRendererAdapter.buildKey(sessionAdapter, this.prefixKey);
        return this.repository.getString(string, sessionAdapter.displayString(), sessionAdapter.getDataSourceName());
    }
}

