/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools;

import java.awt.Color;
import java.awt.Dimension;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.BoxView;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class LabelArea
extends JLabel {
    private boolean locked;
    private String originalText;
    private int preferredWidth = 300;
    private boolean scrollable;
    public static final int PREFERRED_WIDTH = 300;

    public LabelArea() {
    }

    public LabelArea(Icon icon) {
        super(icon);
    }

    public LabelArea(Icon icon, int n) {
        super(icon, n);
    }

    public LabelArea(String string) {
        super(string);
    }

    public LabelArea(String string, Icon icon, int n) {
        super(string, icon, n);
    }

    public LabelArea(String string, int n) {
        super(string, n);
    }

    private String convertToHTML() {
        if (StringTools.stringIsEmpty((String)this.originalText) || BasicHTML.isHTMLString(this.originalText)) {
            return this.originalText;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<HTML><BODY");
        if (!this.isEnabled()) {
            Class[] classArray = new Class[]{Color.class};
            Object[] objectArray = new Object[]{this.getBackground().darker()};
            String string = (String)ClassTools.invokeStaticMethod(CSS.class, (String)"colorToHex", (Class[])classArray, (Object[])objectArray);
            stringBuilder.append(" TEXT=\"");
            stringBuilder.append(string);
            stringBuilder.append("\"");
        }
        stringBuilder.append(">");
        int n = this.getDisplayedMnemonicIndex();
        if (n > -1) {
            stringBuilder.append(this.originalText.substring(0, n));
            stringBuilder.append("<U>");
            stringBuilder.append(this.originalText.charAt(n));
            stringBuilder.append("</U>");
            stringBuilder.append(this.originalText.substring(n + 1));
        } else {
            stringBuilder.append(this.originalText);
        }
        stringBuilder.append("</BODY></HTML>");
        return stringBuilder.toString();
    }

    private int findDisplayedMnemonicIndex() {
        int n = this.getDisplayedMnemonic();
        if (this.originalText == null || n == 0) {
            return -1;
        }
        char c = Character.toUpperCase((char)n);
        char c2 = Character.toLowerCase((char)n);
        int n2 = this.originalText.indexOf(c);
        int n3 = this.originalText.indexOf(c2);
        if (n2 == -1) {
            return n3;
        }
        if (n3 == -1) {
            return n2;
        }
        return n3 < n2 ? n3 : n2;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleLabelArea();
        }
        return this.accessibleContext;
    }

    public String getOriginalText() {
        return this.originalText;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        View view = (View)this.getClientProperty("html");
        if (view != null && !this.isPreferredSizeSet()) {
            BoxView boxView = (BoxView)view.getView(0);
            if (this.scrollable) {
                int n = (int)view.getMinimumSpan(0);
                int n2 = (int)view.getMinimumSpan(1);
                Dimension dimension = super.getPreferredSize();
                dimension.width = Math.min(n, dimension.width);
                dimension.height = Math.max(n2, dimension.height);
                return dimension;
            }
            float f = Math.min((int)boxView.getPreferredSpan(0), this.preferredWidth);
            boxView.setSize(f, 0.0f);
            float f2 = boxView.getPreferredSpan(1);
            view.setSize(f, f2);
        }
        return super.getPreferredSize();
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayedMnemonicIndex(int n) throws IllegalArgumentException {
        if (this.locked) {
            return;
        }
        try {
            this.locked = true;
            super.setDisplayedMnemonicIndex(n);
        }
        finally {
            this.locked = false;
        }
        this.setText(this.originalText);
    }

    public void setPreferredWidth(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Preferred width cannot be negative");
        }
        this.preferredWidth = n;
    }

    public void setScrollable(boolean bl) {
        this.scrollable = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String string) {
        this.originalText = string;
        string = this.convertToHTML();
        try {
            this.locked = true;
            super.setText(string);
            super.setDisplayedMnemonicIndex(this.findDisplayedMnemonicIndex());
        }
        finally {
            this.locked = false;
        }
    }

    protected class AccessibleLabelArea
    extends JLabel.AccessibleJLabel {
        protected AccessibleLabelArea() {
            super(LabelArea.this);
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (LabelArea.this.originalText == null) {
                return null;
            }
            return LabelArea.this.originalText.replaceAll("<[Bb][Rr](\\s)?(/)?>|<(/)?[Pp]>", " ");
        }
    }
}

