/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JWindow;

public final class SplashScreen
extends JWindow
implements Runnable {
    private Thread thread;
    private int timeout;

    public SplashScreen(Frame frame, String string, Icon icon, int n) {
        super(frame);
        this.timeout = n;
        this.initialize(string, icon);
    }

    public SplashScreen(Frame frame, String string, Icon icon) {
        this(frame, string, icon, 0);
    }

    public SplashScreen(Frame frame, Icon icon) {
        this(frame, "", icon);
    }

    private void initialize(String string, Icon icon) {
        JLabel jLabel = new JLabel(string, 2);
        jLabel.setFont(new Font("dialog", 0, 12));
        int n = jLabel.getPreferredSize().width;
        int n2 = jLabel.getPreferredSize().height;
        JLabel jLabel2 = new JLabel(icon);
        int n3 = icon.getIconWidth();
        int n4 = icon.getIconHeight();
        jLabel2.setBounds(0, 0, n3, n4);
        jLabel.setBounds(10, n4 - 26, n, n2);
        this.getContentPane().add(jLabel);
        this.getContentPane().add(jLabel2);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n5 = (dimension.width - n3) / 2;
        int n6 = (dimension.height - n4) / 2;
        this.setBounds(n5, n6, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.setVisible(true);
        SplashScreen splashScreen = this;
        synchronized (splashScreen) {
            try {
                this.wait(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    public synchronized void start() {
        if (this.thread != null) {
            throw new IllegalStateException("splash screen is already started");
        }
        this.thread = new Thread((Runnable)this, "Splash Screen");
        this.thread.start();
    }

    public synchronized void stop() {
        if (this.thread == null) {
            throw new IllegalStateException("splash screen is not started");
        }
        if (this.thread.isAlive()) {
            this.thread.interrupt();
        }
    }
}

