/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.SynchronizedBoolean;
import org.eclipse.persistence.tools.workbench.utility.iterators.ArrayIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

public class ThreadBrowser {
    private DefaultTreeModel treeModel;
    private JTree tree;
    private SynchronizedBoolean synchronizedAutoRefresh;
    private Thread autoRefreshThread;
    private JFrame browser;
    private static final ThreadGroup[] EMPTY_GROUPS = new ThreadGroup[0];
    private static final Comparator THREAD_GROUP_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return Collator.getInstance().compare(((ThreadGroup)object).getName(), ((ThreadGroup)object2).getName());
        }
    };
    private static final Thread[] EMPTY_THREADS = new Thread[0];
    private static final Comparator THREAD_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return Collator.getInstance().compare(((Thread)object).getName(), ((Thread)object2).getName());
        }
    };

    public static void main(String[] stringArray) throws Exception {
        new ThreadBrowser().exec(stringArray);
    }

    public ThreadBrowser() {
        this.initialize();
    }

    private void initialize() {
        this.treeModel = this.buildTreeModel();
        this.tree = this.buildTree();
        this.expandAll();
        this.synchronizedAutoRefresh = new SynchronizedBoolean(false);
        this.autoRefreshThread = this.buildAutoRefreshThread();
        this.autoRefreshThread.start();
        this.browser = this.buildBrowser();
    }

    private Thread buildAutoRefreshThread() {
        return new Thread(this.buildAutoRefreshRunnable(), "Thread Browser Auto-Refresh");
    }

    private Runnable buildAutoRefreshRunnable() {
        return new AutoRefreshRunnable(this.synchronizedAutoRefresh, this.buildRefreshRunnable());
    }

    private Runnable buildRefreshRunnable() {
        return new Runnable(){

            public void run() {
                ThreadBrowser.this.refresh();
            }
        };
    }

    private DefaultTreeModel buildTreeModel() {
        return new DefaultTreeModel(this.buildRootNode(), true);
    }

    private TreeNode buildRootNode() {
        return this.buildTreeNode(this.systemRootThreadGroup());
    }

    private ThreadGroup systemRootThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        ThreadGroup threadGroup2 = threadGroup.getParent();
        while (threadGroup2 != null) {
            threadGroup = threadGroup2;
            threadGroup2 = threadGroup.getParent();
        }
        return threadGroup;
    }

    private DefaultMutableTreeNode buildTreeNode(ThreadGroup threadGroup) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(threadGroup, true);
        ThreadGroup[] threadGroupArray = this.subGroupsOf(threadGroup);
        for (int i = 0; i < threadGroupArray.length; ++i) {
            defaultMutableTreeNode.add(this.buildTreeNode(threadGroupArray[i]));
        }
        Thread[] threadArray = this.threadsOf(threadGroup);
        for (int i = 0; i < threadArray.length; ++i) {
            defaultMutableTreeNode.add(this.buildTreeNode(threadArray[i]));
        }
        return defaultMutableTreeNode;
    }

    private ThreadGroup[] subGroupsOf(ThreadGroup threadGroup) {
        ThreadGroup[] threadGroupArray;
        int n;
        int n2 = threadGroup.activeGroupCount();
        if (n2 == 0) {
            return EMPTY_GROUPS;
        }
        while ((n2 += n2) <= (n = threadGroup.enumerate(threadGroupArray = new ThreadGroup[n2], false))) {
        }
        ThreadGroup[] threadGroupArray2 = new ThreadGroup[n];
        System.arraycopy(threadGroupArray, 0, threadGroupArray2, 0, n);
        Arrays.sort(threadGroupArray2, THREAD_GROUP_COMPARATOR);
        return threadGroupArray2;
    }

    private Thread[] threadsOf(ThreadGroup threadGroup) {
        Thread[] threadArray;
        int n;
        int n2 = threadGroup.activeCount();
        if (n2 == 0) {
            return EMPTY_THREADS;
        }
        while ((n2 += n2) <= (n = threadGroup.enumerate(threadArray = new Thread[n2], false))) {
        }
        Thread[] threadArray2 = new Thread[n];
        System.arraycopy(threadArray, 0, threadArray2, 0, n);
        Arrays.sort(threadArray2, THREAD_COMPARATOR);
        return threadArray2;
    }

    private DefaultMutableTreeNode buildTreeNode(Thread thread) {
        return new DefaultMutableTreeNode(thread, false);
    }

    private JTree buildTree() {
        LocalTree localTree = new LocalTree(this.treeModel);
        localTree.setRootVisible(true);
        localTree.setShowsRootHandles(true);
        localTree.setRowHeight(20);
        localTree.setDoubleBuffered(true);
        return localTree;
    }

    private JFrame buildBrowser() {
        JFrame jFrame = new JFrame("Thread Browser");
        jFrame.setDefaultCloseOperation(2);
        jFrame.getContentPane().add(this.buildMainPanel(), "Center");
        jFrame.setLocation(300, 300);
        jFrame.setSize(400, 400);
        jFrame.addWindowListener(this.buildWindowListener());
        return jFrame;
    }

    private Component buildMainPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this.buildTreePane(), "Center");
        jPanel.add(this.buildControlPanel(), "South");
        return jPanel;
    }

    private Component buildTreePane() {
        return new JScrollPane(this.tree);
    }

    private Component buildControlPanel() {
        GridLayout gridLayout = new GridLayout(1, 0);
        gridLayout.setHgap(5);
        JPanel jPanel = new JPanel(gridLayout);
        jPanel.add(this.buildDumpSelectedGroupsButton());
        jPanel.add(this.buildRefreshButton());
        jPanel.add(this.buildAutoRefreshCheckBox());
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        return jPanel;
    }

    private WindowListener buildWindowListener() {
        return new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                super.windowClosed(windowEvent);
                ThreadBrowser.this.interruptAutoRefreshThread();
            }
        };
    }

    private JButton buildDumpSelectedGroupsButton() {
        return new JButton(this.buildDumpSelectedGroupsAction());
    }

    private Action buildDumpSelectedGroupsAction() {
        AbstractAction abstractAction = new AbstractAction("dump"){

            public void actionPerformed(ActionEvent actionEvent) {
                ThreadBrowser.this.dumpSelectedGroups();
            }
        };
        abstractAction.setEnabled(true);
        return abstractAction;
    }

    void dumpSelectedGroups() {
        Iterator iterator = this.selectedThreadGroups();
        while (iterator.hasNext()) {
            ((ThreadGroup)iterator.next()).list();
        }
    }

    private JButton buildRefreshButton() {
        return new JButton(this.buildRefreshAction());
    }

    private Action buildRefreshAction() {
        AbstractAction abstractAction = new AbstractAction("refresh"){

            public void actionPerformed(ActionEvent actionEvent) {
                ThreadBrowser.this.refresh();
            }
        };
        abstractAction.setEnabled(true);
        return abstractAction;
    }

    void refresh() {
        this.hook();
        this.treeModel.setRoot(this.buildRootNode());
        this.expandAll();
    }

    private void hook() {
    }

    private JCheckBox buildAutoRefreshCheckBox() {
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setText("auto refresh");
        jCheckBox.setHorizontalAlignment(0);
        SimplePropertyValueModel simplePropertyValueModel = new SimplePropertyValueModel(this.synchronizedAutoRefresh.getValue());
        simplePropertyValueModel.addPropertyChangeListener("value", this.buildAutoRefreshListener());
        jCheckBox.setModel(new CheckBoxModelAdapter(simplePropertyValueModel));
        return jCheckBox;
    }

    private PropertyChangeListener buildAutoRefreshListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ThreadBrowser.this.setAutoRefresh((Boolean)propertyChangeEvent.getNewValue());
            }
        };
    }

    private Iterator threadGroupPaths() {
        ArrayList arrayList = new ArrayList();
        this.addThreadGroupPathsTo((DefaultMutableTreeNode)this.treeModel.getRoot(), arrayList);
        return arrayList.iterator();
    }

    private Iterator selectedThreadGroups() {
        return new FilteringIterator(this.selectedValues()){

            protected boolean accept(Object object) {
                return object instanceof ThreadGroup;
            }
        };
    }

    private Iterator selectedValues() {
        return new TransformationIterator(this.selectedPaths()){

            protected Object transform(Object object) {
                return ((DefaultMutableTreeNode)((TreePath)object).getLastPathComponent()).getUserObject();
            }
        };
    }

    private Iterator selectedPaths() {
        Object[] objectArray = this.tree.getSelectionPaths();
        return objectArray == null ? NullIterator.instance() : new ArrayIterator(objectArray);
    }

    private void exec(String[] stringArray) throws Exception {
        this.browser.setDefaultCloseOperation(3);
        this.open();
    }

    public void open() {
        this.browser.setVisible(true);
    }

    private void expandAll() {
        Iterator iterator = this.threadGroupPaths();
        while (iterator.hasNext()) {
            this.tree.expandPath((TreePath)iterator.next());
        }
    }

    private void addThreadGroupPathsTo(DefaultMutableTreeNode defaultMutableTreeNode, Collection collection) {
        if (defaultMutableTreeNode.getUserObject() instanceof ThreadGroup) {
            collection.add(new TreePath(defaultMutableTreeNode.getPath()));
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                this.addThreadGroupPathsTo(defaultMutableTreeNode2, collection);
            }
        }
    }

    void setAutoRefresh(boolean bl) {
        this.synchronizedAutoRefresh.setValue(bl);
    }

    void interruptAutoRefreshThread() {
        this.autoRefreshThread.interrupt();
    }

    private static class AutoRefreshRunnable
    implements Runnable {
        private SynchronizedBoolean synchronizedAutoRefresh;
        private Runnable refreshRunnable;

        AutoRefreshRunnable(SynchronizedBoolean synchronizedBoolean, Runnable runnable) {
            this.synchronizedAutoRefresh = synchronizedBoolean;
            this.refreshRunnable = runnable;
        }

        public void run() {
            while (true) {
                try {
                    Thread.sleep(5000L);
                    this.synchronizedAutoRefresh.waitUntilTrue();
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                EventQueue.invokeLater(this.refreshRunnable);
            }
        }
    }

    private static class LocalTree
    extends JTree {
        LocalTree(TreeModel treeModel) {
            super(treeModel);
        }

        public String convertValueToText(Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof Thread) {
                return this.convertToText((Thread)object2);
            }
            return this.convertToText((ThreadGroup)object2);
        }

        private String convertToText(Thread thread) {
            StringBuffer stringBuffer = new StringBuffer();
            if (thread == Thread.currentThread()) {
                stringBuffer.append('*');
            }
            stringBuffer.append(thread.getName());
            stringBuffer.append(" [priority=");
            stringBuffer.append(thread.getPriority());
            stringBuffer.append("]");
            if (thread.isDaemon()) {
                stringBuffer.append(" - daemon");
            }
            return stringBuffer.toString();
        }

        private String convertToText(ThreadGroup threadGroup) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(threadGroup.getName());
            stringBuffer.append(" [max priority=");
            stringBuffer.append(threadGroup.getMaxPriority());
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }
}

