/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeListener;
import org.eclipse.persistence.tools.workbench.utility.iterators.ChainIterator;

public abstract class AbstractTreeNodeValueModel
extends AbstractModel
implements TreeNodeValueModel {
    protected AbstractTreeNodeValueModel() {
    }

    protected ChangeSupport buildDefaultChangeSupport() {
        return super.buildDefaultChangeSupport();
    }

    public void addStateChangeListener(StateChangeListener stateChangeListener) {
        if (this.hasNoStateChangeListeners()) {
            this.engageValue();
        }
        super.addStateChangeListener(stateChangeListener);
    }

    protected abstract void engageValue();

    public void removeStateChangeListener(StateChangeListener stateChangeListener) {
        super.removeStateChangeListener(stateChangeListener);
        if (this.hasNoStateChangeListeners()) {
            this.disengageValue();
        }
    }

    protected abstract void disengageValue();

    public void setValue(Object object) {
        throw new UnsupportedOperationException();
    }

    public TreeNodeValueModel[] path() {
        List list = CollectionTools.reverseList((Iterator)this.backPath());
        return list.toArray(new TreeNodeValueModel[list.size()]);
    }

    protected Iterator backPath() {
        return new ChainIterator(this){

            protected Object nextLink(Object object) {
                return ((TreeNodeValueModel)object).getParent();
            }
        };
    }

    public TreeNodeValueModel getChild(int n) {
        return (TreeNodeValueModel)this.getChildrenModel().getItem(n);
    }

    public int childrenSize() {
        return this.getChildrenModel().size();
    }

    public int indexOfChild(TreeNodeValueModel treeNodeValueModel) {
        ListValueModel listValueModel = this.getChildrenModel();
        int n = listValueModel.size();
        for (int i = 0; i < n; ++i) {
            if (listValueModel.getItem(i) != treeNodeValueModel) continue;
            return i;
        }
        return -1;
    }

    public boolean isLeaf() {
        return this.getChildrenModel().size() == 0;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        AbstractTreeNodeValueModel abstractTreeNodeValueModel = (AbstractTreeNodeValueModel)object;
        return this.getValue().equals(abstractTreeNodeValueModel.getValue());
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.getValue());
    }
}

