/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModelChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.TreeChangeListener;

public abstract class AspectAdapter
extends AbstractModel
implements ValueModel {
    protected Object subject;
    protected ValueModel subjectHolder;
    protected PropertyChangeListener subjectChangeListener;

    protected AspectAdapter(Object object) {
        this(new ReadOnlyPropertyValueModel(object));
    }

    protected AspectAdapter(ValueModel valueModel) {
        if (valueModel == null) {
            throw new NullPointerException();
        }
        this.subjectHolder = valueModel;
        this.subject = null;
    }

    protected void initialize() {
        super.initialize();
        this.subjectChangeListener = this.buildSubjectChangeListener();
    }

    protected ChangeSupport buildDefaultChangeSupport() {
        return new ValueModelChangeSupport(this);
    }

    protected PropertyChangeListener buildSubjectChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AspectAdapter.this.subjectChanged();
            }

            public String toString() {
                return "subject change listener";
            }
        };
    }

    protected synchronized void subjectChanged() {
        Object object = this.getValue();
        boolean bl = this.hasListeners();
        if (bl) {
            this.disengageSubject();
        }
        this.subject = this.subjectHolder.getValue();
        if (bl) {
            this.engageSubject();
            this.fireAspectChange(object, this.getValue());
        }
    }

    protected abstract boolean hasListeners();

    protected boolean hasNoListeners() {
        return !this.hasListeners();
    }

    protected abstract void fireAspectChange(Object var1, Object var2);

    protected abstract void engageNonNullSubject();

    protected void engageSubject() {
        if (this.subject != null) {
            this.engageNonNullSubject();
        }
    }

    protected abstract void disengageNonNullSubject();

    protected void disengageSubject() {
        if (this.subject != null) {
            this.disengageNonNullSubject();
        }
    }

    protected void engageSubjectHolder() {
        this.subjectHolder.addPropertyChangeListener("value", this.subjectChangeListener);
        this.subject = this.subjectHolder.getValue();
    }

    protected void disengageSubjectHolder() {
        this.subjectHolder.removePropertyChangeListener("value", this.subjectChangeListener);
        this.subject = null;
    }

    protected void engageModels() {
        this.engageSubjectHolder();
        this.engageSubject();
    }

    protected void disengageModels() {
        this.disengageSubject();
        this.disengageSubjectHolder();
    }

    public synchronized void addStateChangeListener(StateChangeListener stateChangeListener) {
        if (this.hasNoListeners()) {
            this.engageModels();
        }
        super.addStateChangeListener(stateChangeListener);
    }

    public synchronized void removeStateChangeListener(StateChangeListener stateChangeListener) {
        super.removeStateChangeListener(stateChangeListener);
        if (this.hasNoListeners()) {
            this.disengageModels();
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.hasNoListeners()) {
            this.engageModels();
        }
        super.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (string == "value" && this.hasNoListeners()) {
            this.engageModels();
        }
        super.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        if (this.hasNoListeners()) {
            this.disengageModels();
        }
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(string, propertyChangeListener);
        if (string == "value" && this.hasNoListeners()) {
            this.disengageModels();
        }
    }

    public synchronized void addCollectionChangeListener(CollectionChangeListener collectionChangeListener) {
        if (this.hasNoListeners()) {
            this.engageModels();
        }
        super.addCollectionChangeListener(collectionChangeListener);
    }

    public synchronized void addCollectionChangeListener(String string, CollectionChangeListener collectionChangeListener) {
        if (string == "value" && this.hasNoListeners()) {
            this.engageModels();
        }
        super.addCollectionChangeListener(string, collectionChangeListener);
    }

    public synchronized void removeCollectionChangeListener(CollectionChangeListener collectionChangeListener) {
        super.removeCollectionChangeListener(collectionChangeListener);
        if (this.hasNoListeners()) {
            this.disengageModels();
        }
    }

    public synchronized void removeCollectionChangeListener(String string, CollectionChangeListener collectionChangeListener) {
        super.removeCollectionChangeListener(string, collectionChangeListener);
        if (string == "value" && this.hasNoListeners()) {
            this.disengageModels();
        }
    }

    public synchronized void addListChangeListener(ListChangeListener listChangeListener) {
        if (this.hasNoListeners()) {
            this.engageModels();
        }
        super.addListChangeListener(listChangeListener);
    }

    public synchronized void addListChangeListener(String string, ListChangeListener listChangeListener) {
        if (string == "value" && this.hasNoListeners()) {
            this.engageModels();
        }
        super.addListChangeListener(string, listChangeListener);
    }

    public synchronized void removeListChangeListener(ListChangeListener listChangeListener) {
        super.removeListChangeListener(listChangeListener);
        if (this.hasNoListeners()) {
            this.disengageModels();
        }
    }

    public synchronized void removeListChangeListener(String string, ListChangeListener listChangeListener) {
        super.removeListChangeListener(string, listChangeListener);
        if (string == "value" && this.hasNoListeners()) {
            this.disengageModels();
        }
    }

    public synchronized void addTreeChangeListener(TreeChangeListener treeChangeListener) {
        if (this.hasNoListeners()) {
            this.engageModels();
        }
        super.addTreeChangeListener(treeChangeListener);
    }

    public synchronized void addTreeChangeListener(String string, TreeChangeListener treeChangeListener) {
        if (string == "value" && this.hasNoListeners()) {
            this.engageModels();
        }
        super.addTreeChangeListener(string, treeChangeListener);
    }

    public synchronized void removeTreeChangeListener(TreeChangeListener treeChangeListener) {
        super.removeTreeChangeListener(treeChangeListener);
        if (this.hasNoListeners()) {
            this.disengageModels();
        }
    }

    public synchronized void removeTreeChangeListener(String string, TreeChangeListener treeChangeListener) {
        super.removeTreeChangeListener(string, treeChangeListener);
        if (string == "value" && this.hasNoListeners()) {
            this.disengageModels();
        }
    }
}

