/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModelChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;
import org.eclipse.persistence.tools.workbench.utility.iterators.ReadOnlyListIterator;

public class CollectionListValueModelAdapter
extends AbstractModel
implements ListValueModel {
    protected CollectionValueModel collectionHolder;
    protected CollectionChangeListener collectionChangeListener;
    protected ArrayList list;

    public CollectionListValueModelAdapter(CollectionValueModel collectionValueModel) {
        if (collectionValueModel == null) {
            throw new NullPointerException();
        }
        this.collectionHolder = collectionValueModel;
    }

    protected void initialize() {
        super.initialize();
        this.collectionChangeListener = this.buildCollectionChangeListener();
        this.list = new ArrayList();
    }

    protected ChangeSupport buildDefaultChangeSupport() {
        return new ValueModelChangeSupport(this);
    }

    protected CollectionChangeListener buildCollectionChangeListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent collectionChangeEvent) {
                CollectionListValueModelAdapter.this.itemsAdded(collectionChangeEvent);
            }

            public void itemsRemoved(CollectionChangeEvent collectionChangeEvent) {
                CollectionListValueModelAdapter.this.itemsRemoved(collectionChangeEvent);
            }

            public void collectionChanged(CollectionChangeEvent collectionChangeEvent) {
                CollectionListValueModelAdapter.this.collectionChanged(collectionChangeEvent);
            }

            public String toString() {
                return "collection change listener";
            }
        };
    }

    public Object getValue() {
        return new ReadOnlyListIterator((List)this.list);
    }

    public void addItem(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public void addItems(int n, List list) {
        throw new UnsupportedOperationException();
    }

    public Object removeItem(int n) {
        throw new UnsupportedOperationException();
    }

    public List removeItems(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public Object replaceItem(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public List replaceItems(int n, List list) {
        throw new UnsupportedOperationException();
    }

    public Object getItem(int n) {
        return this.list.get(n);
    }

    public int size() {
        return this.list.size();
    }

    public void addListChangeListener(ListChangeListener listChangeListener) {
        if (this.hasNoListeners()) {
            this.engageModel();
        }
        super.addListChangeListener(listChangeListener);
    }

    public void addListChangeListener(String string, ListChangeListener listChangeListener) {
        if (string == "value" && this.hasNoListeners()) {
            this.engageModel();
        }
        super.addListChangeListener(string, listChangeListener);
    }

    public void removeListChangeListener(ListChangeListener listChangeListener) {
        super.removeListChangeListener(listChangeListener);
        if (this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    public void removeListChangeListener(String string, ListChangeListener listChangeListener) {
        super.removeListChangeListener(string, listChangeListener);
        if (string == "value" && this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    protected boolean hasListeners() {
        return this.hasAnyListChangeListeners("value");
    }

    protected boolean hasNoListeners() {
        return !this.hasListeners();
    }

    protected int lastIdentityIndexOf(Object object) {
        return this.lastIdentityIndexOf(object, this.list.size());
    }

    protected int lastIdentityIndexOf(Object object, int n) {
        int n2 = n;
        while (n2-- > 0) {
            if (this.list.get(n2) != object) continue;
            return n2;
        }
        return -1;
    }

    protected void buildList() {
        Iterator iterator = (Iterator)this.collectionHolder.getValue();
        if (iterator.hasNext()) {
            this.list.ensureCapacity(this.collectionHolder.size());
            while (iterator.hasNext()) {
                this.list.add(iterator.next());
            }
            this.postBuildList();
        }
    }

    protected void postBuildList() {
    }

    protected void engageModel() {
        this.collectionHolder.addCollectionChangeListener("value", this.collectionChangeListener);
        this.buildList();
    }

    protected void disengageModel() {
        this.collectionHolder.removeCollectionChangeListener("value", this.collectionChangeListener);
        this.list.clear();
    }

    protected void itemsAdded(CollectionChangeEvent collectionChangeEvent) {
        List list = CollectionTools.list((Iterator)collectionChangeEvent.items());
        int n = this.indexToAddItems();
        this.list.addAll(n, list);
        this.fireItemsAdded("value", n, list);
    }

    protected int indexToAddItems() {
        return this.list.size();
    }

    protected void itemsRemoved(CollectionChangeEvent collectionChangeEvent) {
        Iterator iterator = collectionChangeEvent.items();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            int n = this.lastIdentityIndexOf(e);
            this.list.remove(n);
            this.fireItemRemoved("value", n, e);
        }
    }

    protected void collectionChanged(CollectionChangeEvent collectionChangeEvent) {
        if (!this.list.isEmpty()) {
            ArrayList arrayList = this.list;
            this.list = new ArrayList();
            this.fireItemsRemoved("value", 0, arrayList);
        }
        this.buildList();
        if (!this.list.isEmpty()) {
            this.fireItemsAdded("value", 0, this.list);
        }
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.collectionHolder);
    }
}

