/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.beans.PropertyChangeListener;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModelChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;

public abstract class CollectionPropertyValueModelAdapter
extends AbstractModel
implements PropertyValueModel {
    protected Object value;
    protected CollectionValueModel collectionHolder;
    protected CollectionChangeListener collectionChangeListener;

    protected CollectionPropertyValueModelAdapter(CollectionValueModel collectionValueModel) {
        this.collectionHolder = collectionValueModel;
    }

    protected void initialize() {
        super.initialize();
        this.value = null;
        this.collectionChangeListener = this.buildCollectionChangeListener();
    }

    protected ChangeSupport buildDefaultChangeSupport() {
        return new ValueModelChangeSupport(this);
    }

    protected CollectionChangeListener buildCollectionChangeListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent collectionChangeEvent) {
                CollectionPropertyValueModelAdapter.this.itemsAdded(collectionChangeEvent);
            }

            public void itemsRemoved(CollectionChangeEvent collectionChangeEvent) {
                CollectionPropertyValueModelAdapter.this.itemsRemoved(collectionChangeEvent);
            }

            public void collectionChanged(CollectionChangeEvent collectionChangeEvent) {
                CollectionPropertyValueModelAdapter.this.collectionChanged(collectionChangeEvent);
            }

            public String toString() {
                return "collection change listener";
            }
        };
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        throw new UnsupportedOperationException();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.hasNoListeners()) {
            this.engageModel();
        }
        super.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (string == "value" && this.hasNoListeners()) {
            this.engageModel();
        }
        super.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        if (this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(string, propertyChangeListener);
        if (string == "value" && this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    protected boolean hasListeners() {
        return this.hasAnyPropertyChangeListeners("value");
    }

    protected boolean hasNoListeners() {
        return !this.hasListeners();
    }

    protected void engageModel() {
        this.collectionHolder.addCollectionChangeListener("value", this.collectionChangeListener);
        this.value = this.buildValue();
    }

    protected abstract Object buildValue();

    protected void disengageModel() {
        this.collectionHolder.removeCollectionChangeListener("value", this.collectionChangeListener);
        this.value = null;
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.collectionHolder);
    }

    protected void itemsAdded(CollectionChangeEvent collectionChangeEvent) {
        this.propertyChanged();
    }

    protected void itemsRemoved(CollectionChangeEvent collectionChangeEvent) {
        this.propertyChanged();
    }

    protected void collectionChanged(CollectionChangeEvent collectionChangeEvent) {
        this.propertyChanged();
    }

    protected void propertyChanged() {
        Object object = this.value;
        this.value = this.buildValue();
        this.firePropertyChanged("value", object, this.value);
    }
}

