/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModelWrapper;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeListIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.ReadOnlyListIterator;

public class ExtendedListValueModelWrapper
extends ListValueModelWrapper {
    protected final List prefix;
    protected final List suffix;

    public ExtendedListValueModelWrapper(List list, ListValueModel listValueModel, List list2) {
        super(listValueModel);
        this.prefix = new ArrayList(list);
        this.suffix = new ArrayList(list2);
    }

    public ExtendedListValueModelWrapper(Object object, ListValueModel listValueModel, Object object2) {
        this(Collections.singletonList(object), listValueModel, Collections.singletonList(object2));
    }

    public ExtendedListValueModelWrapper(List list, ListValueModel listValueModel) {
        this(list, listValueModel, Collections.EMPTY_LIST);
    }

    public ExtendedListValueModelWrapper(Object object, ListValueModel listValueModel) {
        this(Collections.singletonList(object), listValueModel, Collections.EMPTY_LIST);
    }

    public ExtendedListValueModelWrapper(ListValueModel listValueModel, List list) {
        this(Collections.EMPTY_LIST, listValueModel, list);
    }

    public ExtendedListValueModelWrapper(ListValueModel listValueModel, Object object) {
        this(Collections.EMPTY_LIST, listValueModel, Collections.singletonList(object));
    }

    public ExtendedListValueModelWrapper(ListValueModel listValueModel) {
        this(Collections.singletonList(null), listValueModel, Collections.EMPTY_LIST);
    }

    public Object getValue() {
        return new ReadOnlyListIterator((ListIterator)new CompositeListIterator(this.prefix.listIterator(), (ListIterator)this.listHolder.getValue(), this.suffix.listIterator()));
    }

    public void addItem(int n, Object object) {
        this.addItems(n, Collections.singletonList(object));
    }

    public void addItems(int n, List list) {
        if (list.size() == 0) {
            return;
        }
        int n2 = this.prefix.size();
        if (n < n2) {
            throw new IllegalArgumentException("the prefix cannot be modified");
        }
        if (n > n2 + this.listHolder.size()) {
            throw new IllegalArgumentException("the suffix cannot be modified");
        }
        this.listHolder.addItems(n - n2, list);
    }

    public Object removeItem(int n) {
        int n2 = this.prefix.size();
        if (n < n2) {
            throw new IllegalArgumentException("the prefix cannot be modified");
        }
        if (n >= n2 + this.listHolder.size()) {
            throw new IllegalArgumentException("the suffix cannot be modified");
        }
        return this.listHolder.removeItem(n - n2);
    }

    public List removeItems(int n, int n2) {
        if (n2 == 0) {
            return Collections.EMPTY_LIST;
        }
        int n3 = this.prefix.size();
        if (n < n3) {
            throw new IllegalArgumentException("the prefix cannot be modified");
        }
        if (n + n2 > n3 + this.listHolder.size()) {
            throw new IllegalArgumentException("the suffix cannot be modified");
        }
        return this.listHolder.removeItems(n - n3, n2);
    }

    public Object replaceItem(int n, Object object) {
        int n2 = this.prefix.size();
        if (n < n2) {
            throw new IllegalArgumentException("the prefix cannot be modified");
        }
        if (n >= n2 + this.listHolder.size()) {
            throw new IllegalArgumentException("the suffix cannot be modified");
        }
        return this.listHolder.replaceItem(n - n2, object);
    }

    public List replaceItems(int n, List list) {
        if (list.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        int n2 = this.prefix.size();
        if (n < n2) {
            throw new IllegalArgumentException("the prefix cannot be modified");
        }
        if (n + list.size() > n2 + this.listHolder.size()) {
            throw new IllegalArgumentException("the suffix cannot be modified");
        }
        return this.listHolder.replaceItems(n - n2, list);
    }

    public Object getItem(int n) {
        int n2 = this.prefix.size();
        if (n < n2) {
            return this.prefix.get(n);
        }
        if (n >= n2 + this.listHolder.size()) {
            return this.suffix.get(n - (n2 + this.listHolder.size()));
        }
        return this.listHolder.getItem(n - n2);
    }

    public int size() {
        return this.prefix.size() + this.listHolder.size() + this.suffix.size();
    }

    protected void itemsAdded(ListChangeEvent listChangeEvent) {
        this.fireItemsAdded(listChangeEvent.cloneWithSource((Object)this, "value", this.prefix.size()));
    }

    protected void itemsRemoved(ListChangeEvent listChangeEvent) {
        this.fireItemsRemoved(listChangeEvent.cloneWithSource((Object)this, "value", this.prefix.size()));
    }

    protected void itemsReplaced(ListChangeEvent listChangeEvent) {
        this.fireItemsReplaced(listChangeEvent.cloneWithSource((Object)this, "value", this.prefix.size()));
    }

    protected void listChanged(ListChangeEvent listChangeEvent) {
        this.fireListChanged("value");
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.prefix);
        stringBuffer.append(" ");
        super.toString(stringBuffer);
        stringBuffer.append(" ");
        stringBuffer.append(this.suffix);
    }
}

