/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModelWrapper;
import org.eclipse.persistence.tools.workbench.uitools.app.ListCollectionValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;

public class FilteringCollectionValueModel
extends CollectionValueModelWrapper {
    private Filter filter;
    private Filter localFilter;
    private Collection filteredItems;

    public FilteringCollectionValueModel(CollectionValueModel collectionValueModel) {
        this(collectionValueModel, Filter.NULL_INSTANCE);
    }

    public FilteringCollectionValueModel(CollectionValueModel collectionValueModel, Filter filter) {
        super(collectionValueModel);
        this.filter = filter;
    }

    public FilteringCollectionValueModel(ListValueModel listValueModel) {
        this(new ListCollectionValueModelAdapter(listValueModel));
    }

    public FilteringCollectionValueModel(ListValueModel listValueModel, Filter filter) {
        this(new ListCollectionValueModelAdapter(listValueModel), filter);
    }

    protected void initialize() {
        super.initialize();
        this.localFilter = this.buildLocalFilter();
        this.filteredItems = new ArrayList();
    }

    protected Filter buildLocalFilter() {
        return new Filter(){

            public boolean accept(Object object) {
                return FilteringCollectionValueModel.this.accept(object);
            }
        };
    }

    public Object getValue() {
        return this.filteredItems.iterator();
    }

    public int size() {
        return this.filteredItems.size();
    }

    protected void engageModel() {
        super.engageModel();
        this.synchFilteredItems();
    }

    protected void disengageModel() {
        super.disengageModel();
        this.filteredItems.clear();
    }

    protected void itemsAdded(CollectionChangeEvent collectionChangeEvent) {
        this.addItemsToCollection(this.filter(collectionChangeEvent.items()), this.filteredItems, "value");
    }

    protected void itemsRemoved(CollectionChangeEvent collectionChangeEvent) {
        this.removeItemsFromCollection(collectionChangeEvent.items(), this.filteredItems, "value");
    }

    protected void collectionChanged(CollectionChangeEvent collectionChangeEvent) {
        this.synchFilteredItems();
        this.fireCollectionChanged("value");
    }

    protected boolean accept(Object object) {
        return this.filter.accept(object);
    }

    protected Iterator filter(Iterator iterator) {
        return new FilteringIterator(iterator, this.localFilter);
    }

    protected void synchFilteredItems() {
        this.filteredItems.clear();
        CollectionTools.addAll((Collection)this.filteredItems, (Iterator)this.filter((Iterator)this.collectionHolder.getValue()));
    }
}

